/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.littlejoys.LittleJoysConfig;
import net.blay09.mods.littlejoys.block.ModBlocks;
import net.blay09.mods.littlejoys.block.entity.DigSpotBlockEntity;
import net.blay09.mods.littlejoys.handler.ChunkLimitManager;
import net.blay09.mods.littlejoys.mixin.RecipeManagerAccessor;
import net.blay09.mods.littlejoys.recipe.DigSpotRecipe;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventContextImpl;
import net.blay09.mods.littlejoys.stats.ModStats;
import net.blay09.mods.littlejoys.tag.ModPoiTypeTags;
import net.minecraft.class_10289;
import net.minecraft.class_1657;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4153;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6011;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class DigSpotHandler {
    private static final class_5819 random = class_5819.method_43047();
    private static final String DIG_SPOT_COOLDOWN = "digSpotCooldown";

    public static void initialize() {
        Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.End, player -> {
            class_2487 playerData = Balm.getHooks().getPersistentData((class_1657)player);
            class_2487 littleJoysData = playerData.method_68568("littlejoys");
            playerData.method_10566("littlejoys", (class_2520)littleJoysData);
            int cooldown = littleJoysData.method_68083(DIG_SPOT_COOLDOWN, 0);
            if (cooldown > 0) {
                littleJoysData.method_10569(DIG_SPOT_COOLDOWN, cooldown - 1);
            } else {
                class_3218 level = player.method_51469();
                class_4153 poiManager = level.method_19494();
                class_2338 centerPos = DigSpotHandler.getOriginForNextSpawn((class_1657)player);
                int checkRange = LittleJoysConfig.getActive().digSpots.minimumDistanceBetween;
                int spawnRange = LittleJoysConfig.getActive().digSpots.spawnDistance;
                Optional digSpotInRange = poiManager.method_19125(it -> it.method_40220(ModPoiTypeTags.DIG_SPOTS), centerPos, checkRange, class_4153.class_4155.field_18489).findAny();
                if (digSpotInRange.isEmpty()) {
                    class_2338 surfacePos = DigSpotHandler.getVerticallyNearRandomOffsetPos(level, centerPos, spawnRange);
                    class_2338 aboveSurfacePos = surfacePos.method_10084();
                    int totalSpots = ChunkLimitManager.get(level).getTotalDigSpotsInChunk(aboveSurfacePos);
                    int maxSpots = LittleJoysConfig.getActive().digSpots.totalLimitPerChunk;
                    if (maxSpots > 0 && totalSpots >= maxSpots) {
                        littleJoysData.method_10569(DIG_SPOT_COOLDOWN, 200);
                        return;
                    }
                    if (!level.method_8320(aboveSurfacePos).method_45474()) {
                        littleJoysData.method_10569(DIG_SPOT_COOLDOWN, 20);
                        return;
                    }
                    if (DigSpotHandler.createDigSpot(level, aboveSurfacePos, player)) {
                        littleJoysData.method_10569(DIG_SPOT_COOLDOWN, Math.round(LittleJoysConfig.getActive().digSpots.spawnIntervalSeconds * 20.0f));
                    } else {
                        littleJoysData.method_10569(DIG_SPOT_COOLDOWN, 20);
                    }
                } else {
                    littleJoysData.method_10569(DIG_SPOT_COOLDOWN, 200);
                }
            }
        });
    }

    public static boolean createDigSpot(class_3218 level, class_2338 pos, class_3222 player) {
        return DigSpotHandler.findRecipe(level, pos, player).map(recipeHolder -> {
            DigSpotHandler.createDigSpot(level, pos, (class_8786<DigSpotRecipe>)recipeHolder);
            return true;
        }).orElse(false);
    }

    public static void createDigSpot(class_3218 level, class_2338 pos, class_8786<DigSpotRecipe> recipeHolder) {
        level.method_8652(pos, ModBlocks.digSpot.method_9564(), 3);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof DigSpotBlockEntity) {
            DigSpotBlockEntity digSpot = (DigSpotBlockEntity)class_25862;
            digSpot.setRecipeId(recipeHolder.comp_1932());
        }
        ChunkLimitManager.get(level).trackDigSpot(pos);
    }

    private static class_2338 getOriginForNextSpawn(class_1657 player) {
        int projectForwardDistance = LittleJoysConfig.getActive().digSpots.projectForwardDistance;
        class_2350 forwardDirection = player.method_5735();
        return player.method_24515().method_10079(forwardDirection, projectForwardDistance);
    }

    private static class_2338 getVerticallyNearRandomOffsetPos(class_3218 level, class_2338 origin, int spawnRange) {
        class_2338 bestPos = null;
        int bestDist = Integer.MAX_VALUE;
        for (int i = 0; i < 5; ++i) {
            int offsetX = random.method_43048(spawnRange + spawnRange) - spawnRange;
            int offsetZ = random.method_43048(spawnRange + spawnRange) - spawnRange;
            class_2338 randomOffsetPos = new class_2338(origin.method_10263() + offsetX, origin.method_10263(), origin.method_10260() + offsetZ);
            class_2338 surfacePos = level.method_8598(class_2902.class_2903.field_13202, randomOffsetPos).method_10074();
            int surfaceDist = Math.abs(surfacePos.method_10264() - origin.method_10264());
            if (bestPos != null && surfaceDist >= bestDist) continue;
            bestPos = surfacePos;
            bestDist = surfaceDist;
        }
        return bestPos;
    }

    private static Optional<class_8786<DigSpotRecipe>> findRecipe(class_3218 level, class_2338 pos, class_3222 player) {
        class_1863 recipeManager = level.method_8503().method_3772();
        class_10289 recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        Collection recipes = recipeMap.method_64698(ModRecipeTypes.digSpotRecipeType);
        ArrayList<class_8786> candidates = new ArrayList<class_8786>();
        for (class_8786 recipe : recipes) {
            if (!DigSpotHandler.isValidRecipeFor((class_8786<DigSpotRecipe>)recipe, level, pos, player)) continue;
            candidates.add(recipe);
        }
        return class_6011.method_34986((class_5819)random, candidates, it -> ((DigSpotRecipe)it.comp_1933()).weight());
    }

    private static boolean isValidRecipeFor(class_8786<DigSpotRecipe> recipe, class_3218 level, class_2338 pos, class_3222 player) {
        EventContextImpl context = new EventContextImpl((class_1937)level, pos, level.method_8320(pos), (class_1657)player);
        return ((DigSpotRecipe)recipe.comp_1933()).eventCondition().test(context);
    }

    public static Optional<DigSpotRecipe> recipeById(class_3218 level, @Nullable class_5321<class_1860<?>> recipeId) {
        class_1860 class_18602;
        class_1863 recipeManager = level.method_64577();
        if (recipeId == null) {
            return Optional.empty();
        }
        class_8786 recipeHolder = recipeManager.method_8130(recipeId).orElse(null);
        if (recipeHolder != null && (class_18602 = recipeHolder.comp_1933()) instanceof DigSpotRecipe) {
            DigSpotRecipe digSpotRecipe = (DigSpotRecipe)class_18602;
            return Optional.of(digSpotRecipe);
        }
        return Optional.empty();
    }

    public static void digSpotConsumed(class_1657 player) {
        class_2487 playerData = Balm.getHooks().getPersistentData(player);
        class_2487 littleJoysData = playerData.method_68568("littlejoys");
        playerData.method_10566("littlejoys", (class_2520)littleJoysData);
        littleJoysData.method_10569(DIG_SPOT_COOLDOWN, Math.round(LittleJoysConfig.getActive().digSpots.afterDiggingCooldownSeconds * 20.0f));
        player.method_7281(ModStats.digSpotsDug);
    }
}

