/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.littlejoys.LittleJoysConfig;
import net.blay09.mods.littlejoys.entity.DropRushItemEntity;
import net.blay09.mods.littlejoys.handler.DropRushInstance;
import net.blay09.mods.littlejoys.mixin.RecipeManagerAccessor;
import net.blay09.mods.littlejoys.network.protocol.ClientboundStartDropRushPacket;
import net.blay09.mods.littlejoys.network.protocol.ClientboundStopDropRushPacket;
import net.blay09.mods.littlejoys.recipe.DropRushRecipe;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventContextImpl;
import net.blay09.mods.littlejoys.stats.ModStats;
import net.minecraft.class_10289;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1863;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6011;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_8710;
import net.minecraft.class_8786;

public class DropRushHandler {
    private static final class_5819 random = class_5819.method_43047();
    private static final int DROP_TICKS = 50;
    private static final Table<class_5321<class_1937>, class_2338, DropRushInstance> activeDropRushes = HashBasedTable.create();

    public static void initialize() {
        Balm.getEvents().onEvent(BreakBlockEvent.class, event -> {
            class_3218 serverLevel;
            class_1657 player;
            block7: {
                block6: {
                    if (event.getPlayer().method_31549().field_7477) {
                        return;
                    }
                    if (Balm.getHooks().isFakePlayer(event.getPlayer())) {
                        return;
                    }
                    Boolean hasSilkTouch = event.getLevel().method_30349().method_46759(class_7924.field_41265).flatMap(it -> it.method_46746(class_1893.field_9099)).map(it -> class_1890.method_8203((class_6880)it, (class_1309)event.getPlayer()) > 0).orElse(false);
                    if (hasSilkTouch.booleanValue()) {
                        return;
                    }
                    class_1937 level = event.getLevel();
                    player = event.getPlayer();
                    if (!(level instanceof class_3218)) break block6;
                    serverLevel = (class_3218)level;
                    if (player instanceof class_3222) break block7;
                }
                return;
            }
            class_3222 serverPlayer = (class_3222)player;
            DropRushHandler.rollForDropRush(serverLevel, event.getPos(), event.getState(), serverPlayer);
        });
        Balm.getEvents().onTickEvent(TickType.ServerLevel, TickPhase.Start, level -> {
            for (DropRushInstance dropRush : activeDropRushes.row((Object)level.method_27983()).values()) {
                class_1657 player;
                dropRush.setTicksPassed(dropRush.getTicksPassed() + 1);
                dropRush.setDropCooldownTicks(dropRush.getDropCooldownTicks() - 1);
                List<class_1799> dropsLeft = dropRush.getDrops();
                if (dropRush.getDropCooldownTicks() <= 0 && !dropsLeft.isEmpty()) {
                    class_1799 nextDropItemStack = dropsLeft.removeLast();
                    DropRushHandler.spawnDropRushItem(level, dropRush, nextDropItemStack);
                    dropRush.setDropCooldownTicks(dropRush.getTicksPerDrop());
                } else if (dropRush.getTicksPassed() >= 50) {
                    for (class_1799 itemStack : dropsLeft) {
                        DropRushHandler.spawnDropRushItem(level, dropRush, itemStack);
                    }
                }
                dropRush.getEntities().removeIf(DropRushItemEntity::isPickedUp);
                if (dropRush.getEntities().isEmpty()) {
                    player = level.method_18470(dropRush.getPlayerId());
                    if (player == null) continue;
                    Balm.getNetworking().sendTo(player, (class_8710)new ClientboundStopDropRushPacket(ClientboundStopDropRushPacket.Reason.FULL_CLEAR));
                    continue;
                }
                if (dropRush.getTicksPassed() < dropRush.getMaxTicks() || (player = level.method_18470(dropRush.getPlayerId())) == null) continue;
                Balm.getNetworking().sendTo(player, (class_8710)new ClientboundStopDropRushPacket(ClientboundStopDropRushPacket.Reason.TIME_UP));
            }
            activeDropRushes.values().removeIf(it -> it.getTicksPassed() >= it.getMaxTicks() || it.getEntities().isEmpty());
        });
    }

    public static boolean rollForDropRush(class_3218 level, class_2338 pos, class_2680 state, class_3222 player) {
        return DropRushHandler.rollRecipe(level, pos, state, player, false).map(recipeHolder -> {
            DropRushHandler.startDropRush(level, pos, player, (class_8786<DropRushRecipe>)recipeHolder);
            return true;
        }).orElse(false);
    }

    public static boolean startDropRush(class_3218 level, class_2338 pos, class_2680 state, class_3222 player) {
        return DropRushHandler.rollRecipe(level, pos, state, player, true).map(recipeHolder -> {
            DropRushHandler.startDropRush(level, pos, player, (class_8786<DropRushRecipe>)recipeHolder);
            return true;
        }).orElse(false);
    }

    public static void startDropRush(class_3218 level, class_2338 pos, class_3222 player, class_8786<DropRushRecipe> recipeHolder) {
        DropRushRecipe recipe = (DropRushRecipe)recipeHolder.comp_1933();
        DropRushInstance dropRushInstance = new DropRushInstance(player.method_5667(), pos, recipe.lootTable(), (int)Math.floor(20.0f * recipe.seconds()));
        class_8567.class_8568 lootParamsBuilder = new class_8567.class_8568(level).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos)).method_51874(class_181.field_1229, (Object)class_1799.field_8037).method_51877(class_181.field_1228, (Object)level.method_8321(pos));
        class_5321<class_52> lootTableId = recipe.lootTable();
        class_8567 lootParams = lootParamsBuilder.method_51874(class_181.field_1224, (Object)level.method_8320(pos)).method_51875(class_173.field_1172);
        class_52 lootTable = level.method_8503().method_58576().method_58295(lootTableId);
        for (int i = 0; i < recipe.rolls(); ++i) {
            lootTable.method_51878(lootParams).forEach(dropRushInstance::addDrop);
        }
        dropRushInstance.setTicksPerDrop(Math.max(50 / Math.max(1, dropRushInstance.getDrops().size()), 1));
        Balm.getNetworking().sendTo((class_1657)player, (class_8710)new ClientboundStartDropRushPacket(dropRushInstance.getMaxTicks()));
        player.method_7281(ModStats.dropRushesTriggered);
        activeDropRushes.put((Object)level.method_27983(), (Object)pos, (Object)dropRushInstance);
    }

    private static void spawnDropRushItem(class_1937 level, DropRushInstance dropRush, class_1799 itemStack) {
        float deltaX = (random.method_43057() - 0.5f) * 0.7f;
        float deltaY = random.method_43057() * 0.5f + 0.2f;
        float deltaZ = (random.method_43057() - 0.5f) * 0.7f;
        float x = (float)dropRush.getPos().method_10263() + 0.5f;
        float y = (float)dropRush.getPos().method_10264() + 0.25f;
        float z = (float)dropRush.getPos().method_10260() + 0.5f;
        DropRushItemEntity itemEntity = new DropRushItemEntity(level, x, y, z, itemStack, deltaX, deltaY, deltaZ);
        itemEntity.method_6982(20);
        itemEntity.method_35190();
        itemEntity.setActualLifetime(dropRush.getMaxTicks() - dropRush.getTicksPassed());
        itemEntity.method_48349(dropRush.getPlayerId());
        level.method_8649((class_1297)itemEntity);
        dropRush.addEntity(itemEntity);
    }

    private static Optional<class_8786<DropRushRecipe>> rollRecipe(class_3218 level, class_2338 pos, class_2680 state, class_3222 player, boolean force) {
        class_1863 recipeManager = level.method_8503().method_3772();
        class_10289 recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        Collection recipes = recipeMap.method_64698(ModRecipeTypes.dropRushRecipeType);
        ArrayList<class_8786> candidates = new ArrayList<class_8786>();
        float baseChance = LittleJoysConfig.getActive().dropRush.baseChance;
        float roll = random.method_43057();
        for (class_8786 recipeHolder : recipes) {
            if (!DropRushHandler.isValidRecipeFor((class_8786<DropRushRecipe>)recipeHolder, level, pos, state, player) || !force && !(roll <= baseChance * ((DropRushRecipe)recipeHolder.comp_1933()).chanceMultiplier())) continue;
            candidates.add(recipeHolder);
        }
        return class_6011.method_34986((class_5819)random, candidates, it -> ((DropRushRecipe)it.comp_1933()).weight());
    }

    private static boolean isValidRecipeFor(class_8786<DropRushRecipe> recipe, class_3218 level, class_2338 pos, class_2680 state, class_3222 player) {
        EventContextImpl context = new EventContextImpl((class_1937)level, pos, state, (class_1657)player);
        return ((DropRushRecipe)recipe.comp_1933()).eventCondition().test(context);
    }
}

