/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.littlejoys.LittleJoysConfig;
import net.blay09.mods.littlejoys.block.ModBlocks;
import net.blay09.mods.littlejoys.block.entity.FishingSpotBlockEntity;
import net.blay09.mods.littlejoys.handler.ChunkLimitManager;
import net.blay09.mods.littlejoys.mixin.RecipeManagerAccessor;
import net.blay09.mods.littlejoys.particle.ModParticles;
import net.blay09.mods.littlejoys.recipe.FishingSpotRecipe;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventContextImpl;
import net.blay09.mods.littlejoys.stats.ModStats;
import net.blay09.mods.littlejoys.tag.ModPoiTypeTags;
import net.minecraft.class_10289;
import net.minecraft.class_1657;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4153;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6011;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class FishingSpotHandler {
    private static final class_5819 random = class_5819.method_43047();
    private static final String FISHING_SPOT_COOLDOWN = "fishingSpotCooldown";

    public static void initialize() {
        Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.End, player -> {
            class_2487 playerData = Balm.getHooks().getPersistentData((class_1657)player);
            class_2487 littleJoysData = playerData.method_68568("littlejoys");
            playerData.method_10566("littlejoys", (class_2520)littleJoysData);
            int cooldown = littleJoysData.method_68083(FISHING_SPOT_COOLDOWN, 0);
            if (cooldown > 0) {
                littleJoysData.method_10569(FISHING_SPOT_COOLDOWN, cooldown - 1);
            } else {
                class_3218 level = player.method_51469();
                class_4153 poiManager = level.method_19494();
                class_2338 centerPos = FishingSpotHandler.getOriginForNextSpawn((class_1657)player);
                int checkRange = LittleJoysConfig.getActive().fishingSpots.minimumDistanceBetween;
                int spawnRange = LittleJoysConfig.getActive().fishingSpots.spawnDistance;
                Optional fishingSpotInRange = poiManager.method_19125(it -> it.method_40220(ModPoiTypeTags.FISHING_SPOTS), centerPos, checkRange, class_4153.class_4155.field_18489).findAny();
                if (fishingSpotInRange.isEmpty()) {
                    int offsetX = random.method_43048(spawnRange + spawnRange) - spawnRange;
                    int offsetZ = random.method_43048(spawnRange + spawnRange) - spawnRange;
                    class_2338 randomOffsetPos = new class_2338(centerPos.method_10263() + offsetX, centerPos.method_10263(), centerPos.method_10260() + offsetZ);
                    class_2338 surfacePos = level.method_8598(class_2902.class_2903.field_13202, randomOffsetPos).method_10074();
                    class_2338 aboveSurfacePos = surfacePos.method_10084();
                    int totalSpots = ChunkLimitManager.get(level).getTotalFishingSpotsInChunk(aboveSurfacePos);
                    int maxSpots = LittleJoysConfig.getActive().fishingSpots.totalLimitPerChunk;
                    if (maxSpots > 0 && totalSpots >= maxSpots) {
                        littleJoysData.method_10569(FISHING_SPOT_COOLDOWN, 200);
                        return;
                    }
                    if (!level.method_8320(aboveSurfacePos).method_45474()) {
                        littleJoysData.method_10569(FISHING_SPOT_COOLDOWN, 20);
                        return;
                    }
                    if (FishingSpotHandler.createFishingSpot(level, aboveSurfacePos, player)) {
                        littleJoysData.method_10569(FISHING_SPOT_COOLDOWN, Math.round(LittleJoysConfig.getActive().fishingSpots.spawnIntervalSeconds * 20.0f));
                    } else {
                        littleJoysData.method_10569(FISHING_SPOT_COOLDOWN, 20);
                    }
                } else {
                    littleJoysData.method_10569(FISHING_SPOT_COOLDOWN, 200);
                }
            }
        });
    }

    public static boolean createFishingSpot(class_3218 level, class_2338 pos, class_3222 player) {
        return FishingSpotHandler.findRecipe(level, pos, player).map(recipeHolder -> {
            FishingSpotHandler.createFishingSpot(level, pos, (class_8786<FishingSpotRecipe>)recipeHolder);
            return true;
        }).orElse(false);
    }

    public static void createFishingSpot(class_3218 level, class_2338 pos, class_8786<FishingSpotRecipe> recipeHolder) {
        level.method_8652(pos, ModBlocks.fishingSpot.method_9564(), 3);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof FishingSpotBlockEntity) {
            FishingSpotBlockEntity fishingSpot = (FishingSpotBlockEntity)class_25862;
            fishingSpot.setRecipeId(recipeHolder.comp_1932());
        }
        ChunkLimitManager.get(level).trackFishingSpot(pos);
    }

    private static class_2338 getOriginForNextSpawn(class_1657 player) {
        int projectForwardDistance = LittleJoysConfig.getActive().fishingSpots.projectForwardDistance;
        class_2350 forwardDirection = player.method_5735();
        return player.method_24515().method_10079(forwardDirection, projectForwardDistance);
    }

    private static Optional<class_8786<FishingSpotRecipe>> findRecipe(class_3218 level, class_2338 pos, class_3222 player) {
        class_1863 recipeManager = level.method_8503().method_3772();
        class_10289 recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        Collection recipes = recipeMap.method_64698(ModRecipeTypes.fishingSpotRecipeType);
        ArrayList<class_8786> candidates = new ArrayList<class_8786>();
        for (class_8786 recipe : recipes) {
            if (!FishingSpotHandler.isValidRecipeFor((class_8786<FishingSpotRecipe>)recipe, level, pos, player)) continue;
            candidates.add(recipe);
        }
        return class_6011.method_34986((class_5819)random, candidates, it -> ((FishingSpotRecipe)it.comp_1933()).weight());
    }

    private static boolean isValidRecipeFor(class_8786<FishingSpotRecipe> recipe, class_3218 level, class_2338 pos, class_3222 player) {
        EventContextImpl context = new EventContextImpl((class_1937)level, pos, level.method_8320(pos), (class_1657)player);
        return ((FishingSpotRecipe)recipe.comp_1933()).eventCondition().test(context);
    }

    private static Optional<class_8786<FishingSpotRecipe>> recipeById(class_3218 level, @Nullable class_5321<class_1860<?>> recipeId) {
        class_1863 recipeManager = level.method_64577();
        if (recipeId == null) {
            return Optional.empty();
        }
        class_8786 recipeHolder = recipeManager.method_8130(recipeId).orElse(null);
        if (recipeHolder != null && recipeHolder.comp_1933() instanceof FishingSpotRecipe) {
            return Optional.of(recipeHolder);
        }
        return Optional.empty();
    }

    public static Optional<class_8786<FishingSpotRecipe>> resolveRecipe(class_3218 level, class_2338 pos, @Nullable class_5321<class_1860<?>> recipeId, class_3222 player) {
        Optional<class_8786<FishingSpotRecipe>> optRecipe = FishingSpotHandler.recipeById(level, recipeId);
        if (optRecipe.isPresent() && FishingSpotHandler.isValidRecipeFor(optRecipe.get(), level, pos, player)) {
            return optRecipe;
        }
        return FishingSpotHandler.findRecipe(level, pos, player);
    }

    public static Optional<class_2338> findFishingSpot(class_3218 serverLevel, class_2338 pos) {
        class_4153 poiManager = serverLevel.method_19494();
        int range = LittleJoysConfig.getActive().fishingSpots.fishingRangeTolerance;
        return poiManager.method_20006(it -> it.method_40220(ModPoiTypeTags.FISHING_SPOTS), pos, range, class_4153.class_4155.field_18489);
    }

    public static int claimFishingSpot(class_3218 level, class_2338 pos) {
        level.method_65096((class_2394)ModParticles.goldRush, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f), 2, 0.25, 0.25, 0.25, 0.0);
        if (LittleJoysConfig.getActive().fishingSpots.secondsUntilLured < 0.0f) {
            return -1;
        }
        return Math.round(LittleJoysConfig.getActive().fishingSpots.secondsUntilLured * 20.0f);
    }

    public static void consumeFishingSpot(@Nullable class_1657 player, class_3218 level, class_2338 pos) {
        float x = (float)pos.method_10263() + 0.5f;
        float y = (float)pos.method_10264() + 0.5f;
        float z = (float)pos.method_10260() + 0.5f;
        level.method_65096((class_2394)class_2398.field_11204, (double)x, (double)y, (double)z, 8, 0.25, 0.25, 0.25, 0.0);
        level.method_22352(pos, false);
        if (player != null) {
            player.method_7281(ModStats.fishingSpotsFished);
            class_2487 playerData = Balm.getHooks().getPersistentData(player);
            class_2487 littleJoysData = playerData.method_68568("littlejoys");
            playerData.method_10566("littlejoys", (class_2520)littleJoysData);
            littleJoysData.method_10569(FISHING_SPOT_COOLDOWN, Math.round(LittleJoysConfig.getActive().fishingSpots.afterFishingCooldownSeconds * 20.0f));
        }
    }
}

