/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.littlejoys.LittleJoysConfig;
import net.blay09.mods.littlejoys.handler.GoldRushInstance;
import net.blay09.mods.littlejoys.mixin.RecipeManagerAccessor;
import net.blay09.mods.littlejoys.network.protocol.ClientboundGoldRushPacket;
import net.blay09.mods.littlejoys.recipe.GoldRushRecipe;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventContextImpl;
import net.blay09.mods.littlejoys.stats.ModStats;
import net.minecraft.class_10289;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1863;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6011;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_8710;
import net.minecraft.class_8786;

public class GoldRushHandler {
    private static final class_5819 random = class_5819.method_43047();
    private static final Table<class_5321<class_1937>, class_2338, GoldRushInstance> activeGoldRushes = HashBasedTable.create();

    public static void initialize() {
        Balm.getEvents().onEvent(BreakBlockEvent.class, event -> {
            class_3218 serverLevel;
            class_1657 player;
            class_1937 level;
            block11: {
                block10: {
                    if (event.getPlayer().method_31549().field_7477) {
                        return;
                    }
                    if (Balm.getHooks().isFakePlayer(event.getPlayer())) {
                        return;
                    }
                    Boolean hasSilkTouch = event.getLevel().method_30349().method_46759(class_7924.field_41265).flatMap(it -> it.method_46746(class_1893.field_9099)).map(it -> class_1890.method_8203((class_6880)it, (class_1309)event.getPlayer()) > 0).orElse(false);
                    if (hasSilkTouch.booleanValue()) {
                        return;
                    }
                    level = event.getLevel();
                    player = event.getPlayer();
                    if (!(level instanceof class_3218)) break block10;
                    serverLevel = (class_3218)level;
                    if (player instanceof class_3222) break block11;
                }
                return;
            }
            class_3222 serverPlayer = (class_3222)player;
            GoldRushInstance activeGoldRush = (GoldRushInstance)activeGoldRushes.get((Object)level.method_27983(), (Object)event.getPos());
            if (activeGoldRush == null) {
                activeGoldRush = GoldRushHandler.rollForGoldRush(serverLevel, event.getPos(), event.getState(), serverPlayer).orElse(null);
            }
            if (activeGoldRush != null) {
                if (activeGoldRush.getDropCooldownTicks() <= 0) {
                    class_2338 pos = activeGoldRush.getPos();
                    class_8567.class_8568 lootParamsBuilder = new class_8567.class_8568((class_3218)level).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos)).method_51874(class_181.field_1229, (Object)class_1799.field_8037).method_51877(class_181.field_1228, (Object)level.method_8321(pos));
                    Optional<class_5321<class_52>> lootTableId = activeGoldRush.getLootTable();
                    if (lootTableId.isPresent()) {
                        class_8567 lootParams = lootParamsBuilder.method_51874(class_181.field_1224, (Object)level.method_8320(pos)).method_51875(class_173.field_1172);
                        class_52 lootTable = level.method_8503().method_58576().method_58295(lootTableId.get());
                        lootTable.method_51878(lootParams).forEach(itemStack -> class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)itemStack));
                    }
                    activeGoldRush.setDropCooldownTicks(activeGoldRush.getTicksPerDrop());
                }
                event.setCanceled(true);
            }
        });
        Balm.getEvents().onTickEvent(TickType.ServerLevel, TickPhase.Start, level -> {
            for (GoldRushInstance goldRush : activeGoldRushes.row((Object)level.method_27983()).values()) {
                goldRush.setTicksPassed(goldRush.getTicksPassed() + 1);
                goldRush.setDropCooldownTicks(goldRush.getDropCooldownTicks() - 1);
                if (goldRush.getTicksPassed() < goldRush.getMaxTicks()) continue;
                if (level.method_8320(goldRush.getPos()).equals((Object)goldRush.getInitialState())) {
                    level.method_8651(goldRush.getPos(), true, (class_1297)goldRush.getPlayer());
                }
                Balm.getNetworking().sendToAll(level.method_8503(), (class_8710)new ClientboundGoldRushPacket(goldRush.getPos(), false));
            }
            activeGoldRushes.values().removeIf(it -> it.getTicksPassed() >= it.getMaxTicks());
        });
    }

    public static Optional<GoldRushInstance> rollForGoldRush(class_3218 level, class_2338 pos, class_2680 state, class_3222 player) {
        return GoldRushHandler.rollRecipe(level, pos, state, player, false).map(recipe -> GoldRushHandler.startGoldRush(level, pos, state, player, (class_8786<GoldRushRecipe>)recipe));
    }

    public static boolean isInGoldRush(class_3218 level, class_2338 pos) {
        return activeGoldRushes.contains((Object)level.method_27983(), (Object)pos);
    }

    public static Optional<GoldRushInstance> startGoldRush(class_3218 level, class_2338 pos, class_2680 state, class_3222 player) {
        return GoldRushHandler.rollRecipe(level, pos, state, player, true).map(recipe -> GoldRushHandler.startGoldRush(level, pos, state, player, (class_8786<GoldRushRecipe>)recipe));
    }

    public static GoldRushInstance startGoldRush(class_3218 level, class_2338 pos, class_2680 state, class_3222 player, class_8786<GoldRushRecipe> recipeHolder) {
        GoldRushRecipe recipe = (GoldRushRecipe)recipeHolder.comp_1933();
        GoldRushInstance activeGoldRush = new GoldRushInstance(pos, state, Optional.of(recipe.lootTable()), (int)Math.floor(20.0f * recipe.seconds()), recipe.maxDropsPerSecond() == -1.0f ? 0 : (int)Math.floor(20.0f / recipe.maxDropsPerSecond()), (class_1657)player);
        Balm.getNetworking().sendToTracking(level, pos, (class_8710)new ClientboundGoldRushPacket(pos, true));
        player.method_7281(ModStats.goldRushesTriggered);
        activeGoldRushes.put((Object)level.method_27983(), (Object)pos, (Object)activeGoldRush);
        return activeGoldRush;
    }

    private static Optional<class_8786<GoldRushRecipe>> rollRecipe(class_3218 level, class_2338 pos, class_2680 state, class_3222 player, boolean force) {
        class_1863 recipeManager = level.method_8503().method_3772();
        class_10289 recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        Collection recipes = recipeMap.method_64698(ModRecipeTypes.goldRushRecipeType);
        ArrayList<class_8786> candidates = new ArrayList<class_8786>();
        float baseChance = LittleJoysConfig.getActive().goldRush.baseChance;
        float roll = random.method_43057();
        for (class_8786 recipeHolder : recipes) {
            if (!GoldRushHandler.isValidRecipeFor((class_8786<GoldRushRecipe>)recipeHolder, level, pos, state, player) || !force && !(roll <= baseChance * ((GoldRushRecipe)recipeHolder.comp_1933()).chanceMultiplier())) continue;
            candidates.add(recipeHolder);
        }
        return class_6011.method_34986((class_5819)random, candidates, it -> ((GoldRushRecipe)it.comp_1933()).weight());
    }

    private static boolean isValidRecipeFor(class_8786<GoldRushRecipe> recipe, class_3218 level, class_2338 pos, class_2680 state, class_3222 player) {
        EventContextImpl context = new EventContextImpl((class_1937)level, pos, state, (class_1657)player);
        return ((GoldRushRecipe)recipe.comp_1933()).eventCondition().test(context);
    }
}

