/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.littlejoys.LittleJoysConfig;
import net.blay09.mods.littlejoys.block.ModBlocks;
import net.blay09.mods.littlejoys.block.entity.FishingSpotBlockEntity;
import net.blay09.mods.littlejoys.handler.ChunkLimitManager;
import net.blay09.mods.littlejoys.mixin.RecipeManagerAccessor;
import net.blay09.mods.littlejoys.particle.ModParticles;
import net.blay09.mods.littlejoys.recipe.FishingSpotRecipe;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventContextImpl;
import net.blay09.mods.littlejoys.stats.ModStats;
import net.blay09.mods.littlejoys.tag.ModPoiTypeTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class FishingSpotHandler {
    private static final RandomSource random = RandomSource.create();
    private static final String FISHING_SPOT_COOLDOWN = "fishingSpotCooldown";

    public static void initialize() {
        Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.End, player -> {
            CompoundTag playerData = Balm.getHooks().getPersistentData((Player)player);
            CompoundTag littleJoysData = playerData.getCompoundOrEmpty("littlejoys");
            playerData.put("littlejoys", (Tag)littleJoysData);
            int cooldown = littleJoysData.getIntOr(FISHING_SPOT_COOLDOWN, 0);
            if (cooldown > 0) {
                littleJoysData.putInt(FISHING_SPOT_COOLDOWN, cooldown - 1);
            } else {
                ServerLevel level = player.level();
                PoiManager poiManager = level.getPoiManager();
                BlockPos centerPos = FishingSpotHandler.getOriginForNextSpawn((Player)player);
                int checkRange = LittleJoysConfig.getActive().fishingSpots.minimumDistanceBetween;
                int spawnRange = LittleJoysConfig.getActive().fishingSpots.spawnDistance;
                Optional fishingSpotInRange = poiManager.getInRange(it -> it.is(ModPoiTypeTags.FISHING_SPOTS), centerPos, checkRange, PoiManager.Occupancy.ANY).findAny();
                if (fishingSpotInRange.isEmpty()) {
                    int offsetX = random.nextInt(spawnRange + spawnRange) - spawnRange;
                    int offsetZ = random.nextInt(spawnRange + spawnRange) - spawnRange;
                    BlockPos randomOffsetPos = new BlockPos(centerPos.getX() + offsetX, centerPos.getX(), centerPos.getZ() + offsetZ);
                    BlockPos surfacePos = level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, randomOffsetPos).below();
                    BlockPos aboveSurfacePos = surfacePos.above();
                    int totalSpots = ChunkLimitManager.get(level).getTotalFishingSpotsInChunk(aboveSurfacePos);
                    int maxSpots = LittleJoysConfig.getActive().fishingSpots.totalLimitPerChunk;
                    if (maxSpots > 0 && totalSpots >= maxSpots) {
                        littleJoysData.putInt(FISHING_SPOT_COOLDOWN, 200);
                        return;
                    }
                    if (!level.getBlockState(aboveSurfacePos).canBeReplaced()) {
                        littleJoysData.putInt(FISHING_SPOT_COOLDOWN, 20);
                        return;
                    }
                    if (FishingSpotHandler.createFishingSpot(level, aboveSurfacePos, player)) {
                        littleJoysData.putInt(FISHING_SPOT_COOLDOWN, Math.round(LittleJoysConfig.getActive().fishingSpots.spawnIntervalSeconds * 20.0f));
                    } else {
                        littleJoysData.putInt(FISHING_SPOT_COOLDOWN, 20);
                    }
                } else {
                    littleJoysData.putInt(FISHING_SPOT_COOLDOWN, 200);
                }
            }
        });
    }

    public static boolean createFishingSpot(ServerLevel level, BlockPos pos, ServerPlayer player) {
        return FishingSpotHandler.findRecipe(level, pos, player).map(recipeHolder -> {
            FishingSpotHandler.createFishingSpot(level, pos, (RecipeHolder<FishingSpotRecipe>)recipeHolder);
            return true;
        }).orElse(false);
    }

    public static void createFishingSpot(ServerLevel level, BlockPos pos, RecipeHolder<FishingSpotRecipe> recipeHolder) {
        level.setBlock(pos, ModBlocks.fishingSpot.defaultBlockState(), 3);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FishingSpotBlockEntity) {
            FishingSpotBlockEntity fishingSpot = (FishingSpotBlockEntity)blockEntity;
            fishingSpot.setRecipeId(recipeHolder.id());
        }
        ChunkLimitManager.get(level).trackFishingSpot(pos);
    }

    private static BlockPos getOriginForNextSpawn(Player player) {
        int projectForwardDistance = LittleJoysConfig.getActive().fishingSpots.projectForwardDistance;
        Direction forwardDirection = player.getDirection();
        return player.blockPosition().relative(forwardDirection, projectForwardDistance);
    }

    private static Optional<RecipeHolder<FishingSpotRecipe>> findRecipe(ServerLevel level, BlockPos pos, ServerPlayer player) {
        RecipeManager recipeManager = level.getServer().getRecipeManager();
        RecipeMap recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        Collection recipes = recipeMap.byType(ModRecipeTypes.fishingSpotRecipeType);
        ArrayList<RecipeHolder> candidates = new ArrayList<RecipeHolder>();
        for (RecipeHolder recipe : recipes) {
            if (!FishingSpotHandler.isValidRecipeFor((RecipeHolder<FishingSpotRecipe>)recipe, level, pos, player)) continue;
            candidates.add(recipe);
        }
        return WeightedRandom.getRandomItem((RandomSource)random, candidates, it -> ((FishingSpotRecipe)it.value()).weight());
    }

    private static boolean isValidRecipeFor(RecipeHolder<FishingSpotRecipe> recipe, ServerLevel level, BlockPos pos, ServerPlayer player) {
        EventContextImpl context = new EventContextImpl((Level)level, pos, level.getBlockState(pos), (Player)player);
        return ((FishingSpotRecipe)recipe.value()).eventCondition().test(context);
    }

    private static Optional<RecipeHolder<FishingSpotRecipe>> recipeById(ServerLevel level, @Nullable ResourceKey<Recipe<?>> recipeId) {
        RecipeManager recipeManager = level.recipeAccess();
        if (recipeId == null) {
            return Optional.empty();
        }
        RecipeHolder recipeHolder = recipeManager.byKey(recipeId).orElse(null);
        if (recipeHolder != null && recipeHolder.value() instanceof FishingSpotRecipe) {
            return Optional.of(recipeHolder);
        }
        return Optional.empty();
    }

    public static Optional<RecipeHolder<FishingSpotRecipe>> resolveRecipe(ServerLevel level, BlockPos pos, @Nullable ResourceKey<Recipe<?>> recipeId, ServerPlayer player) {
        Optional<RecipeHolder<FishingSpotRecipe>> optRecipe = FishingSpotHandler.recipeById(level, recipeId);
        if (optRecipe.isPresent() && FishingSpotHandler.isValidRecipeFor(optRecipe.get(), level, pos, player)) {
            return optRecipe;
        }
        return FishingSpotHandler.findRecipe(level, pos, player);
    }

    public static Optional<BlockPos> findFishingSpot(ServerLevel serverLevel, BlockPos pos) {
        PoiManager poiManager = serverLevel.getPoiManager();
        int range = LittleJoysConfig.getActive().fishingSpots.fishingRangeTolerance;
        return poiManager.findClosest(it -> it.is(ModPoiTypeTags.FISHING_SPOTS), pos, range, PoiManager.Occupancy.ANY);
    }

    public static int claimFishingSpot(ServerLevel level, BlockPos pos) {
        level.sendParticles((ParticleOptions)ModParticles.goldRush, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 2, 0.25, 0.25, 0.25, 0.0);
        if (LittleJoysConfig.getActive().fishingSpots.secondsUntilLured < 0.0f) {
            return -1;
        }
        return Math.round(LittleJoysConfig.getActive().fishingSpots.secondsUntilLured * 20.0f);
    }

    public static void consumeFishingSpot(@Nullable Player player, ServerLevel level, BlockPos pos) {
        float x = (float)pos.getX() + 0.5f;
        float y = (float)pos.getY() + 0.5f;
        float z = (float)pos.getZ() + 0.5f;
        level.sendParticles((ParticleOptions)ParticleTypes.CLOUD, (double)x, (double)y, (double)z, 8, 0.25, 0.25, 0.25, 0.0);
        level.destroyBlock(pos, false);
        if (player != null) {
            player.awardStat(ModStats.fishingSpotsFished);
            CompoundTag playerData = Balm.getHooks().getPersistentData(player);
            CompoundTag littleJoysData = playerData.getCompoundOrEmpty("littlejoys");
            playerData.put("littlejoys", (Tag)littleJoysData);
            littleJoysData.putInt(FISHING_SPOT_COOLDOWN, Math.round(LittleJoysConfig.getActive().fishingSpots.afterFishingCooldownSeconds * 20.0f));
        }
    }
}

