/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.Nullable;

public final class GoldRushInstance {
    private final BlockPos pos;
    private final BlockState initialState;
    private final ResourceKey<LootTable> lootTable;
    private final int maxTicks;
    private final int ticksPerDrop;
    private final Player player;
    private int ticksPassed;
    private int dropCooldownTicks;

    public GoldRushInstance(BlockPos pos, BlockState initialState, Optional<ResourceKey<LootTable>> lootTable, int maxTicks, int ticksPerDrop, @Nullable Player player) {
        this.pos = pos;
        this.initialState = initialState;
        this.lootTable = lootTable.orElse(null);
        this.maxTicks = maxTicks;
        this.ticksPerDrop = ticksPerDrop;
        this.player = player;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockState getInitialState() {
        return this.initialState;
    }

    public Optional<ResourceKey<LootTable>> getLootTable() {
        return Optional.ofNullable(this.lootTable);
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public int getTicksPerDrop() {
        return this.ticksPerDrop;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public int getTicksPassed() {
        return this.ticksPassed;
    }

    public void setTicksPassed(int ticksPassed) {
        this.ticksPassed = ticksPassed;
    }

    public int getDropCooldownTicks() {
        return this.dropCooldownTicks;
    }

    public void setDropCooldownTicks(int dropCooldownTicks) {
        this.dropCooldownTicks = dropCooldownTicks;
    }
}

