/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import net.blay09.mods.littlejoys.LittleJoys;
import net.blay09.mods.littlejoys.client.handler.DropRushClientHandler;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;

public record ClientboundStopDropRushPacket(Reason reason) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientboundStopDropRushPacket> TYPE = new CustomPacketPayload.Type(LittleJoys.id("stop_drop_rush"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundStopDropRushPacket> STREAM_CODEC = StreamCodec.composite(Reason.STREAM_CODEC, ClientboundStopDropRushPacket::reason, ClientboundStopDropRushPacket::new);

    public static void handle(Player player, ClientboundStopDropRushPacket message) {
        DropRushClientHandler.stopDropRush(message.reason);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum Reason implements StringRepresentable
    {
        TIME_UP,
        FULL_CLEAR,
        DISCONNECT;

        private static final IntFunction<Reason> BY_ID;
        public static final StreamCodec<ByteBuf, Reason> STREAM_CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Reason.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

