/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.blay09.mods.littlejoys.api.EventCondition;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventConditionRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;

public record GoldRushRecipe(EventCondition eventCondition, float chanceMultiplier, ResourceKey<LootTable> lootTable, float seconds, float maxDropsPerSecond, int weight) implements Recipe<RecipeInput>
{
    public RecipeType<GoldRushRecipe> getType() {
        return ModRecipeTypes.goldRushRecipeType;
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.NOT_PLACEABLE;
    }

    public RecipeBookCategory recipeBookCategory() {
        return ModRecipeTypes.goldRushRecipeBookCategory;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<GoldRushRecipe> getSerializer() {
        return ModRecipeTypes.goldRushRecipeSerializer;
    }

    public static class Serializer
    implements RecipeSerializer<GoldRushRecipe> {
        private static final MapCodec<GoldRushRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EventConditionRegistry.CODEC.fieldOf("eventCondition").forGetter(GoldRushRecipe::eventCondition), (App)Codec.FLOAT.fieldOf("chanceMultiplier").orElse((Object)Float.valueOf(1.0f)).forGetter(GoldRushRecipe::chanceMultiplier), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("lootTable").forGetter(GoldRushRecipe::lootTable), (App)Codec.FLOAT.fieldOf("seconds").orElse((Object)Float.valueOf(7.0f)).forGetter(GoldRushRecipe::seconds), (App)Codec.FLOAT.fieldOf("maxDropsPerSecond").orElse((Object)Float.valueOf(-1.0f)).forGetter(GoldRushRecipe::maxDropsPerSecond), (App)Codec.INT.fieldOf("weight").orElse((Object)1).forGetter(GoldRushRecipe::weight)).apply((Applicative)instance, GoldRushRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, GoldRushRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        private static GoldRushRecipe fromNetwork(FriendlyByteBuf buf) {
            EventCondition eventCondition = EventConditionRegistry.conditionFromNetwork(buf);
            float chanceMultiplier = buf.readFloat();
            ResourceKey lootTable = buf.readResourceKey(Registries.LOOT_TABLE);
            float seconds = buf.readFloat();
            float maxDropsPerSecond = buf.readFloat();
            int weight = buf.readVarInt();
            return new GoldRushRecipe(eventCondition, chanceMultiplier, (ResourceKey<LootTable>)lootTable, seconds, maxDropsPerSecond, weight);
        }

        private static void toNetwork(FriendlyByteBuf buf, GoldRushRecipe recipe) {
            EventConditionRegistry.conditionToNetwork(buf, recipe.eventCondition);
            buf.writeFloat(recipe.chanceMultiplier);
            buf.writeResourceKey(recipe.lootTable);
            buf.writeFloat(recipe.seconds);
            buf.writeFloat(recipe.maxDropsPerSecond);
            buf.writeVarInt(recipe.weight);
        }

        public MapCodec<GoldRushRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GoldRushRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

