/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.client.handler;

import net.blay09.mods.balm.client.platform.event.callback.ClientLifecycleCallback;
import net.blay09.mods.balm.client.platform.event.callback.ClientTickCallback;
import net.blay09.mods.littlejoys.network.protocol.ClientboundStopDropRushPacket;
import net.blay09.mods.littlejoys.sound.ModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class DropRushClientHandler {
    private static final int INTRO_TICKS = 48;
    private static final int LOOP_TICKS = 200;
    private static final int OUTRO_TICKS = 98;
    private static boolean dropRushActive;
    private static int dropRushTicksPassed;
    private static int dropRushMaxTicks;

    public static void initialize() {
        ClientTickCallback.ClientLevelTick.BEFORE.register(level -> {
            if (dropRushActive) {
                ++dropRushTicksPassed;
                Minecraft minecraft = Minecraft.getInstance();
                if (minecraft.player != null) {
                    if (dropRushTicksPassed == 48) {
                        level.playSound((Entity)minecraft.player, (Entity)minecraft.player, (SoundEvent)ModSounds.dropRush.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    } else if (dropRushTicksPassed > 48 && (dropRushTicksPassed - 48) % 200 == 0 && dropRushMaxTicks - dropRushTicksPassed > 5) {
                        level.playSound((Entity)minecraft.player, (Entity)minecraft.player, (SoundEvent)ModSounds.dropRush.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    } else if (dropRushTicksPassed == dropRushMaxTicks - 98) {
                        level.playSound((Entity)minecraft.player, (Entity)minecraft.player, (SoundEvent)ModSounds.dropRushStop.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
            }
        });
        ClientLifecycleCallback.DisconnectedFromServer.EVENT.register(client -> DropRushClientHandler.stopDropRush(ClientboundStopDropRushPacket.Reason.DISCONNECT));
    }

    public static void startDropRush(int ticks) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level != null && minecraft.player != null) {
            dropRushActive = true;
            dropRushTicksPassed = 0;
            dropRushMaxTicks = ticks;
            minecraft.level.playSound((Entity)minecraft.player, (Entity)minecraft.player, (SoundEvent)ModSounds.dropRushStart.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void stopDropRush(ClientboundStopDropRushPacket.Reason reason) {
        Minecraft minecraft = Minecraft.getInstance();
        dropRushActive = false;
        minecraft.getSoundManager().stop(Identifier.fromNamespaceAndPath((String)"littlejoys", (String)"drop_rush"), SoundSource.PLAYERS);
        minecraft.getSoundManager().stop(Identifier.fromNamespaceAndPath((String)"littlejoys", (String)"drop_rush_stop"), SoundSource.PLAYERS);
        if (reason == ClientboundStopDropRushPacket.Reason.FULL_CLEAR && minecraft.level != null && minecraft.player != null) {
            minecraft.level.playSound((Entity)minecraft.player, (Entity)minecraft.player, SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

