/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.client.handler;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Optional;
import net.blay09.mods.balm.client.platform.event.callback.ClientLifecycleCallback;
import net.blay09.mods.balm.client.platform.event.callback.ClientTickCallback;
import net.blay09.mods.littlejoys.handler.GoldRushInstance;
import net.blay09.mods.littlejoys.particle.ModParticles;
import net.blay09.mods.littlejoys.sound.ModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class GoldRushClientHandler {
    private static final RandomSource random = RandomSource.create();
    private static final Table<ResourceKey<Level>, BlockPos, GoldRushInstance> activeGoldRushes = HashBasedTable.create();

    public static void initialize() {
        ClientTickCallback.ClientLevelTick.BEFORE.register(level -> {
            for (GoldRushInstance goldRush : activeGoldRushes.row((Object)level.dimension()).values()) {
                BlockPos pos = goldRush.getPos();
                int x = pos.getX();
                int y = pos.getY();
                int z = pos.getZ();
                float randomOffsetX = random.nextFloat();
                float randomOffsetY = random.nextFloat();
                float randomOffsetZ = random.nextFloat();
                BlockState state = level.getBlockState(pos);
                if (state.isViewBlocking((BlockGetter)level, pos)) {
                    for (Direction direction : Direction.values()) {
                        float offsetX = direction.getAxis() == Direction.Axis.X ? 0.5f + 0.6f * (float)direction.getAxisDirection().getStep() : randomOffsetX;
                        float offsetY = direction.getAxis() == Direction.Axis.Y ? 0.5f + 0.6f * (float)direction.getAxisDirection().getStep() : randomOffsetY;
                        float offsetZ = direction.getAxis() == Direction.Axis.Z ? 0.5f + 0.6f * (float)direction.getAxisDirection().getStep() : randomOffsetZ;
                        BlockPos offsetPos = pos.relative(direction);
                        if (level.getBlockState(offsetPos).isViewBlocking((BlockGetter)level, offsetPos)) continue;
                        level.addParticle((ParticleOptions)ModParticles.goldRush.value(), (double)((float)x + offsetX), (double)((float)y + offsetY), (double)((float)z + offsetZ), 0.0, 0.0, 0.0);
                    }
                } else {
                    level.addParticle((ParticleOptions)ModParticles.goldRush.value(), (double)((float)x + randomOffsetX), (double)((float)y + randomOffsetY), (double)((float)z + randomOffsetZ), 0.0, 0.0, 0.0);
                }
                if (goldRush.getTicksPassed() % 160 == 0) {
                    level.playLocalSound(pos, (SoundEvent)ModSounds.goldRush.value(), SoundSource.BLOCKS, 0.5f, 1.0f, false);
                }
                goldRush.setTicksPassed(goldRush.getTicksPassed() + 1);
            }
        });
        ClientLifecycleCallback.DisconnectedFromServer.EVENT.register(client -> {
            activeGoldRushes.clear();
            Minecraft.getInstance().getSoundManager().stop(Identifier.fromNamespaceAndPath((String)"littlejoys", (String)"gold_rush"), SoundSource.BLOCKS);
        });
    }

    public static void addActiveGoldRush(BlockPos pos) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            activeGoldRushes.put((Object)level.dimension(), (Object)pos, (Object)new GoldRushInstance(pos, level.getBlockState(pos), Optional.empty(), -1, -1, null));
        }
    }

    public static void removeActiveGoldRush(BlockPos pos) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level != null) {
            activeGoldRushes.remove((Object)level.dimension(), (Object)pos);
            if (activeGoldRushes.isEmpty()) {
                minecraft.getSoundManager().stop(Identifier.fromNamespaceAndPath((String)"littlejoys", (String)"gold_rush"), SoundSource.BLOCKS);
            }
        }
    }
}

