/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.blay09.mods.balm.commands.BalmCommands;
import net.blay09.mods.littlejoys.LittleJoys;
import net.blay09.mods.littlejoys.handler.DigSpotHandler;
import net.blay09.mods.littlejoys.handler.DropRushHandler;
import net.blay09.mods.littlejoys.handler.FishingSpotHandler;
import net.blay09.mods.littlejoys.handler.GoldRushHandler;
import net.blay09.mods.littlejoys.recipe.DigSpotRecipe;
import net.blay09.mods.littlejoys.recipe.DropRushRecipe;
import net.blay09.mods.littlejoys.recipe.FishingSpotRecipe;
import net.blay09.mods.littlejoys.recipe.GoldRushRecipe;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.Permission;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.world.item.crafting.RecipeHolder;

public class LittleJoysCommand {
    private static final Identifier PERMISSION_LITTLEJOYS_DIGSPOT = LittleJoys.id("command.littlejoys.digspot");
    private static final Identifier PERMISSION_LITTLEJOYS_FISHINGSPOT = LittleJoys.id("command.littlejoys.fishingspot");
    private static final Identifier PERMISSION_LITTLEJOYS_GOLDRUSH = LittleJoys.id("command.littlejoys.goldrush");
    private static final Identifier PERMISSION_LITTLEJOYS_DROPRUSH = LittleJoys.id("command.littlejoys.droprush");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_RECIPE = new DynamicCommandExceptionType(arg -> Component.translatable((String)"recipe.notFound", (Object[])new Object[]{arg}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        BalmCommands.registerPermission((Identifier)PERMISSION_LITTLEJOYS_DIGSPOT, (Permission)Permissions.COMMANDS_GAMEMASTER);
        BalmCommands.registerPermission((Identifier)PERMISSION_LITTLEJOYS_FISHINGSPOT, (Permission)Permissions.COMMANDS_GAMEMASTER);
        BalmCommands.registerPermission((Identifier)PERMISSION_LITTLEJOYS_GOLDRUSH, (Permission)Permissions.COMMANDS_GAMEMASTER);
        BalmCommands.registerPermission((Identifier)PERMISSION_LITTLEJOYS_DROPRUSH, (Permission)Permissions.COMMANDS_GAMEMASTER);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"littlejoys").then(((LiteralArgumentBuilder)Commands.literal((String)"digspot").requires(BalmCommands.requirePermission((Identifier)PERMISSION_LITTLEJOYS_DIGSPOT))).then(((RequiredArgumentBuilder)Commands.argument((String)"position", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            BlockPos pos = BlockPosArgument.getBlockPos((CommandContext)context, (String)"position");
            return DigSpotHandler.createDigSpot(level, pos, player) ? 1 : 0;
        })).then(Commands.argument((String)"recipe", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.RECIPE)).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            BlockPos pos = BlockPosArgument.getBlockPos((CommandContext)context, (String)"position");
            RecipeHolder recipeHolder = ResourceKeyArgument.getRecipe((CommandContext)context, (String)"recipe");
            if (recipeHolder.value() instanceof DigSpotRecipe) {
                DigSpotHandler.createDigSpot(level, pos, (RecipeHolder<DigSpotRecipe>)recipeHolder);
                return 1;
            }
            throw ERROR_UNKNOWN_RECIPE.create(context.getArgument("recipe", ResourceKey.class));
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"fishingspot").requires(BalmCommands.requirePermission((Identifier)PERMISSION_LITTLEJOYS_FISHINGSPOT))).then(((RequiredArgumentBuilder)Commands.argument((String)"position", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            BlockPos pos = BlockPosArgument.getBlockPos((CommandContext)context, (String)"position");
            return FishingSpotHandler.createFishingSpot(level, pos, player) ? 1 : 0;
        })).then(Commands.argument((String)"recipe", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.RECIPE)).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            BlockPos pos = BlockPosArgument.getBlockPos((CommandContext)context, (String)"position");
            RecipeHolder recipeHolder = ResourceKeyArgument.getRecipe((CommandContext)context, (String)"recipe");
            if (recipeHolder.value() instanceof FishingSpotRecipe) {
                FishingSpotHandler.createFishingSpot(level, pos, (RecipeHolder<FishingSpotRecipe>)recipeHolder);
                return 1;
            }
            throw ERROR_UNKNOWN_RECIPE.create(context.getArgument("recipe", ResourceKey.class));
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"goldrush").requires(BalmCommands.requirePermission((Identifier)PERMISSION_LITTLEJOYS_GOLDRUSH))).then(((RequiredArgumentBuilder)Commands.argument((String)"position", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            BlockPos pos = BlockPosArgument.getBlockPos((CommandContext)context, (String)"position");
            GoldRushHandler.startGoldRush(level, pos, level.getBlockState(pos), player);
            return 1;
        })).then(Commands.argument((String)"recipe", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.RECIPE)).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            BlockPos pos = BlockPosArgument.getBlockPos((CommandContext)context, (String)"position");
            RecipeHolder recipeHolder = ResourceKeyArgument.getRecipe((CommandContext)context, (String)"recipe");
            if (recipeHolder.value() instanceof GoldRushRecipe) {
                GoldRushHandler.startGoldRush(level, pos, level.getBlockState(pos), player, (RecipeHolder<GoldRushRecipe>)recipeHolder);
                return 1;
            }
            throw ERROR_UNKNOWN_RECIPE.create(context.getArgument("recipe", ResourceKey.class));
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"droprush").requires(BalmCommands.requirePermission((Identifier)PERMISSION_LITTLEJOYS_DROPRUSH))).then(((RequiredArgumentBuilder)Commands.argument((String)"position", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            BlockPos pos = BlockPosArgument.getBlockPos((CommandContext)context, (String)"position");
            DropRushHandler.startDropRush(level, pos, level.getBlockState(pos), player);
            return 0;
        })).then(Commands.argument((String)"recipe", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.RECIPE)).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            BlockPos pos = BlockPosArgument.getBlockPos((CommandContext)context, (String)"position");
            RecipeHolder recipeHolder = ResourceKeyArgument.getRecipe((CommandContext)context, (String)"recipe");
            if (recipeHolder.value() instanceof DropRushRecipe) {
                DropRushHandler.startDropRush(level, pos, player, (RecipeHolder<DropRushRecipe>)recipeHolder);
                return 1;
            }
            throw ERROR_UNKNOWN_RECIPE.create(context.getArgument("recipe", ResourceKey.class));
        })))));
    }
}

