/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.platform.event.callback.ServerTickCallback;
import net.blay09.mods.littlejoys.LittleJoysConfig;
import net.blay09.mods.littlejoys.block.ModBlocks;
import net.blay09.mods.littlejoys.block.entity.DigSpotBlockEntity;
import net.blay09.mods.littlejoys.handler.ChunkLimitManager;
import net.blay09.mods.littlejoys.mixin.RecipeManagerAccessor;
import net.blay09.mods.littlejoys.recipe.DigSpotRecipe;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventContextImpl;
import net.blay09.mods.littlejoys.stats.ModStats;
import net.blay09.mods.littlejoys.tag.ModPoiTypeTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class DigSpotHandler {
    private static final RandomSource random = RandomSource.create();
    private static final String DIG_SPOT_COOLDOWN = "digSpotCooldown";

    public static void initialize() {
        ServerTickCallback.ServerPlayerTick.AFTER.register(player -> {
            CompoundTag playerData = Balm.hooks().getPersistentData((Player)player);
            CompoundTag littleJoysData = playerData.getCompoundOrEmpty("littlejoys");
            playerData.put("littlejoys", (Tag)littleJoysData);
            int cooldown = littleJoysData.getIntOr(DIG_SPOT_COOLDOWN, 0);
            if (cooldown > 0) {
                littleJoysData.putInt(DIG_SPOT_COOLDOWN, cooldown - 1);
            } else {
                ServerLevel level = player.level();
                PoiManager poiManager = level.getPoiManager();
                BlockPos centerPos = DigSpotHandler.getOriginForNextSpawn((Player)player);
                int checkRange = LittleJoysConfig.getActive().digSpots.minimumDistanceBetween;
                int spawnRange = LittleJoysConfig.getActive().digSpots.spawnDistance;
                Optional digSpotInRange = poiManager.getInRange(it -> it.is(ModPoiTypeTags.DIG_SPOTS), centerPos, checkRange, PoiManager.Occupancy.ANY).findAny();
                if (digSpotInRange.isEmpty()) {
                    BlockPos surfacePos = DigSpotHandler.getVerticallyNearRandomOffsetPos(level, centerPos, spawnRange);
                    BlockPos aboveSurfacePos = surfacePos.above();
                    int totalSpots = ChunkLimitManager.get(level).getTotalDigSpotsInChunk(aboveSurfacePos);
                    int maxSpots = LittleJoysConfig.getActive().digSpots.totalLimitPerChunk;
                    if (maxSpots > 0 && totalSpots >= maxSpots) {
                        littleJoysData.putInt(DIG_SPOT_COOLDOWN, 200);
                        return;
                    }
                    if (!level.getBlockState(aboveSurfacePos).canBeReplaced()) {
                        littleJoysData.putInt(DIG_SPOT_COOLDOWN, 20);
                        return;
                    }
                    if (DigSpotHandler.createDigSpot(level, aboveSurfacePos, player)) {
                        littleJoysData.putInt(DIG_SPOT_COOLDOWN, Math.round(LittleJoysConfig.getActive().digSpots.spawnIntervalSeconds * 20.0f));
                    } else {
                        littleJoysData.putInt(DIG_SPOT_COOLDOWN, 20);
                    }
                } else {
                    littleJoysData.putInt(DIG_SPOT_COOLDOWN, 200);
                }
            }
        });
    }

    public static boolean createDigSpot(ServerLevel level, BlockPos pos, ServerPlayer player) {
        return DigSpotHandler.findRecipe(level, pos, player).map(recipeHolder -> {
            DigSpotHandler.createDigSpot(level, pos, (RecipeHolder<DigSpotRecipe>)recipeHolder);
            return true;
        }).orElse(false);
    }

    public static void createDigSpot(ServerLevel level, BlockPos pos, RecipeHolder<DigSpotRecipe> recipeHolder) {
        level.setBlock(pos, ModBlocks.digSpot.defaultBlockState(), 3);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DigSpotBlockEntity) {
            DigSpotBlockEntity digSpot = (DigSpotBlockEntity)blockEntity;
            digSpot.setRecipeId(recipeHolder.id());
        }
        ChunkLimitManager.get(level).trackDigSpot(pos);
    }

    private static BlockPos getOriginForNextSpawn(Player player) {
        int projectForwardDistance = LittleJoysConfig.getActive().digSpots.projectForwardDistance;
        Direction forwardDirection = player.getDirection();
        return player.blockPosition().relative(forwardDirection, projectForwardDistance);
    }

    private static BlockPos getVerticallyNearRandomOffsetPos(ServerLevel level, BlockPos origin, int spawnRange) {
        BlockPos bestPos = null;
        int bestDist = Integer.MAX_VALUE;
        for (int i = 0; i < 5; ++i) {
            int offsetX = random.nextInt(spawnRange + spawnRange) - spawnRange;
            int offsetZ = random.nextInt(spawnRange + spawnRange) - spawnRange;
            BlockPos randomOffsetPos = new BlockPos(origin.getX() + offsetX, origin.getX(), origin.getZ() + offsetZ);
            BlockPos surfacePos = level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, randomOffsetPos).below();
            int surfaceDist = Math.abs(surfacePos.getY() - origin.getY());
            if (bestPos != null && surfaceDist >= bestDist) continue;
            bestPos = surfacePos;
            bestDist = surfaceDist;
        }
        return bestPos;
    }

    private static Optional<RecipeHolder<DigSpotRecipe>> findRecipe(ServerLevel level, BlockPos pos, ServerPlayer player) {
        RecipeManager recipeManager = level.getServer().getRecipeManager();
        RecipeMap recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        Collection recipes = recipeMap.byType(ModRecipeTypes.digSpot.type());
        ArrayList<RecipeHolder> candidates = new ArrayList<RecipeHolder>();
        for (RecipeHolder recipe : recipes) {
            if (!DigSpotHandler.isValidRecipeFor((RecipeHolder<DigSpotRecipe>)recipe, level, pos, player)) continue;
            candidates.add(recipe);
        }
        return WeightedRandom.getRandomItem((RandomSource)random, candidates, it -> ((DigSpotRecipe)it.value()).weight());
    }

    private static boolean isValidRecipeFor(RecipeHolder<DigSpotRecipe> recipe, ServerLevel level, BlockPos pos, ServerPlayer player) {
        EventContextImpl context = new EventContextImpl((Level)level, pos, level.getBlockState(pos), (Player)player);
        return ((DigSpotRecipe)recipe.value()).eventCondition().test(context);
    }

    public static Optional<DigSpotRecipe> recipeById(ServerLevel level, @Nullable ResourceKey<Recipe<?>> recipeId) {
        Recipe recipe;
        RecipeManager recipeManager = level.recipeAccess();
        if (recipeId == null) {
            return Optional.empty();
        }
        RecipeHolder recipeHolder = recipeManager.byKey(recipeId).orElse(null);
        if (recipeHolder != null && (recipe = recipeHolder.value()) instanceof DigSpotRecipe) {
            DigSpotRecipe digSpotRecipe = (DigSpotRecipe)recipe;
            return Optional.of(digSpotRecipe);
        }
        return Optional.empty();
    }

    public static void digSpotConsumed(Player player) {
        CompoundTag playerData = Balm.hooks().getPersistentData(player);
        CompoundTag littleJoysData = playerData.getCompoundOrEmpty("littlejoys");
        playerData.put("littlejoys", (Tag)littleJoysData);
        littleJoysData.putInt(DIG_SPOT_COOLDOWN, Math.round(LittleJoysConfig.getActive().digSpots.afterDiggingCooldownSeconds * 20.0f));
        player.awardStat(ModStats.digSpotsDug);
    }
}

