/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.blay09.mods.littlejoys.api.EventCondition;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventConditionRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;

public record DropRushRecipe(EventCondition eventCondition, float chanceMultiplier, ResourceKey<LootTable> lootTable, int rolls, float seconds, int range, int weight) implements Recipe<RecipeInput>
{
    public RecipeType<DropRushRecipe> getType() {
        return ModRecipeTypes.dropRush.type();
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.NOT_PLACEABLE;
    }

    public RecipeBookCategory recipeBookCategory() {
        return ModRecipeTypes.dropRush.bookCategory();
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<DropRushRecipe> getSerializer() {
        return ModRecipeTypes.dropRush.serializer();
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<DropRushRecipe> {
        private static final MapCodec<DropRushRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EventConditionRegistry.CODEC.fieldOf("eventCondition").forGetter(DropRushRecipe::eventCondition), (App)Codec.FLOAT.fieldOf("chanceMultiplier").orElse((Object)Float.valueOf(1.0f)).forGetter(DropRushRecipe::chanceMultiplier), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("lootTable").forGetter(DropRushRecipe::lootTable), (App)Codec.INT.fieldOf("rolls").orElse((Object)8).forGetter(DropRushRecipe::rolls), (App)Codec.FLOAT.fieldOf("seconds").orElse((Object)Float.valueOf(12.5f)).forGetter(DropRushRecipe::seconds), (App)Codec.INT.fieldOf("range").orElse((Object)8).forGetter(DropRushRecipe::range), (App)Codec.INT.fieldOf("weight").orElse((Object)1).forGetter(DropRushRecipe::weight)).apply((Applicative)instance, DropRushRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, DropRushRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        private static DropRushRecipe fromNetwork(FriendlyByteBuf buf) {
            EventCondition eventCondition = EventConditionRegistry.conditionFromNetwork(buf);
            float chance = buf.readFloat();
            ResourceKey lootTable = buf.readResourceKey(Registries.LOOT_TABLE);
            int rolls = buf.readVarInt();
            float seconds = buf.readFloat();
            int range = buf.readVarInt();
            int weight = buf.readVarInt();
            return new DropRushRecipe(eventCondition, chance, (ResourceKey<LootTable>)lootTable, rolls, seconds, range, weight);
        }

        private static void toNetwork(FriendlyByteBuf buf, DropRushRecipe recipe) {
            EventConditionRegistry.conditionToNetwork(buf, recipe.eventCondition);
            buf.writeFloat(recipe.chanceMultiplier);
            buf.writeResourceKey(recipe.lootTable);
            buf.writeVarInt(recipe.rolls);
            buf.writeFloat(recipe.seconds);
            buf.writeVarInt(recipe.range);
            buf.writeVarInt(recipe.weight);
        }

        public MapCodec<DropRushRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DropRushRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

