/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.blay09.mods.littlejoys.api.EventCondition;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventConditionRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;

public record FishingSpotRecipe(EventCondition eventCondition, ResourceKey<LootTable> lootTable, int weight) implements Recipe<RecipeInput>
{
    public RecipeType<FishingSpotRecipe> getType() {
        return ModRecipeTypes.fishingSpot.type();
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.NOT_PLACEABLE;
    }

    public RecipeBookCategory recipeBookCategory() {
        return ModRecipeTypes.fishingSpot.bookCategory();
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<FishingSpotRecipe> getSerializer() {
        return ModRecipeTypes.fishingSpot.serializer();
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<FishingSpotRecipe> {
        private static final MapCodec<FishingSpotRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EventConditionRegistry.CODEC.fieldOf("eventCondition").forGetter(FishingSpotRecipe::eventCondition), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("lootTable").forGetter(FishingSpotRecipe::lootTable), (App)Codec.INT.fieldOf("weight").orElse((Object)1).forGetter(FishingSpotRecipe::weight)).apply((Applicative)instance, FishingSpotRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, FishingSpotRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        private static FishingSpotRecipe fromNetwork(FriendlyByteBuf buf) {
            EventCondition eventCondition = EventConditionRegistry.conditionFromNetwork(buf);
            ResourceKey lootTable = buf.readResourceKey(Registries.LOOT_TABLE);
            int weight = buf.readVarInt();
            return new FishingSpotRecipe(eventCondition, (ResourceKey<LootTable>)lootTable, weight);
        }

        private static void toNetwork(FriendlyByteBuf buf, FishingSpotRecipe recipe) {
            EventConditionRegistry.conditionToNetwork(buf, recipe.eventCondition);
            buf.writeResourceKey(recipe.lootTable);
            buf.writeVarInt(recipe.weight);
        }

        public MapCodec<FishingSpotRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FishingSpotRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

