/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public record FluidIngredient(Value[] values) {
    public static final FluidIngredient WATER = new FluidIngredient(new Value[]{new TagValue((TagKey<Fluid>)FluidTags.WATER)});
    public static final Codec<FluidIngredient> CODEC = MapCodec.unitCodec((Object)WATER);

    public boolean test(FluidState state) {
        for (Value value : this.values) {
            if (!value.is(state)) continue;
            return true;
        }
        return false;
    }

    public Fluid[] getFluids() {
        return (Fluid[])Arrays.stream(this.values).flatMap(value -> value.getFluids().stream()).distinct().toArray(Fluid[]::new);
    }

    public static FluidIngredient fromJson(@Nullable JsonElement json, boolean canBeEmpty) {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonObject()) {
                return FluidIngredient.fromValues(Stream.of(FluidIngredient.valueFromJson(json.getAsJsonObject())));
            }
            if (json.isJsonArray()) {
                JsonArray jsonarray = json.getAsJsonArray();
                if (jsonarray.isEmpty() && !canBeEmpty) {
                    throw new JsonSyntaxException("Fluid array cannot be empty, at least one fluid must be defined");
                }
                return FluidIngredient.fromValues(StreamSupport.stream(jsonarray.spliterator(), false).map(it -> FluidIngredient.valueFromJson(GsonHelper.convertToJsonObject((JsonElement)it, (String)"fluid"))));
            }
            throw new JsonSyntaxException("Expected fluid to be object or array of objects");
        }
        throw new JsonSyntaxException("Fluid cannot be null");
    }

    private static FluidIngredient fromValues(Stream<? extends Value> stream) {
        return new FluidIngredient((Value[])stream.toArray(Value[]::new));
    }

    private static Value valueFromJson(JsonObject json) {
        if (json.has("fluid") && json.has("tag")) {
            throw new JsonParseException("A fluid ingredient entry is either a tag or a fluid, not both");
        }
        if (json.has("fluid")) {
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.getValue(Identifier.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"fluid")));
            return new FluidValue(fluid);
        }
        if (json.has("tag")) {
            TagKey tag = TagKey.create((ResourceKey)Registries.FLUID, (Identifier)Identifier.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"tag")));
            return new TagValue((TagKey<Fluid>)tag);
        }
        throw new JsonParseException("A fluid ingredient entry needs either a tag or a fluid");
    }

    public static FluidIngredient fromNetwork(FriendlyByteBuf buffer) {
        return FluidIngredient.fromValues(buffer.readList(FriendlyByteBuf::readIdentifier).stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getValue(arg_0)).map(FluidValue::new));
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeCollection(Arrays.asList(this.getFluids()), (buf, fluid) -> buf.writeIdentifier(BuiltInRegistries.FLUID.getKey(fluid)));
    }

    public static interface Value {
        public boolean is(FluidState var1);

        public Collection<Fluid> getFluids();
    }

    public record FluidValue(Fluid fluid) implements Value
    {
        @Override
        public boolean is(FluidState state) {
            return state.is(this.fluid);
        }

        @Override
        public Collection<Fluid> getFluids() {
            return List.of(this.fluid);
        }
    }

    public record TagValue(TagKey<Fluid> tag) implements Value
    {
        @Override
        public boolean is(FluidState state) {
            return state.is(this.tag);
        }

        @Override
        public Collection<Fluid> getFluids() {
            ArrayList<Fluid> result = new ArrayList<Fluid>();
            for (Holder holder : BuiltInRegistries.FLUID.getTagOrEmpty(this.tag)) {
                result.add((Fluid)holder.value());
            }
            return result;
        }
    }
}

