/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.recipe.condition;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.blay09.mods.littlejoys.api.EventCondition;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.Identifier;

public class EventConditionRegistry {
    private static final BiMap<Identifier, Class<? extends EventCondition>> TYPES_BY_CLASS = HashBiMap.create();
    private static final BiMap<Identifier, EventConditionType<? extends EventCondition>> TYPES = HashBiMap.create();
    public static final Codec<EventConditionType<? extends EventCondition>> BY_NAME_CODEC = EventConditionRegistry.byNameCodec();
    public static final Codec<EventCondition> CODEC = BY_NAME_CODEC.dispatch(it -> EventConditionRegistry.getType(it.getClass()), EventConditionType::mapCodec);
    public static final Codec<List<EventCondition>> LIST_CODEC = CODEC.listOf();

    private static Codec<EventConditionType<? extends EventCondition>> byNameCodec() {
        return Identifier.CODEC.flatXmap(identifier -> Optional.ofNullable(EventConditionRegistry.getType(identifier)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown event condition: " + String.valueOf(identifier))), type -> DataResult.success((Object)type.identifier));
    }

    public static <T extends EventCondition> void registerCondition(Identifier identifier, Class<T> clazz, MapCodec<T> codec, Function<FriendlyByteBuf, T> networkDeserializer) {
        if (TYPES_BY_CLASS.containsKey((Object)identifier)) {
            throw new IllegalArgumentException("Condition with identifier " + String.valueOf(identifier) + " is already registered");
        }
        TYPES.put((Object)identifier, new EventConditionType<T>(identifier, codec, networkDeserializer));
        TYPES_BY_CLASS.put((Object)identifier, clazz);
    }

    public static Identifier getIdentifier(Class<? extends EventCondition> conditionClass) {
        return (Identifier)TYPES_BY_CLASS.inverse().get(conditionClass);
    }

    public static <T extends EventCondition> EventConditionType<T> getType(Identifier identifier) {
        return (EventConditionType)TYPES.get((Object)identifier);
    }

    public static <T extends EventCondition> EventConditionType<T> getType(Class<T> clazz) {
        return EventConditionRegistry.getType(EventConditionRegistry.getIdentifier(clazz));
    }

    public static EventCondition conditionFromNetwork(FriendlyByteBuf buf) {
        Identifier identifier = buf.readIdentifier();
        EventConditionType type = EventConditionRegistry.getType(identifier);
        if (type == null) {
            throw new IllegalArgumentException("Unknown event condition " + String.valueOf(identifier));
        }
        return type.networkDeserializer.apply(buf);
    }

    public static void conditionToNetwork(FriendlyByteBuf buf, EventCondition condition) {
        Identifier identifier = EventConditionRegistry.getIdentifier(condition.getClass());
        if (identifier == null) {
            throw new IllegalArgumentException("Event condition " + String.valueOf(condition.getClass()) + " is not registered");
        }
        buf.writeIdentifier(identifier);
        condition.toNetwork(buf);
    }

    public record EventConditionType<T extends EventCondition>(Identifier identifier, MapCodec<T> mapCodec, Function<FriendlyByteBuf, ? extends EventCondition> networkDeserializer) {
        public Codec<T> codec() {
            return this.mapCodec.codec();
        }
    }
}

