/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.gui.panels;

import com.nitsha.binds.MainClass;
import com.nitsha.binds.configs.BindsConfig;
import com.nitsha.binds.gui.screen.BindsEditor;
import com.nitsha.binds.gui.utils.GUIUtils;
import com.nitsha.binds.gui.widget.AnimatedWindow;
import com.nitsha.binds.gui.widget.PresetListItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public class PresetSelector
extends AnimatedWindow {
    private static final class_2960 SPRESET = MainClass.idSprite("select_preset");
    private static final class_2960 SPRESET_HOVER = MainClass.idSprite("select_preset_hover");
    private static final class_2960 TOP = MainClass.idSprite("top_normal");
    private static final class_2960 TOP_HOVER = MainClass.idSprite("top_hover");
    private static final class_2960 BOTTOM = MainClass.idSprite("bottom_normal");
    private static final class_2960 BOTTOM_HOVER = MainClass.idSprite("bottom_hover");
    private final List<String> presetNames = (List)BindsConfig.configs.get("presets");
    private final List<PresetListItem> items = new ArrayList<PresetListItem>();
    private boolean isOpen = false;
    public BindsEditor screen;

    public PresetSelector(BindsEditor screen, float x, float y, float width, int height, class_2960 t1, class_2960 t2, int delay) {
        super(x, y, width, height, t1, t2, delay);
        this.items.clear();
        this.screen = screen;
        this.initUI(screen);
    }

    private void initUI(BindsEditor screen) {
        this.addDrawElement((ctx, mouseX, mouseY) -> GUIUtils.addText(ctx, class_2561.method_30163((String)GUIUtils.truncateString(BindsEditor.getPresetName(), 15)), 0, 5, 5, "top", "left", -1, false));
        this.addElement(GUIUtils.createTexturedBtn(113, 4, 9, 9, new class_2960[]{SPRESET, SPRESET_HOVER}, button -> this.openSelector(!this.isOpen)));
        this.addElement(GUIUtils.createTexturedBtn(91, 4, 9, 9, new class_2960[]{TOP, TOP_HOVER}, button -> screen.setNewPreset(-1)));
        this.addElement(GUIUtils.createTexturedBtn(102, 4, 9, 9, new class_2960[]{BOTTOM, BOTTOM_HOVER}, button -> screen.setNewPreset(1)));
        int tY = 15;
        for (int i = 0; i < 9; ++i) {
            int h = 20;
            PresetListItem item = new PresetListItem(this, this.presetNames.get(i), 2, tY, this.getWidth() - 4, h, i);
            this.addElement(item);
            this.items.add(item);
            tY += h;
        }
        this.open(() -> {});
    }

    public List<PresetListItem> getItems() {
        return this.items;
    }

    public void openSelector(boolean status) {
        this.isOpen = status;
        if (!this.isOpen) {
            this.saveAll();
        }
        this.setHeight(this.isOpen ? 202.0f : 19.0f);
    }

    public void saveAll() {
        for (PresetListItem item : this.items) {
            item.savePreset();
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void method_25394(class_4587 ctx, int mouseX, int mouseY, float delta) {
        GUIUtils.customScissor(ctx, this.getX(), this.getYOffset(), this.getWidth(), this.getHeight(), () -> GUIUtils.matricesUtil(ctx, 0.0f, 0.0f, 500, () -> super.method_25394(ctx, mouseX, mouseY, delta)));
    }
}

