/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.utils;

import com.nitsha.binds.configs.BindEntry;
import com.nitsha.binds.configs.BindsConfig;
import com.nitsha.binds.gui.screen.BindsGUI;
import com.nitsha.binds.gui.utils.TextUtils;
import com.nitsha.binds.utils.FastbindParser;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.lwjgl.glfw.GLFW;

public class BindExecutor {
    private static final List<BindTask> activeTasks = new ArrayList<BindTask>();

    public static void startBind(BindEntry bind) {
        class_310 client = class_310.method_1551();
        assert (client.field_1724 != null);
        if (client.field_1755 != null && !(client.field_1755 instanceof BindsGUI) || bind.actions.isEmpty()) {
            return;
        }
        BindTask task = new BindTask(bind, client);
        activeTasks.add(task);
    }

    public static void onTick(class_310 client) {
        activeTasks.removeIf(BindTask::tick);
    }

    private static class BindTask {
        private final Queue<Runnable> actions = new LinkedList<Runnable>();
        private long waitUntil = 0L;

        BindTask(BindEntry bind, class_310 client) {
            block9: for (String raw : bind.actions) {
                FastbindParser.ParsedEntry entry = FastbindParser.parse(raw);
                this.actions.add(() -> {
                    this.waitUntil = class_156.method_658() + 10L;
                });
                switch (entry.type) {
                    case 1: {
                        String cmd = entry.value;
                        if (cmd.isEmpty()) break;
                        if (client.field_1724 == null || client.method_1562() == null) continue block9;
                        this.actions.add(() -> client.field_1724.method_44099(cmd));
                        break;
                    }
                    case 2: {
                        try {
                            String msText = entry.value;
                            if (msText.isEmpty()) {
                                msText = "0";
                            }
                            int ms = Integer.parseInt(msText);
                            this.actions.add(() -> {
                                long end;
                                this.waitUntil = end = class_156.method_658() + (long)ms;
                            });
                        }
                        catch (NumberFormatException msText) {}
                        break;
                    }
                    case 3: {
                        try {
                            int keyCode = Integer.parseInt(entry.value);
                            if (keyCode == 0) break;
                            long handle = class_310.method_1551().method_22683().method_4490();
                            int scancode = GLFW.glfwGetKeyScancode((int)keyCode);
                            this.actions.add(() -> client.field_1774.method_1466(handle, keyCode, scancode, 1, 0));
                            this.actions.add(() -> {
                                this.waitUntil = 100L;
                            });
                            this.actions.add(() -> client.field_1774.method_1466(handle, keyCode, scancode, 0, 0));
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            assert (client.field_1724 != null);
            if (BindsConfig.getBooleanConfig("bindMsg", true)) {
                client.field_1724.method_7353((class_2561)TextUtils.translatable("nitsha.binds.bindActivate", "\u00a73" + bind.name + "\u00a7r"), true);
            }
        }

        boolean tick() {
            Runnable action;
            if (this.waitUntil > 0L) {
                if (class_156.method_658() < this.waitUntil) {
                    return false;
                }
                this.waitUntil = 0L;
            }
            if (!this.actions.isEmpty() && (action = this.actions.poll()) != null) {
                action.run();
            }
            return this.actions.isEmpty() && this.waitUntil <= 0L;
        }
    }
}

