/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.configs;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nitsha.binds.MainClass;
import com.nitsha.binds.configs.BindEntry;
import com.nitsha.binds.configs.BindHandler;
import com.nitsha.binds.utils.FastbindParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.fabricmc.loader.api.FabricLoader;

public class BindsConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getGameDir().resolve("nitsha");
    private static final BindEntry DEFAULT_LINE = new BindEntry("", "STRUCTURE_VOID", 0, new ArrayList<String>());
    public static List<List<BindEntry>> presets = new ArrayList<List<BindEntry>>();
    public static Map<String, Object> configs = new HashMap<String, Object>();

    private static void createConfigDirectory() {
        if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
            try {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't create FastBind config directory: " + String.valueOf(CONFIG_DIR), e);
            }
        }
    }

    public static void loadPresets() {
        for (int i = 0; i < 9; ++i) {
            File CONFIG_FILE = CONFIG_DIR.resolve("fastbind_preset_" + i + ".json5").toFile();
            List presetList = new ArrayList();
            if (CONFIG_FILE.exists()) {
                if (CONFIG_FILE.length() == 0L) {
                    BindsConfig.generateEmptyList(i);
                }
                try (FileReader reader = new FileReader(CONFIG_FILE);){
                    Type listType = new TypeToken<List<BindEntry>>(){}.getType();
                    presetList = (List)GSON.fromJson((Reader)reader, listType);
                    if (presetList == null) {
                        BindsConfig.generateEmptyList(i);
                    }
                }
                catch (IOException e) {
                    BindsConfig.generateEmptyList(i);
                    e.printStackTrace();
                }
                presets.add(presetList);
                continue;
            }
            BindsConfig.generateEmptyList(i);
        }
    }

    public static void generateEmptyList(int fileIndex) {
        ArrayList<BindEntry> presetList = new ArrayList<BindEntry>();
        presetList.add(new BindEntry("Thank you!", "TRIAL_KEY", 0, List.of("nitsha::welcome")));
        for (int i = 0; i < 39; ++i) {
            presetList.add(DEFAULT_LINE);
        }
        presets.add(presetList);
        BindsConfig.savePresetFile(fileIndex);
    }

    public static BindEntry getBind(int fileIndex, int index) {
        return presets.get(fileIndex).get(index);
    }

    public static void setBind(int fileIndex, int index, BindEntry newLine) {
        presets.get(fileIndex).set(index, newLine);
        BindsConfig.savePresetFile(fileIndex);
    }

    public static void addBindAction(int fileIndex, int bindIndex, int actionIndex, String action) {
        BindsConfig.presets.get((int)fileIndex).get((int)bindIndex).actions.add(actionIndex, action);
        BindsConfig.savePresetFile(fileIndex);
    }

    public static void removeBindAction(int fileIndex, int bindIndex, int actionIndex) {
        List<String> actions = BindsConfig.presets.get((int)fileIndex).get((int)bindIndex).actions;
        if (actionIndex < 0 || actionIndex >= actions.size()) {
            System.err.println("\u274c Wrong index: " + actionIndex + ", array has " + actions.size() + " elements");
            return;
        }
        actions.remove(actionIndex);
        BindsConfig.savePresetFile(fileIndex);
    }

    public static void setBindKeyBind(int fileIndex, int index, int keyCode) {
        BindsConfig.presets.get((int)fileIndex).get((int)index).keyCode = keyCode;
        BindHandler.getAllKeyBind();
        BindsConfig.savePresetFile(fileIndex);
    }

    public static void moveBindAction(int fileIndex, int bindIndex, int actionIndex, int direction) {
        List<String> actions = BindsConfig.presets.get((int)fileIndex).get((int)bindIndex).actions;
        int newIndex = actionIndex + direction;
        if (actionIndex < 0 || actionIndex >= actions.size() || newIndex < 0 || newIndex >= actions.size()) {
            return;
        }
        String temp = actions.get(newIndex);
        actions.set(newIndex, actions.get(actionIndex));
        actions.set(actionIndex, temp);
        BindsConfig.savePresetFile(fileIndex);
    }

    public static void savePresetFile(int fileIndex) {
        File CONFIG_FILE = CONFIG_DIR.resolve("fastbind_preset_" + fileIndex + ".json5").toFile();
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson(presets.get(fileIndex), (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setNewPresetName(int presetIndex, String newName) {
        List presetsName = (List)configs.get("presets");
        presetsName.set(presetIndex, newName);
        BindsConfig.saveConfigFile();
    }

    public static void loadConfigs() {
        File CONFIG_FILE = CONFIG_DIR.resolve("fastbind_configs.json5").toFile();
        if (CONFIG_FILE.exists()) {
            if (CONFIG_FILE.length() == 0L) {
                BindsConfig.generateNewConfig();
            }
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
                configs = (Map)GSON.fromJson((Reader)reader, mapType);
                if (configs == null) {
                    BindsConfig.generateNewConfig();
                }
                if (!BindsConfig.getBooleanConfig("refactorPresetNames", false)) {
                    BindsConfig.refactorPresetNames();
                }
            }
            catch (IOException e) {
                BindsConfig.generateNewConfig();
                e.printStackTrace();
            }
        } else {
            BindsConfig.generateNewConfig();
        }
    }

    public static void generateNewConfig() {
        List presetsName = IntStream.rangeClosed(1, 9).mapToObj(i -> "Preset " + i).collect(Collectors.toList());
        configs.put("presets", presetsName);
        BindsConfig.saveConfigFile();
    }

    public static void saveConfigFile() {
        File CONFIG_FILE = CONFIG_DIR.resolve("fastbind_configs.json5").toFile();
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson(configs, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void refactorPresetNames() {
        Object presetsObject = configs.get("presets");
        if (!(presetsObject instanceof List)) {
            System.err.println("Error: 'presets' is not in config list");
            return;
        }
        List presetsList = (List)presetsObject;
        for (int i = 0; i < presetsList.size(); ++i) {
            String currentName = (String)presetsList.get(i);
            if (!"Default".equals(currentName)) continue;
            presetsList.set(i, "Preset " + (i + 1));
        }
        BindsConfig.setConfig("refactorPresetNames", true);
    }

    public static String getStringConfig(String key, String defaultValue) {
        Object value = configs.get(key);
        return value instanceof String ? (String)value : defaultValue;
    }

    public static int getIntConfig(String key, int defaultValue) {
        Object value = configs.get(key);
        return value instanceof Number ? ((Number)value).intValue() : defaultValue;
    }

    public static boolean getBooleanConfig(String key, boolean defaultValue) {
        Object value = configs.get(key);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public static List<String> getStringListConfig(String key, List<String> defaultValue) {
        List list;
        Object value = configs.get(key);
        if (value instanceof List && !(list = (List)value).isEmpty() && list.get(0) instanceof String) {
            return list;
        }
        return defaultValue;
    }

    public static void setConfig(String key, Object value) {
        configs.put(key, value);
        BindsConfig.saveConfigFile();
    }

    public static void addToListConfig(String key, String value) {
        ArrayList<String> list = (ArrayList<String>)configs.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            configs.put(key, list);
        }
        list.add(value);
        BindsConfig.saveConfigFile();
    }

    public static void migrateOldPresetFileIfExists() {
        block15: {
            File oldFile = CONFIG_DIR.resolve("fastbind.json5").toFile();
            File newFile = CONFIG_DIR.resolve("fastbind_preset_0.json5").toFile();
            if (!oldFile.exists() || newFile.exists()) {
                return;
            }
            try (FileReader reader = new FileReader(oldFile);){
                Type listType = new TypeToken<List<String[]>>(){}.getType();
                List oldPreset = (List)GSON.fromJson((Reader)reader, listType);
                if (oldPreset != null && !oldPreset.isEmpty()) {
                    List<BindEntry> newPreset = BindsConfig.convertStringArrayListToBindEntryList(oldPreset);
                    try (FileWriter writer = new FileWriter(newFile);){
                        GSON.toJson(newPreset, (Appendable)writer);
                    }
                    MainClass.LOGGER.info("Old config fastbind.json5 migrated to fastbind_preset_0.json5");
                    Files.deleteIfExists(oldFile.toPath());
                    break block15;
                }
                MainClass.LOGGER.error("Old config is empty or corrupted");
            }
            catch (IOException e) {
                MainClass.LOGGER.error("Old config migration error:");
                e.printStackTrace();
            }
        }
    }

    public static void migrateOldMultiPresetFiles() {
        if (BindsConfig.getBooleanConfig("migrateConfigToV3", false)) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            File file = CONFIG_DIR.resolve("fastbind_preset_" + i + ".json5").toFile();
            if (!file.exists()) continue;
            try (FileReader reader = new FileReader(file);){
                Type listType = new TypeToken<List<String[]>>(){}.getType();
                List oldPreset = (List)GSON.fromJson((Reader)reader, listType);
                if (oldPreset == null || oldPreset.isEmpty() || !(oldPreset.get(0) instanceof String[])) continue;
                List<BindEntry> newPreset = BindsConfig.convertStringArrayListToBindEntryList(oldPreset);
                try (FileWriter writer = new FileWriter(file);){
                    GSON.toJson(newPreset, (Appendable)writer);
                }
                MainClass.LOGGER.info("Migrated fastbind_preset_" + i + ".json5 to new format");
                continue;
            }
            catch (IOException e) {
                MainClass.LOGGER.error("Migration error for file fastbind_preset_" + i + ".json5:");
                e.printStackTrace();
            }
        }
        BindsConfig.setConfig("migrateConfigToV3", true);
    }

    private static List<BindEntry> convertStringArrayListToBindEntryList(List<String[]> oldPreset) {
        ArrayList<BindEntry> newPreset = new ArrayList<BindEntry>();
        for (String[] arr : oldPreset) {
            String name = arr.length > 0 ? arr[0] : "";
            String icon = arr.length > 1 ? arr[1] : "STRUCTURE_VOID";
            int keyCode = 0;
            ArrayList<String> actions = new ArrayList<String>();
            if (!arr[2].isEmpty()) {
                actions.add(FastbindParser.toAction(1, arr[2]));
            }
            newPreset.add(new BindEntry(name, icon, keyCode, actions));
        }
        return newPreset;
    }

    static {
        BindsConfig.createConfigDirectory();
    }
}

