/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.utils;

public class EasterEgg {
    private final int requiredClicks;
    private final long maxTimeBetweenClicksMs;
    private final Runnable action;
    private int clickCount = 0;
    private long lastClickTime = 0L;

    public EasterEgg(int requiredClicks, long maxTimeBetweenClicksMs, Runnable action) {
        this.requiredClicks = requiredClicks;
        this.maxTimeBetweenClicksMs = maxTimeBetweenClicksMs;
        this.action = action;
    }

    public boolean handleClick(boolean isInsideArea) {
        if (!isInsideArea) {
            this.reset();
            return false;
        }
        long currentTime = System.currentTimeMillis();
        this.clickCount = currentTime - this.lastClickTime > this.maxTimeBetweenClicksMs ? 1 : ++this.clickCount;
        this.lastClickTime = currentTime;
        if (this.clickCount >= this.requiredClicks) {
            this.action.run();
            this.reset();
        }
        return true;
    }

    public void reset() {
        this.clickCount = 0;
        this.lastClickTime = 0L;
    }

    public int getClickCount() {
        return this.clickCount;
    }
}

