/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.gui.widget;

import com.google.common.collect.Lists;
import com.nitsha.binds.gui.utils.DrawElement;
import com.nitsha.binds.gui.utils.GUIUtils;
import com.nitsha.binds.gui.widget.ScrollableWindow;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class AnimatedWindow
extends class_362
implements class_4068,
class_364,
class_6379 {
    private class_2960 T_1;
    private class_2960 T_2;
    private final List<class_364> children = Lists.newArrayList();
    private final List<class_4068> drawables = Lists.newArrayList();
    private final List<DrawElement> drawElementsTop = Lists.newArrayList();
    private final List<DrawElement> drawElementsBottom = Lists.newArrayList();
    private long delayMs;
    private float x;
    private float y;
    private float width;
    private float height;
    private float targetX;
    private float targetY;
    private float targetWidth;
    private float targetHeight;
    private boolean visible = false;
    private int globalColor = -1;
    private AnimationState animState;
    private final float speed = 0.5f;
    private float baseYOffset;
    private float topYOffset;
    private float alpha;
    private Runnable onFinish = null;
    private long lastUpdateTime;

    public AnimatedWindow(float x, float y, float width, float height, class_2960 t1, class_2960 t2, int delayMs) {
        this.children.clear();
        this.drawElementsBottom.clear();
        this.x = this.targetX = x;
        this.y = this.targetY = y;
        this.width = this.targetWidth = width;
        this.height = this.targetHeight = height;
        this.T_1 = t1;
        this.T_2 = t2;
        this.delayMs = delayMs;
        this.animState = AnimationState.HIDDEN;
        this.baseYOffset = y - 80.0f;
        this.topYOffset = 0.0f;
        this.alpha = 0.0f;
        this.lastUpdateTime = 0L;
    }

    public void addDrawElement(DrawElement.Drawer drawer, int position) {
        if (position == 0) {
            this.drawElementsBottom.add(new DrawElement(drawer));
        }
        if (position == 1) {
            this.drawElementsTop.add(new DrawElement(drawer));
        }
    }

    public void addDrawElement(DrawElement.Drawer drawer) {
        this.addDrawElement(drawer, 0);
    }

    public <T extends class_364 & class_4068> void addElement(T drawableElement) {
        this.children.add(drawableElement);
        this.drawables.add(drawableElement);
    }

    public int getX() {
        return Math.round(this.x);
    }

    public int getY() {
        return Math.round(this.y);
    }

    public int getWidth() {
        return Math.round(this.width);
    }

    public int getHeight() {
        return Math.round(this.height);
    }

    public void updateWidth(float delta) {
        this.targetWidth = this.width + delta;
    }

    public void updateHeight(float delta) {
        this.targetHeight = this.height + delta;
    }

    public void updateX(float delta) {
        this.targetX = this.x - delta;
    }

    public void updateY(float delta) {
        this.targetY = this.y - delta;
    }

    public void setWidth(float newWidth) {
        this.targetWidth = newWidth;
    }

    public void setHeight(float newHeight) {
        this.targetHeight = newHeight;
    }

    public void setX(float newX) {
        this.targetX = newX;
    }

    public void setY(float newY) {
        this.targetY = newY;
    }

    public void open(Runnable onFinish) {
        if (this.visible) {
            return;
        }
        this.visible = true;
        this.onFinish = onFinish;
        this.animState = AnimationState.DROPPING_ALL;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public void close(Runnable onFinish) {
        if (!this.visible) {
            return;
        }
        this.animState = AnimationState.HIDING_TOP;
        this.onFinish = onFinish;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    private void updateAnimationState(float lerpFactor) {
        switch (this.animState.ordinal()) {
            case 0: {
                this.alpha = class_3532.method_16439((float)lerpFactor, (float)this.alpha, (float)1.0f);
                this.baseYOffset = class_3532.method_16439((float)lerpFactor, (float)this.baseYOffset, (float)(this.y + 2.0f));
                if (!(Math.abs(this.baseYOffset - (this.y + 2.0f)) < 0.001f)) break;
                this.baseYOffset = this.y + 2.0f;
                this.alpha = 1.0f;
                this.animState = AnimationState.LIFTING_TOP;
                if (this.onFinish == null) break;
                this.onFinish.run();
                this.onFinish = null;
                break;
            }
            case 1: {
                this.topYOffset = class_3532.method_16439((float)lerpFactor, (float)this.topYOffset, (float)2.0f);
                if (!(Math.abs(this.topYOffset - 2.0f) < 0.001f)) break;
                this.topYOffset = 2.0f;
                this.animState = AnimationState.FINISHED;
                break;
            }
            case 3: {
                this.alpha = class_3532.method_16439((float)lerpFactor, (float)this.alpha, (float)0.0f);
                this.baseYOffset = class_3532.method_16439((float)lerpFactor, (float)this.baseYOffset, (float)(this.y - 100.0f));
                if (this.onFinish != null && this.baseYOffset < this.y - 49.0f) {
                    this.visible = false;
                    this.onFinish.run();
                    this.onFinish = null;
                }
                if (!(Math.abs(this.baseYOffset - (this.y - 100.0f)) < 0.001f)) break;
                this.baseYOffset = this.y - 100.0f;
                this.alpha = 0.0f;
                this.animState = AnimationState.LIFTING_ALL;
                break;
            }
            case 4: {
                this.topYOffset = class_3532.method_16439((float)lerpFactor, (float)this.topYOffset, (float)0.0f);
                if (!(Math.abs(this.topYOffset) < 0.001f)) break;
                this.topYOffset = 0.0f;
                this.animState = AnimationState.HIDDEN;
                break;
            }
        }
    }

    public int getYOffset() {
        return Math.round(this.baseYOffset - this.topYOffset);
    }

    public int getColor() {
        return this.globalColor;
    }

    public long getDelay() {
        return this.delayMs;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void tick() {
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
            return;
        }
        long deltaTime = currentTime - this.lastUpdateTime;
        this.lastUpdateTime = currentTime;
        if (this.delayMs > 0L) {
            this.delayMs -= deltaTime;
            if (this.delayMs < 0L) {
                this.delayMs = 0L;
            }
            return;
        }
        float lerpFactor = 1.0f - (float)Math.pow(0.5, (float)deltaTime / 16.666f);
        this.animateValues(lerpFactor);
        this.updateAnimationState(lerpFactor);
    }

    private void animateValues(float lerpFactor) {
        this.width = class_3532.method_16439((float)lerpFactor, (float)this.width, (float)this.targetWidth);
        this.height = class_3532.method_16439((float)lerpFactor, (float)this.height, (float)this.targetHeight);
        this.x = class_3532.method_16439((float)lerpFactor, (float)this.x, (float)this.targetX);
        this.y = class_3532.method_16439((float)lerpFactor, (float)this.y, (float)this.targetY);
        if (Math.abs(this.width - this.targetWidth) < 0.1f) {
            this.width = this.targetWidth;
        }
        if (Math.abs(this.height - this.targetHeight) < 0.1f) {
            this.height = this.targetHeight;
        }
        if (Math.abs(this.x - this.targetX) < 0.1f) {
            this.x = this.targetX;
        }
        if (Math.abs(this.y - this.targetY) < 0.1f) {
            this.y = this.targetY;
        }
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        int alphaByte = (int)(this.alpha * 255.0f) & 0xFF;
        this.globalColor = alphaByte << 24 | 0xFFFFFFFF;
        int xO = this.getX();
        int yO = this.getYOffset();
        if (this.delayMs <= 0L && this.visible) {
            GUIUtils.matricesUtil(ctx, xO, Math.round(this.baseYOffset), 1, () -> GUIUtils.drawResizableBox(ctx, this.T_1, 0, 0, this.getWidth(), this.getHeight() - 2, 7, 15, this.globalColor));
            GUIUtils.matricesUtil(ctx, xO, yO, 2, () -> {
                GUIUtils.drawResizableBox(ctx, this.T_2, 0, 0, this.getWidth(), this.getHeight() - 2, 7, 15, this.globalColor);
                this.drawElementsBottom.forEach(element -> element.render(ctx, mouseX - xO, mouseY - yO));
            });
            this.drawables.forEach(element -> {
                Runnable render = () -> GUIUtils.matricesUtil(ctx, xO, yO, 2, () -> element.method_25394(ctx, mouseX - xO, mouseY - yO, delta));
                if (element instanceof ScrollableWindow) {
                    ScrollableWindow sw = (ScrollableWindow)((Object)element);
                    GUIUtils.customScissor(ctx, xO + sw.getX(), yO + sw.getY(), sw.getWidth(), sw.getHeight(), render);
                } else {
                    render.run();
                }
            });
            GUIUtils.matricesUtil(ctx, xO, yO, 2, () -> this.drawElementsTop.forEach(element -> element.render(ctx, mouseX - xO, mouseY - yO)));
        }
        this.tick();
    }

    public void method_37020(class_6382 builder) {
    }

    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
    }

    public List<? extends class_364> method_25396() {
        return this.children;
    }

    public void clearChildren() {
        this.children.clear();
        this.drawables.clear();
        this.drawElementsTop.clear();
        this.drawElementsBottom.clear();
    }

    public void removeElementsOfType(Class<?> type) {
        this.children.removeIf(type::isInstance);
        this.drawables.removeIf(type::isInstance);
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public boolean isMouseInside(double mouseX, double mouseY) {
        if (!this.visible) {
            return false;
        }
        float windowX = this.x;
        float windowY = this.getYOffset();
        float windowWidth = this.width;
        float windowHeight = this.height;
        return mouseX >= (double)windowX && mouseX <= (double)(windowX + windowWidth) && mouseY >= (double)windowY && mouseY <= (double)(windowY + windowHeight);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        double adjustedX = mouseX - (double)this.getX();
        double adjustedY = mouseY - (double)this.getYOffset();
        for (class_364 child : this.children) {
            if (!child.method_25402(adjustedX, adjustedY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        boolean released = false;
        double adjustedX = mouseX - (double)this.getX();
        double adjustedY = mouseY - (double)this.getYOffset();
        for (class_364 child : this.children) {
            if (!child.method_25406(adjustedX, adjustedY, button)) continue;
            released = true;
        }
        return released;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.visible) {
            return false;
        }
        boolean dragged = false;
        double adjustedX = mouseX - (double)this.getX();
        double adjustedY = mouseY - (double)this.getYOffset();
        for (class_364 child : this.children) {
            if (!child.method_25403(adjustedX, adjustedY, button, deltaX, deltaY)) continue;
            dragged = true;
        }
        return dragged;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (class_364 class_3642 : this.method_25396()) {
            if (!class_3642.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25400(char codePoint, int modifiers) {
        for (class_364 class_3642 : this.method_25396()) {
            if (!class_3642.method_25400(codePoint, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.isVisible() || !this.isMouseInside(mouseX, mouseY)) {
            return false;
        }
        double adjX = mouseX - (double)this.getX();
        double adjY = mouseY - (double)this.getYOffset();
        for (class_364 class_3642 : this.method_25396()) {
            if (!class_3642.method_25401(adjX, adjY, horizontalAmount, verticalAmount)) continue;
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private static enum AnimationState {
        DROPPING_ALL,
        LIFTING_TOP,
        FINISHED,
        HIDING_TOP,
        LIFTING_ALL,
        HIDDEN;

    }
}

