/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.gui.utils;

import com.nitsha.binds.gui.utils.GUIUtils;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class AnimatedSprite {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    private int textureU;
    private final int minU;
    private final int maxU;
    private final int step;
    private final int frameDelayMs;
    private int color = -1;
    private final int texV;
    private final class_2960 texture;
    private boolean animating = false;
    private boolean isOpen;
    private final int textureW;
    private final int textureH;
    private boolean loop = false;
    private long lastUpdateTime;
    private float timeAccumulator;

    public AnimatedSprite(int width, int height, class_2960 texture, int texV, boolean isOpen, int textureU, int minU, int maxU, int step, int frameDelayMs, int textureW, int textureH) {
        this.width = width;
        this.height = height;
        this.textureU = textureU;
        this.minU = minU;
        this.maxU = maxU;
        this.step = step;
        this.frameDelayMs = frameDelayMs;
        this.texture = texture;
        this.texV = texV;
        this.isOpen = isOpen;
        this.textureW = textureW;
        this.textureH = textureH;
        this.lastUpdateTime = 0L;
        this.timeAccumulator = 0.0f;
    }

    public void render(class_332 ctx) {
        GUIUtils.adaptiveDrawTexture(ctx, this.texture, this.x, this.y, this.textureU, this.texV, this.width, this.height, this.textureW, this.textureH, this.color);
        this.tick();
    }

    public void startAnimation(boolean open) {
        this.isOpen = open;
        this.animating = true;
        this.lastUpdateTime = System.currentTimeMillis();
        this.timeAccumulator = 0.0f;
    }

    public void stopAnimation() {
        this.isOpen = false;
        this.animating = false;
        this.lastUpdateTime = 0L;
        this.timeAccumulator = 0.0f;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public boolean isLooping() {
        return this.loop;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void tick() {
        if (!this.animating) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
            return;
        }
        long deltaTime = currentTime - this.lastUpdateTime;
        this.lastUpdateTime = currentTime;
        this.timeAccumulator += (float)deltaTime;
        while (this.timeAccumulator >= (float)this.frameDelayMs) {
            this.timeAccumulator -= (float)this.frameDelayMs;
            if (this.isOpen) {
                if (this.textureU < this.maxU) {
                    this.textureU += this.step;
                    continue;
                }
                if (this.loop) {
                    this.textureU = this.minU;
                    continue;
                }
                this.textureU = this.maxU;
                this.animating = false;
                break;
            }
            if (this.textureU > this.minU) {
                this.textureU -= this.step;
                continue;
            }
            if (this.loop) {
                this.textureU = this.maxU;
                continue;
            }
            this.textureU = this.minU;
            this.animating = false;
            break;
        }
    }
}

