/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.gui.panels;

import com.nitsha.binds.ItemsMapper;
import com.nitsha.binds.MainClass;
import com.nitsha.binds.configs.BindsConfig;
import com.nitsha.binds.gui.screen.BindsEditor;
import com.nitsha.binds.gui.screen.BindsGUI;
import com.nitsha.binds.gui.utils.AnimatedSprite;
import com.nitsha.binds.gui.utils.GUIUtils;
import com.nitsha.binds.gui.utils.TextUtils;
import com.nitsha.binds.gui.widget.AnimatedWindow;
import com.nitsha.binds.gui.widget.BedrockIconButton;
import com.nitsha.binds.gui.widget.BedrockIconTextButton;
import com.nitsha.binds.gui.widget.ItemButton;
import com.nitsha.binds.utils.EasterEgg;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;

public class BasicOptionsWindow
extends AnimatedWindow {
    private BindsEditor.TextField bindNameField;
    private ItemButton editIconBtn;
    private BedrockIconButton pasteBtn;
    private BedrockIconTextButton editAction;
    private static final class_2960 ITEMS_EDIT = MainClass.id("textures/gui/test/items_1.png");
    private static final class_2960 CAT_MENU = MainClass.id("textures/gui/cat_menu.png");
    private static final class_2960 CAT_SPRITE = MainClass.id("textures/gui/cat_sprite.png");
    private static final class_2960 CAT_EYES = MainClass.id("textures/gui/cat_eyes.png");
    private static final class_2960 CAT_MEOW1 = MainClass.id("textures/gui/cat_meow_0.png");
    private static final class_2960 CAT_MEOW2 = MainClass.id("textures/gui/cat_meow_1.png");
    private float eyeDx = 0.0f;
    private float eyeDy = 0.0f;
    private EasterEgg catEasterEgg;
    private CatMeowStates meowStates;

    public BasicOptionsWindow(BindsEditor screen, float x, int y, float width, int height, class_2960 t1, class_2960 t2, int delay) {
        super(x, y, width, height, t1, t2, delay);
        this.initUI(screen);
    }

    private void initUI(BindsEditor screen) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        this.meowStates = CatMeowStates.NOTHING;
        AnimatedSprite catTail = new AnimatedSprite(14, 12, CAT_SPRITE, 0, false, 0, 0, 490, 14, 60, 504, 12);
        AnimatedSprite catMeow1 = new AnimatedSprite(35, 14, CAT_MEOW1, 0, false, 0, 0, 420, 35, 40, 455, 14);
        AnimatedSprite catMeow2 = new AnimatedSprite(35, 14, CAT_MEOW2, 0, false, 0, 0, 420, 35, 40, 455, 14);
        catMeow1.setPosition(120, 158);
        catMeow2.setPosition(120, 158);
        this.catEasterEgg = new EasterEgg(10, 500L, () -> {
            if (!BindsConfig.getBooleanConfig("easterEgg", false)) {
                BindsConfig.setConfig("easterEgg", true);
                this.meowStates = CatMeowStates.HAPPY;
                catMeow2.stopAnimation();
                catMeow1.startAnimation(true);
            } else {
                BindsConfig.setConfig("easterEgg", false);
                this.meowStates = CatMeowStates.SAD;
                catMeow1.stopAnimation();
                catMeow2.startAnimation(true);
            }
        });
        catTail.setLoop(true);
        catTail.setPosition(122, 174);
        catTail.startAnimation(true);
        this.addDrawElement((ctx, mouseX, mouseY) -> GUIUtils.matricesUtil(ctx, 0.0f, 0.0f, 50, () -> {
            class_332 c = (class_332)ctx;
            GUIUtils.adaptiveDrawTexture(ctx, CAT_MENU, 4, 165, 0, 0, 126, 26, 126, 26);
            int eyeCenterX = 105;
            int eyeCenterY = 175;
            float maxOffsetX = 1.4f;
            float maxOffsetY = 1.1f;
            float targetDx = (mouseX - (float)eyeCenterX) / 50.0f;
            float targetDy = (mouseY - (float)eyeCenterY) / 50.0f;
            targetDx = Math.max(-maxOffsetX, Math.min(maxOffsetX, targetDx));
            targetDy = Math.max(-maxOffsetY, Math.min(maxOffsetY, targetDy));
            this.eyeDx += (targetDx - this.eyeDx) * 0.2f;
            this.eyeDy += (targetDy - this.eyeDy) * 0.2f;
            GUIUtils.matricesUtil(ctx, this.eyeDx, this.eyeDy, 0, () -> GUIUtils.adaptiveDrawTexture(ctx, CAT_EYES, eyeCenterX, eyeCenterY, 0, 0, 8, 6, 8, 6));
            catTail.render(c);
            if (this.meowStates == CatMeowStates.HAPPY) {
                catMeow1.render(c);
            }
            if (this.meowStates == CatMeowStates.SAD) {
                catMeow2.render(c);
            }
        }), 1);
        this.bindNameField = new BindsEditor.TextField(textRenderer, 4, 104, 105, 20, 20, "", TextUtils.translatable("nitsha.binds.name", new Object[0]).getString());
        this.editIconBtn = new ItemButton(111, 101, ItemsMapper.getItemStack(BindsConfig.getBind((int)BindsGUI.getCurrentPreset(), (int)BindsEditor.getActiveBind()).icon), () -> {
            screen.openAdvancedOptions();
            screen.getAdvancedOptionsWindow().selectTab(0);
        }, ITEMS_EDIT, "");
        this.editAction = new BedrockIconTextButton(4, 129, 133, 20, "edit_action", TextUtils.translatable("nitsha.binds.openEditor", new Object[0]).getString(), true, () -> {
            screen.openAdvancedOptions();
            screen.getAdvancedOptionsWindow().selectTab(1);
        });
        this.pasteBtn = new BedrockIconButton(49, 151, 43, 20, "paste", false, screen::pasteBind, -16422450, -16288026, -1, -1);
        if (screen.copied.name.isEmpty()) {
            this.pasteBtn.setEnabled(false);
        }
        this.addElement(new BedrockIconButton(4, 151, 43, 20, "copy", true, screen::copyBind));
        this.addElement(new BedrockIconButton(94, 151, 43, 20, "delete", true, screen::deleteBind, -1095865, -36238, -1, -1));
        this.addElement(this.bindNameField);
        this.addElement(this.editIconBtn);
        this.addElement(this.pasteBtn);
        this.addElement(this.editAction);
        this.open(() -> {});
    }

    public BindsEditor.TextField getBindName() {
        return this.bindNameField;
    }

    public ItemButton getEditIcon() {
        return this.editIconBtn;
    }

    public BedrockIconButton getPasteIcon() {
        return this.pasteBtn;
    }

    public boolean isInsideCat(double mouseX, double mouseY, int x, int y, int width, int height) {
        if (!this.isVisible()) {
            return false;
        }
        float catX = this.getX() + x;
        float catY = this.getYOffset() + y;
        float catWidth = catX + (float)width;
        float catHeight = catY + (float)height;
        return mouseX >= (double)catX && mouseX <= (double)catWidth && mouseY >= (double)catY && mouseY <= (double)catHeight;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.isVisible()) {
            return false;
        }
        double adjustedX = mouseX - (double)this.getX();
        double adjustedY = mouseY - (double)this.getYOffset();
        for (class_364 class_3642 : this.method_25396()) {
            if (!class_3642.method_25402(adjustedX, adjustedY, button)) continue;
            return true;
        }
        if (this.catEasterEgg.handleClick(this.isInsideCat(mouseX, mouseY, 94, 171, 45, 16))) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private static enum CatMeowStates {
        NOTHING,
        HAPPY,
        SAD;

    }
}

