/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.gui.widget;

import com.google.common.collect.Lists;
import com.nitsha.binds.gui.utils.DrawElement;
import com.nitsha.binds.gui.utils.GUIUtils;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class ScrollableWindow
extends class_362
implements class_4068,
class_364,
class_6379 {
    private final List<class_364> children = Lists.newArrayList();
    private final List<class_4068> drawables = Lists.newArrayList();
    private final List<DrawElement> drawElements = Lists.newArrayList();
    private int scrollableArea;
    private int scrollOffset;
    private boolean horizontal = false;
    private int maxScroll = 0;
    private int scrollBarOffset = 0;
    private int barSize = 20;
    private boolean isDraggingScrollbar = false;
    private int dragStartY = 0;
    private int dragStartScrollOffset = 0;
    private int x;
    private int y;
    private int realX;
    private int realY;
    private int width;
    private int height;

    public ScrollableWindow(int x, int y, int realX, int realY, int width, int height, boolean horizontal) {
        this.children.clear();
        this.drawElements.clear();
        this.horizontal = horizontal;
        this.scrollBarOffset = 0;
        this.scrollableArea = 0;
        this.scrollOffset = 0;
        this.x = x;
        this.y = y;
        this.realX = realX;
        this.realY = realY;
        this.width = width;
        this.height = height;
        this.updateScrollLogic();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setRealY(int rY) {
        this.realY = rY;
    }

    public void addDrawElement(DrawElement.Drawer drawer) {
        this.drawElements.add(new DrawElement(drawer));
    }

    public <T extends class_364 & class_4068> void addElement(T drawableElement) {
        this.children.add(drawableElement);
        this.drawables.add(drawableElement);
    }

    public <T extends class_364 & class_4068> void addElementAfter(T drawableElement, int index) {
        int insertPosChildren = Math.min(this.children.size(), index);
        int insertPosDrawables = Math.min(this.drawables.size(), index);
        this.children.add(insertPosChildren, drawableElement);
        this.drawables.add(insertPosDrawables, drawableElement);
    }

    public void clearChildren() {
        this.children.clear();
        this.drawables.clear();
    }

    public void setScrollableArea(int scrollableArea) {
        this.scrollableArea = scrollableArea;
        this.updateScrollLogic();
    }

    public void addScrollableArea(int delta) {
        this.scrollableArea += delta;
        this.updateScrollLogic();
    }

    public void resetScroll() {
        this.scrollOffset = 0;
        this.scrollBarOffset = 0;
    }

    public void scrollToBottom() {
        this.scrollOffset = this.maxScroll;
        this.updateScrollLogic();
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        int aX = this.horizontal ? this.getX() - this.scrollOffset : this.getX();
        int aY = !this.horizontal ? this.getY() - this.scrollOffset : this.getY();
        int sX = this.realX + this.x;
        int sY = this.realY + this.y;
        GUIUtils.matricesUtil(ctx, aX, aY, 1, () -> {
            int mX = !this.isMouseInside(mouseX, mouseY) ? -10000 : mouseX - aX;
            int mY = !this.isMouseInside(mouseX, mouseY) ? -10000 : mouseY - aY;
            this.drawElements.forEach(element -> element.render(ctx, mX, mY));
            this.drawables.forEach(element -> element.method_25394(ctx, mX, mY, delta));
        });
        if (this.scrollableArea > this.height) {
            GUIUtils.matricesUtil(ctx, 0.0f, 0.0f, 2, () -> {
                int scrollbarX = this.getX() + this.width - 4;
                int scrollbarY = this.getY() + 1 + this.scrollBarOffset;
                boolean isHoveringScrollbar = this.isInsideScrollbar(mouseX, mouseY);
                int scrollbarColor = isHoveringScrollbar ? Integer.MIN_VALUE : 0x40000000;
                GUIUtils.drawFill(ctx, scrollbarX + (isHoveringScrollbar ? 0 : 1), scrollbarY, scrollbarX + (isHoveringScrollbar ? 4 : 3), scrollbarY + this.barSize, scrollbarColor);
            });
        }
    }

    public List<? extends class_364> method_25396() {
        return this.children;
    }

    public void removeElementsOfType(Class<?> type) {
        this.children.removeIf(type::isInstance);
    }

    public List<DrawElement> drawChildren() {
        return this.drawElements;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public boolean isMouseInside(double mouseX, double mouseY) {
        int w = 0;
        int h = 0;
        if (this.horizontal) {
            h = this.scrollableArea > this.width ? 5 : 0;
        } else {
            w = this.scrollableArea > this.height ? 5 : 0;
        }
        return mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width - w) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height - h);
    }

    public void updateScrollLogic() {
        this.maxScroll = Math.max(0, this.scrollableArea - this.height);
        int trackHeight = this.height - 2;
        this.barSize = this.scrollableArea > 0 ? Math.max(20, (int)((float)this.height / (float)this.scrollableArea * (float)trackHeight)) : trackHeight;
        int scrollArea = trackHeight - this.barSize;
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScroll));
        float scrollProgress = this.maxScroll > 0 ? (float)this.scrollOffset / (float)this.maxScroll : 0.0f;
        this.scrollBarOffset = (int)(scrollProgress * (float)scrollArea);
    }

    private boolean scrollLogic(double mouseX, double mouseY, double amount) {
        if (!this.isMouseInside(mouseX, mouseY)) {
            return false;
        }
        long window = class_310.method_1551().method_22683().method_4490();
        boolean shift = class_3675.method_15987((long)window, (int)340) || class_3675.method_15987((long)window, (int)344);
        int scrollSpeed = shift ? 10 : 5;
        this.scrollOffset = class_3532.method_15340((int)(this.scrollOffset - (int)amount * scrollSpeed), (int)0, (int)this.maxScroll);
        float scrollProgress = this.maxScroll > 0 ? (float)this.scrollOffset / (float)this.maxScroll : 0.0f;
        this.scrollBarOffset = (int)((float)(this.height - 2 - this.barSize) * scrollProgress);
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.scrollLogic(mouseX, mouseY, verticalAmount);
    }

    private boolean isInsideScrollbar(double mouseX, double mouseY) {
        int scrollbarX = this.getX() + this.width - 4;
        int scrollbarY = this.getY() + 1 + this.scrollBarOffset;
        return mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + 4) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + this.barSize);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int aY;
        int aX = this.horizontal ? this.getX() - this.scrollOffset : this.getX();
        int n = aY = !this.horizontal ? this.getY() - this.scrollOffset : this.getY();
        if (button == 0 && this.isInsideScrollbar(mouseX, mouseY)) {
            this.isDraggingScrollbar = true;
            this.dragStartY = (int)mouseY;
            this.dragStartScrollOffset = this.scrollOffset;
            return true;
        }
        if (this.isMouseInside(mouseX, mouseY)) {
            for (class_364 class_3642 : this.method_25396()) {
                if (!class_3642.method_25402(mouseX - (double)aX, mouseY - (double)aY, button)) continue;
                this.method_25395(class_3642);
                if (button == 0) {
                    this.method_25398(true);
                }
                return true;
            }
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        int aY;
        int aX = this.horizontal ? this.getX() - this.scrollOffset : this.getX();
        int n = aY = !this.horizontal ? this.getY() - this.scrollOffset : this.getY();
        if (button == 0 && this.isDraggingScrollbar) {
            this.isDraggingScrollbar = false;
        }
        return super.method_25406(mouseX - (double)aX, mouseY - (double)aY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDraggingScrollbar && button == 0) {
            int trackHeight = this.height - 2;
            int scrollArea = trackHeight - this.barSize;
            int dy = (int)mouseY - this.dragStartY;
            float scrollProgress = (float)dy / (float)scrollArea;
            this.scrollOffset = class_3532.method_15340((int)(this.dragStartScrollOffset + Math.round(scrollProgress * (float)this.maxScroll)), (int)0, (int)this.maxScroll);
            float newProgress = this.maxScroll > 0 ? (float)this.scrollOffset / (float)this.maxScroll : 0.0f;
            this.scrollBarOffset = (int)(newProgress * (float)scrollArea);
        }
        for (class_364 child : this.children) {
            if (!child.method_25403(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (class_364 child : this.children) {
            if (!child.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        for (class_364 child : this.children) {
            if (!child.method_25400(codePoint, modifiers)) continue;
            return true;
        }
        return super.method_25400(codePoint, modifiers);
    }

    public void method_37020(class_6382 builder) {
    }
}

