/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.gui.panels;

import com.nitsha.binds.ItemsMapper;
import com.nitsha.binds.MainClass;
import com.nitsha.binds.gui.screen.BindsEditor;
import com.nitsha.binds.gui.utils.GUIUtils;
import com.nitsha.binds.gui.widget.BedrockIconButton;
import com.nitsha.binds.gui.widget.ItemButton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class IconSelector
extends class_362
implements class_4068,
class_364,
class_6379 {
    private final List<class_364> children = new ArrayList<class_364>();
    private final List<BedrockIconButton> catBtns = new ArrayList<BedrockIconButton>();
    private static final class_2960 ITEMS = MainClass.id("textures/gui/test/items_4.png");
    private static final class_2960 SCROLLER = MainClass.id("textures/gui/test/scroller.png");
    private static final class_2960 SCROLLER_BTN = MainClass.id("textures/gui/btns/button_normal.png");
    private static final class_2960 SCROLLER_BTN_HVR = MainClass.id("textures/gui/btns/button_hover.png");
    private int width;
    private int height;
    private int x;
    private int y;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private int scrollBarOffset = 0;
    private int barSize = 20;
    private static final int COLUMNS = 9;
    private static final int VISIBLE_ROWS = 7;
    public static String activeKey = "STRUCTURE_BLOCK";
    private boolean isDraggingScrollbar = false;
    private String currentCategory = "blocks";
    private class_1799 maceIcon = new class_1799((class_1935)class_1802.field_8527);
    private class_1799[] categories = new class_1799[]{new class_1799((class_1935)class_1802.field_8270), this.maceIcon, new class_1799((class_1935)class_1802.field_8176), ItemsMapper.getPotionItem(class_1847.field_9005, class_1802.field_8574), new class_1799((class_1935)class_1802.field_8380), new class_1799((class_1935)class_1802.field_22020)};
    private final String[] categoriesList = new String[]{"blocks", "tools", "foods", "potions", "colored", "gold"};
    private final BindsEditor screen;
    private int dragStartY = 0;
    private int dragStartScrollOffset = 0;

    public IconSelector(BindsEditor screen, int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.screen = screen;
        this.createButtons();
        int catNum = 6;
        int btnW = (width + 10 - (catNum - 1) * 2) / catNum;
        for (int i = 0; i < catNum; ++i) {
            int finalI = i;
            BedrockIconButton cat = new BedrockIconButton(this.x + (btnW + 2) * i, this.y + this.height + 2, btnW, 20, true, () -> {
                this.currentCategory = this.categoriesList[finalI];
                this.scrollOffset = 0;
                for (BedrockIconButton btn : this.catBtns) {
                    btn.setPressed(false);
                }
                this.catBtns.get(finalI).setPressed(true);
                this.createButtons();
            }, this.categories[i], -1, -8140177, -14606047, -1);
            if (i == 0) {
                cat.setPressed(true);
            }
            this.catBtns.add(cat);
            this.children.add((class_364)cat);
        }
    }

    private void createButtons() {
        this.children.removeIf(element -> element instanceof ItemButton);
        Map<String, class_1799> sourceMap = ItemsMapper.categories.getOrDefault(this.currentCategory, ItemsMapper.itemStackMap);
        ArrayList<Map.Entry<String, class_1799>> fullList = new ArrayList<Map.Entry<String, class_1799>>(sourceMap.entrySet());
        int offset = this.scrollOffset * 9;
        int total = fullList.size();
        int maxVisible = 63;
        int startX = this.x;
        int startY = this.y;
        for (int i = 0; i < maxVisible && i + offset < total; ++i) {
            Map.Entry entry = (Map.Entry)fullList.get(i + offset);
            int row = i / 9;
            int col = i % 9;
            int bx = startX + col * 18;
            int by = startY + row * 18;
            class_1799 stack = (class_1799)entry.getValue();
            String key = (String)entry.getKey();
            ItemButton button = new ItemButton(bx, by, 18, stack, () -> {
                this.screen.getBasicOptionsWindow().getEditIcon().setIcon(stack);
                this.updateButtons(key);
                BindsEditor.editIconBtnString = key;
                if (!BindsEditor.getCBind().actions.isEmpty()) {
                    this.screen.saveBind();
                }
            }, ITEMS, key);
            this.children.add((class_364)button);
        }
        int rowAmount = (int)Math.ceil((float)fullList.size() / 9.0f);
        this.maxScroll = Math.max(0, rowAmount - 7);
        this.updateScrollLogic(rowAmount);
        this.updateButtons(activeKey);
    }

    public void pickRandom() {
        if (ItemsMapper.itemStackMap.isEmpty()) {
            return;
        }
        ArrayList<Map.Entry<String, class_1799>> entries = new ArrayList<Map.Entry<String, class_1799>>(ItemsMapper.itemStackMap.entrySet());
        Map.Entry entry = (Map.Entry)entries.get(new Random().nextInt(entries.size()));
        String key = (String)entry.getKey();
        this.screen.getBasicOptionsWindow().getEditIcon().setIcon((class_1799)entry.getValue());
        this.updateButtons(key);
        BindsEditor.editIconBtnString = key;
        if (!BindsEditor.getCBind().actions.isEmpty()) {
            this.screen.saveBind();
        }
    }

    public void updateButtons(String key) {
        activeKey = key;
        for (class_364 element : this.children) {
            if (!(element instanceof ItemButton)) continue;
            ItemButton btn = (ItemButton)element;
            boolean selected = btn.getKey().equals(key);
            btn.setSelected(selected);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void resetScroll() {
        this.scrollOffset = 0;
        this.currentCategory = "blocks";
        for (BedrockIconButton btn : this.catBtns) {
            btn.setPressed(false);
        }
        this.catBtns.get(0).setPressed(true);
        this.createButtons();
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        for (class_364 element : this.children) {
            if (!(element instanceof class_4068)) continue;
            class_4068 drawable = (class_4068)element;
            drawable.method_25394(ctx, mouseX, mouseY, delta);
        }
        int scrollbarX = this.x + this.width + 1;
        int scrollbarY = this.y + 1 + this.scrollBarOffset;
        boolean isHoveringScrollbar = mouseX >= scrollbarX && mouseX <= scrollbarX + 8 && mouseY >= scrollbarY && mouseY <= scrollbarY + this.barSize;
        class_2960 scrollbarTexture = isHoveringScrollbar || this.isDraggingScrollbar ? SCROLLER_BTN_HVR : SCROLLER_BTN;
        int scrollbarColor = isHoveringScrollbar || this.isDraggingScrollbar ? -1 : -7631989;
        GUIUtils.drawResizableBox(ctx, SCROLLER, this.x + this.width, this.y, 10, this.height, 1, 3);
        GUIUtils.drawResizableBox(ctx, scrollbarTexture, this.x + this.width + 1, this.y + 1 + this.scrollBarOffset, 8, this.barSize, 3, 7);
        GUIUtils.drawFill(ctx, this.x + this.width + 3, this.y + this.barSize / 2 + this.scrollBarOffset, this.x + this.width + 7, this.y + this.barSize / 2 + this.scrollBarOffset + 1, scrollbarColor);
        GUIUtils.drawFill(ctx, this.x + this.width + 3, this.y + this.barSize / 2 + this.scrollBarOffset - 2, this.x + this.width + 7, this.y + this.barSize / 2 + this.scrollBarOffset - 1, scrollbarColor);
        GUIUtils.drawFill(ctx, this.x + this.width + 3, this.y + this.barSize / 2 + this.scrollBarOffset + 2, this.x + this.width + 7, this.y + this.barSize / 2 + this.scrollBarOffset + 3, scrollbarColor);
    }

    public void method_37020(class_6382 builder) {
    }

    public List<? extends class_364> method_25396() {
        return this.children;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void updateScrollLogic(int rowAmount) {
        this.maxScroll = Math.max(0, rowAmount - 7);
        int trackHeight = this.height - 2;
        this.barSize = Math.max(20, trackHeight - this.maxScroll * 5);
        int scrollArea = trackHeight - this.barSize;
        this.scrollOffset = Math.min(this.scrollOffset, this.maxScroll);
        float scrollProgress = this.maxScroll > 0 ? (float)this.scrollOffset / (float)this.maxScroll : 0.0f;
        this.scrollBarOffset = (int)(scrollProgress * (float)scrollArea);
    }

    public boolean isMouseInside(double mouseX, double mouseY) {
        float windowX = this.x;
        float windowY = this.y;
        float windowWidth = this.width;
        float windowHeight = this.height;
        return mouseX >= (double)windowX && mouseX <= (double)(windowX + windowWidth) && mouseY >= (double)windowY && mouseY <= (double)(windowY + windowHeight);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.isMouseInside(mouseX, mouseY)) {
            return false;
        }
        this.scrollOffset = class_3532.method_15340((int)(this.scrollOffset - (int)verticalAmount), (int)0, (int)this.maxScroll);
        float scrollProgress = this.maxScroll > 0 ? (float)this.scrollOffset / (float)this.maxScroll : 0.0f;
        this.scrollBarOffset = (int)((float)(this.height - 2 - this.barSize) * scrollProgress);
        this.createButtons();
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int barX = this.x + this.width + 1;
            int barY = this.y + 1 + this.scrollBarOffset;
            if (mouseX >= (double)barX && mouseX <= (double)(barX + 8) && mouseY >= (double)barY && mouseY <= (double)(barY + this.barSize)) {
                this.isDraggingScrollbar = true;
                this.dragStartY = (int)mouseY;
                this.dragStartScrollOffset = this.scrollOffset;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isDraggingScrollbar) {
            this.isDraggingScrollbar = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDraggingScrollbar && button == 0) {
            int trackHeight = this.height - 2;
            int scrollArea = trackHeight - this.barSize;
            int dy = (int)mouseY - this.dragStartY;
            float scrollProgress = (float)dy / (float)scrollArea;
            this.scrollOffset = class_3532.method_15340((int)(this.dragStartScrollOffset + Math.round(scrollProgress * (float)this.maxScroll)), (int)0, (int)this.maxScroll);
            float newProgress = this.maxScroll > 0 ? (float)this.scrollOffset / (float)this.maxScroll : 0.0f;
            this.scrollBarOffset = (int)(newProgress * (float)scrollArea);
            this.createButtons();
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }
}

