/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.gui.screen;

import com.nitsha.binds.ItemsMapper;
import com.nitsha.binds.MainClass;
import com.nitsha.binds.configs.BindEntry;
import com.nitsha.binds.configs.BindsConfig;
import com.nitsha.binds.configs.KeyBinds;
import com.nitsha.binds.gui.screen.BindsEditor;
import com.nitsha.binds.gui.utils.AnimatedSprite;
import com.nitsha.binds.gui.utils.GUIUtils;
import com.nitsha.binds.gui.utils.TextUtils;
import com.nitsha.binds.gui.widget.ItemButton;
import com.nitsha.binds.utils.BindExecutor;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class BindsGUI
extends class_437 {
    private static final class_2960 EDIT_BTN = MainClass.idSprite("edit");
    private static final class_2960 EDIT_BTN_HOVER = MainClass.idSprite("edit_hover");
    private static final class_2960 ITEMS_SELECTOR = MainClass.id("textures/gui/test/items_3.png");
    private static final class_2960 MENU_BG = MainClass.id("textures/gui/test/menu_bg.png");
    private static final class_2960 MENU_HEADER = MainClass.id("textures/gui/test/menu_header.png");
    private final List<ItemButton> buttons = new ArrayList<ItemButton>();
    private String displayText = TextUtils.translatable("nitsha.binds.list", new Object[0]).getString();
    private int centerX;
    private int centerY;
    private static int currentPage;
    private final int MENU_WIDTH = 125;
    private String textLEFT;
    private String textRIGHT;
    private class_2561 leftArrow;
    private class_2561 rightArrow;
    public static int currentPreset;
    private final List<String> presetNames = (List)BindsConfig.configs.get("presets");
    private static final class_2960 CAT;
    private static final class_2960 CAT_SPRITE;
    private static final class_2960 CAT_EYES;
    private AnimatedSprite catTail;
    private float eyeDx = 0.0f;
    private float eyeDy = 0.0f;
    public static boolean ignoreHoldToOpenOnce;

    public BindsGUI() {
        super(class_333.field_18967);
    }

    protected void method_25426() {
        super.method_25426();
        if (BindsConfig.getBooleanConfig("keepMovement", false)) {
            long handle = this.field_22787.method_22683().method_4490();
            for (class_304 key : this.field_22787.field_1690.field_1839) {
                class_3675.class_306 bound = key.method_1429();
                int code = bound.method_1444();
                if (bound.method_1442() != class_3675.class_307.field_1668 || code <= 0 || !class_3675.method_15987((long)handle, (int)code)) continue;
                class_304.method_1416((class_3675.class_306)bound, (boolean)true);
            }
        }
        this.buttons.clear();
        currentPage = BindsConfig.getBooleanConfig("openLastPage", true) ? BindsConfig.getIntConfig("lastPage", 0) : 0;
        currentPreset = BindsConfig.getBooleanConfig("openLastPreset", true) ? BindsConfig.getIntConfig("lastPreset", 0) : 0;
        this.textLEFT = "[ " + GUIUtils.truncateString(TextUtils.translatable(KeyBinds.PREV_PAGE.method_1428(), new Object[0]).getString(), 4) + " ]";
        this.textRIGHT = "[ " + GUIUtils.truncateString(TextUtils.translatable(KeyBinds.NEXT_PAGE.method_1428(), new Object[0]).getString(), 4) + " ]";
        this.leftArrow = TextUtils.literal(this.textLEFT).method_27694(style -> style.method_10977(class_124.field_1075));
        this.rightArrow = TextUtils.literal(this.textRIGHT).method_27694(style -> style.method_10977(class_124.field_1075));
        this.centerX = (this.field_22789 - 125) / 2;
        this.centerY = (this.field_22790 - 106) / 2 - 21;
        class_4264 configBtn = GUIUtils.createTexturedBtn(this.centerX + 57, this.centerY + 93, 10, 10, new class_2960[]{EDIT_BTN, EDIT_BTN_HOVER}, b -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507((class_437)new BindsEditor(null));
        });
        this.method_37063((class_364)configBtn);
        this.catTail = new AnimatedSprite(14, 12, CAT_SPRITE, 0, false, 0, 0, 490, 14, 60, 504, 12);
        if (BindsConfig.getBooleanConfig("easterEgg", false)) {
            this.catTail.setLoop(true);
            this.catTail.setPosition(this.centerX + 101, this.centerY + 9);
            this.catTail.startAnimation(true);
        }
        this.generateButtons(this.centerX + 3, this.centerY + 27);
    }

    public void method_25394(class_4587 ctx, int mouseX, int mouseY, float delta) {
        if (!this.checkForClose()) {
            GUIUtils.drawResizableBox(ctx, MENU_BG, this.centerX, this.centerY, 125, 106, 3, 7);
            GUIUtils.drawResizableBox(ctx, MENU_HEADER, this.centerX, this.centerY, 125, 22, 4, 9);
            GUIUtils.addText(ctx, class_2561.method_30163((String)this.displayText), 0, this.centerX + 5, this.centerY + 7);
            GUIUtils.addText(ctx, (class_2561)TextUtils.literal(currentPage + 1 + "/5").method_27694(style -> style.method_10977(class_124.field_1080)), 125, this.centerX + 125 - 5, this.centerY + 7, "right", "top");
            int lAC = -1;
            int rAC = -1;
            if (BindsGUI.isInside(mouseX, mouseY, this.centerX + 3, this.centerY + 92, 51, 12)) {
                lAC = -1590244;
            }
            if (BindsGUI.isInside(mouseX, mouseY, this.centerX + 70, this.centerY + 92, 51, 12)) {
                rAC = -1590244;
            }
            GUIUtils.addText(ctx, this.leftArrow, 125, this.centerX + 52, this.centerY + 94, "right", "top");
            GUIUtils.addText(ctx, this.rightArrow, 125, this.centerX + 72, this.centerY + 94, "left", "top");
            GUIUtils.addText(ctx, class_2561.method_30163((String)"\u23f4"), 125, this.centerX + 48 - this.field_22793.method_1727(this.textLEFT), this.centerY + 94, "right", "top", lAC);
            GUIUtils.addText(ctx, class_2561.method_30163((String)"\u23f5"), 125, this.centerX + 76 + this.field_22793.method_1727(this.textRIGHT), this.centerY + 94, "left", "top", rAC);
            int lC = -1;
            int rC = -1;
            if (BindsGUI.isInside(mouseX, mouseY, this.centerX, this.centerY - 20, 22, 18)) {
                lC = -1590244;
            }
            if (BindsGUI.isInside(mouseX, mouseY, this.centerX + 125 - 22, this.centerY - 20, 22, 18)) {
                rC = -1590244;
            }
            GUIUtils.drawResizableBox(ctx, MENU_BG, this.centerX, this.centerY - 20, 125, 18, 3, 7);
            GUIUtils.addText(ctx, class_2561.method_30163((String)"\u23f4"), 0, this.centerX + 5, this.centerY - 15, lC);
            GUIUtils.addText(ctx, class_2561.method_30163((String)"\u23f5"), 125, this.centerX + 125 - 5, this.centerY - 15, "right", "top", rC);
            String full = this.presetNames.get(currentPreset);
            if (full.length() < 15) {
                GUIUtils.addText(ctx, (class_2561)TextUtils.literal(full).method_27694(style -> style.method_10977(class_124.field_1075)), 125, this.centerX, this.centerY - 15, "center", "top");
            } else {
                GUIUtils.addText(ctx, (class_2561)TextUtils.literal(GUIUtils.truncateString(full, 15)).method_27694(style -> style.method_10977(class_124.field_1075)), 125, this.centerX + 22, this.centerY - 15);
            }
            if (BindsConfig.getBooleanConfig("easterEgg", false)) {
                GUIUtils.matricesUtil(ctx, 0.0f, 0.0f, 5, () -> {
                    GUIUtils.adaptiveDrawTexture(ctx, CAT, this.centerX + 77, this.centerY, 0, 0, 35, 26, 35, 26);
                    int eyeCenterX = this.centerX + 84;
                    int eyeCenterY = this.centerY + 10;
                    float maxOffsetX = 1.4f;
                    float maxOffsetY = 1.1f;
                    float targetDx = (float)(mouseX - eyeCenterX) / 50.0f;
                    float targetDy = (float)(mouseY - eyeCenterY) / 50.0f;
                    targetDx = Math.max(-maxOffsetX, Math.min(maxOffsetX, targetDx));
                    targetDy = Math.max(-maxOffsetY, Math.min(maxOffsetY, targetDy));
                    this.eyeDx += (targetDx - this.eyeDx) * 0.2f;
                    this.eyeDy += (targetDy - this.eyeDy) * 0.2f;
                    GUIUtils.matricesUtil(ctx, this.eyeDx, this.eyeDy, 0, () -> GUIUtils.adaptiveDrawTexture(ctx, CAT_EYES, eyeCenterX, eyeCenterY, 0, 0, 8, 6, 8, 6));
                    this.catTail.render(ctx);
                });
            }
            super.method_25394(ctx, mouseX, mouseY, delta);
        }
    }

    public static int getCurrentPreset() {
        return currentPreset;
    }

    public void generateButtons(int startX, int startY) {
        for (ItemButton button : this.buttons) {
            this.method_37066((class_364)button);
        }
        this.buttons.clear();
        int currentX = startX;
        int currentY = startY;
        for (int row = 0; row < 8; ++row) {
            BindEntry currentBind = BindsConfig.getBind(currentPreset, row + 8 * currentPage);
            ItemButton button = this.createBtn(GUIUtils.truncateString(currentBind.name, 12), ItemsMapper.getItemStack(currentBind.icon), currentX, currentY, currentBind);
            this.buttons.add(button);
            this.method_37063((class_364)button);
            currentX += 31;
            if (row != 3) continue;
            currentX = startX;
            currentY = startY + 31;
        }
    }

    private ItemButton createBtn(final String text, class_1799 icon, int x, int y, BindEntry bind) {
        return new ItemButton(x, y, icon, () -> {
            BindExecutor.startBind(bind);
            if (BindsConfig.getBooleanConfig("closeOnAction", false)) {
                ignoreHoldToOpenOnce = true;
                this.field_22787.method_1507(null);
            }
        }, ITEMS_SELECTOR, ""){

            @Override
            public void method_25359(class_4587 ctx, int mouseX, int mouseY, float delta) {
                super.method_25359(ctx, mouseX, mouseY, delta);
                if (this.method_25367()) {
                    BindsGUI.this.displayText = text;
                    if (text.isEmpty()) {
                        BindsGUI.this.displayText = TextUtils.translatable("nitsha.binds.empty", new Object[0]).getString();
                    }
                }
            }
        };
    }

    public boolean method_25422() {
        return true;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        class_304.method_1416((class_3675.class_306)KeyBinds.BINDS.method_1429(), (boolean)false);
    }

    private boolean checkForClose() {
        if (!BindsConfig.getBooleanConfig("holdToOpen", true)) {
            return false;
        }
        if (ignoreHoldToOpenOnce) {
            ignoreHoldToOpenOnce = false;
            return false;
        }
        if (!class_3675.method_15987((long)this.field_22787.method_22683().method_4490(), (int)KeyBindingHelper.getBoundKeyOf((class_304)KeyBinds.BINDS).method_1444())) {
            this.field_22787.method_1507((class_437)null);
            return true;
        }
        return false;
    }

    private void updatePage(int dir) {
        if (dir == -1 && currentPage == 0) {
            currentPage = 5;
        }
        if ((currentPage += dir) == 5) {
            currentPage = 0;
        }
        BindsConfig.setConfig("lastPreset", currentPreset);
        BindsConfig.setConfig("lastPage", currentPage);
        this.generateButtons(this.centerX + 3, this.centerY + 27);
    }

    private void updatePreset(int dir) {
        if (dir == -1 && currentPreset == 0) {
            currentPreset = 8;
        }
        if ((currentPreset += dir) == 8) {
            currentPreset = 0;
        }
        currentPage = 0;
        BindsConfig.setConfig("lastPreset", currentPreset);
        BindsConfig.setConfig("lastPage", currentPage);
        this.generateButtons(this.centerX + 3, this.centerY + 27);
    }

    private void setPreset(int index) {
        currentPreset = index;
        currentPage = 0;
        BindsConfig.setConfig("lastPreset", currentPreset);
        BindsConfig.setConfig("lastPage", currentPage);
        this.generateButtons(this.centerX + 3, this.centerY + 27);
    }

    public static boolean isInside(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    private boolean handleClick(double mouseX, double mouseY, int x, int y, int width, int height, Runnable action) {
        if (BindsGUI.isInside(mouseX, mouseY, x, y, width, height)) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            action.run();
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.handleClick(mouseX, mouseY, this.centerX + 3, this.centerY + 92, 51, 12, () -> this.updatePage(-1))) {
            return true;
        }
        if (this.handleClick(mouseX, mouseY, this.centerX + 70, this.centerY + 92, 51, 12, () -> this.updatePage(1))) {
            return true;
        }
        if (this.handleClick(mouseX, mouseY, this.centerX, this.centerY - 20, 22, 18, () -> this.updatePreset(-1))) {
            return true;
        }
        if (this.handleClick(mouseX, mouseY, this.centerX + 125 - 22, this.centerY - 20, 22, 18, () -> this.updatePreset(1))) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == KeyBindingHelper.getBoundKeyOf((class_304)KeyBinds.BINDS).method_1444() && !BindsConfig.getBooleanConfig("holdToOpen", true) && !ignoreHoldToOpenOnce || keyCode == 256) {
            ignoreHoldToOpenOnce = false;
            this.field_22787.method_1507((class_437)null);
            return true;
        }
        if (keyCode == KeyBindingHelper.getBoundKeyOf((class_304)KeyBinds.PREV_PAGE).method_1444()) {
            this.updatePage(-1);
            return true;
        }
        if (keyCode == KeyBindingHelper.getBoundKeyOf((class_304)KeyBinds.NEXT_PAGE).method_1444()) {
            this.updatePage(1);
            return true;
        }
        if (keyCode >= 49 && keyCode <= 57) {
            int index = keyCode - 49;
            this.setPreset(index);
            return true;
        }
        if (BindsConfig.getBooleanConfig("keepMovement", false) && this.field_22787.field_1690 != null && this.field_22787.method_22683() != null && (this.field_22787.field_1690.field_1894.method_1417(keyCode, scanCode) || this.field_22787.field_1690.field_1881.method_1417(keyCode, scanCode) || this.field_22787.field_1690.field_1913.method_1417(keyCode, scanCode) || this.field_22787.field_1690.field_1849.method_1417(keyCode, scanCode) || this.field_22787.field_1690.field_1903.method_1417(keyCode, scanCode) || this.field_22787.field_1690.field_1867.method_1417(keyCode, scanCode) || this.field_22787.field_1690.field_1832.method_1417(keyCode, scanCode))) {
            class_3675.class_306 key = class_3675.method_15985((int)keyCode, (int)scanCode);
            class_304.method_1416((class_3675.class_306)key, (boolean)true);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (BindsConfig.getBooleanConfig("keepMovement", false)) {
            class_3675.class_306 key = class_3675.method_15985((int)keyCode, (int)scanCode);
            class_304.method_1416((class_3675.class_306)key, (boolean)false);
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    static {
        CAT = MainClass.id("textures/gui/cat_2.png");
        CAT_SPRITE = MainClass.id("textures/gui/cat_sprite_2.png");
        CAT_EYES = MainClass.id("textures/gui/cat_eyes.png");
        ignoreHoldToOpenOnce = false;
    }
}

