/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.gui;

import com.nitsha.binds.ItemsMapper;
import com.nitsha.binds.MainClass;
import com.nitsha.binds.configs.BindsConfig;
import com.nitsha.binds.configs.KeyBinds;
import com.nitsha.binds.gui.GUIUtils;
import com.nitsha.binds.gui.panels.BindsEditor;
import com.nitsha.binds.gui.widget.ItemButton;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import net.minecraft.class_6880;

public class BindsGUI
extends class_437 {
    private static final class_2960 BUTTONS_TEXTURE = MainClass.id("textures/gui/binds_gui.png");
    private static final class_2960 EDIT_BTN = MainClass.id("edit");
    private static final class_2960 EDIT_BTN_HOVER = MainClass.id("edit_hover");
    private static final class_2960 ITEMS_SELECTOR = MainClass.id("textures/gui/test/items_3.png");
    private static final class_2960 MENU_BG = MainClass.id("textures/gui/test/menu_bg.png");
    private static final class_2960 MENU_HEADER = MainClass.id("textures/gui/test/menu_header.png");
    private String displayText = class_2561.method_43471((String)"nitsha.binds.list").getString();
    private int centerX;
    private int centerY;
    private static int currentPage = 0;
    private final List<ItemButton> buttons;
    private final int MENU_WIDTH = 125;
    private String textLEFT;
    private String textRIGHT;
    private class_2561 leftArrow;
    private class_2561 rightArrow;
    public static int presetNum = 0;
    private final List<String> presetNames = (List)BindsConfig.configs.get("presets");

    public BindsGUI() {
        super(class_333.field_18967);
        this.buttons = new ArrayList<ItemButton>();
    }

    protected void method_25426() {
        super.method_25426();
        this.buttons.clear();
        this.textLEFT = "[ " + GUIUtils.truncateString(class_2561.method_43471((String)KeyBinds.PREV_PAGE.method_1428()).getString(), 4) + " ]";
        this.textRIGHT = "[ " + GUIUtils.truncateString(class_2561.method_43471((String)KeyBinds.NEXT_PAGE.method_1428()).getString(), 4) + " ]";
        this.leftArrow = class_2561.method_43470((String)this.textLEFT).method_27694(style -> style.method_10977(class_124.field_1075));
        this.rightArrow = class_2561.method_43470((String)this.textRIGHT).method_27694(style -> style.method_10977(class_124.field_1075));
        this.centerX = (this.field_22789 - 125) / 2;
        this.centerY = (this.field_22790 - 106) / 2 - 21;
        class_344 configBtn = GUIUtils.createTexturedBtn(this.centerX + 57, this.centerY + 93, 10, 10, new class_2960[]{EDIT_BTN, EDIT_BTN_HOVER}, b -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507((class_437)new BindsEditor());
        });
        this.method_37063((class_364)configBtn);
        this.generateButtons(this.centerX + 3, this.centerY + 27);
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        if (!this.checkForClose()) {
            GUIUtils.drawResizableBox(ctx, MENU_BG, this.centerX, this.centerY, 125, 106, 3, 7);
            GUIUtils.drawResizableBox(ctx, MENU_HEADER, this.centerX, this.centerY, 125, 22, 4, 9);
            GUIUtils.addText(ctx, class_2561.method_30163((String)this.displayText), 0, this.centerX + 5, this.centerY + 7);
            GUIUtils.addText(ctx, (class_2561)class_2561.method_43470((String)(currentPage + 1 + "/5")).method_27694(style -> style.method_10977(class_124.field_1080)), 125, this.centerX + 125 - 5, this.centerY + 7, "right", "top");
            int lAC = -1;
            int rAC = -1;
            if (BindsGUI.isInside(mouseX, mouseY, this.centerX + 3, this.centerY + 92, 51, 12)) {
                lAC = -1590244;
            }
            if (BindsGUI.isInside(mouseX, mouseY, this.centerX + 70, this.centerY + 92, 51, 12)) {
                rAC = -1590244;
            }
            GUIUtils.addText(ctx, this.leftArrow, 125, this.centerX + 52, this.centerY + 94, "right", "top");
            GUIUtils.addText(ctx, this.rightArrow, 125, this.centerX + 72, this.centerY + 94, "left", "top");
            GUIUtils.addText(ctx, class_2561.method_30163((String)"\u23f4"), 125, this.centerX + 48 - this.field_22793.method_1727(this.textLEFT), this.centerY + 94, "right", "top", lAC);
            GUIUtils.addText(ctx, class_2561.method_30163((String)"\u23f5"), 125, this.centerX + 76 + this.field_22793.method_1727(this.textRIGHT), this.centerY + 94, "left", "top", rAC);
            int lC = -1;
            int rC = -1;
            if (BindsGUI.isInside(mouseX, mouseY, this.centerX, this.centerY - 20, 22, 18)) {
                lC = -1590244;
            }
            if (BindsGUI.isInside(mouseX, mouseY, this.centerX + 125 - 22, this.centerY - 20, 22, 18)) {
                rC = -1590244;
            }
            GUIUtils.drawResizableBox(ctx, MENU_BG, this.centerX, this.centerY - 20, 125, 18, 3, 7);
            GUIUtils.addText(ctx, class_2561.method_30163((String)"\u23f4"), 0, this.centerX + 5, this.centerY - 15, lC);
            GUIUtils.addText(ctx, class_2561.method_30163((String)"\u23f5"), 125, this.centerX + 125 - 5, this.centerY - 15, "right", "top", rC);
            String num = presetNum + 1 + ". ";
            String full = num + this.presetNames.get(presetNum);
            if (full.length() < 15) {
                GUIUtils.addText(ctx, (class_2561)class_2561.method_43470((String)full).method_27694(style -> style.method_10977(class_124.field_1075)), 125, this.centerX, this.centerY - 15, "center", "top");
            } else {
                GUIUtils.addText(ctx, (class_2561)class_2561.method_43470((String)GUIUtils.truncateString(full, 15)).method_27694(style -> style.method_10977(class_124.field_1075)), 125, this.centerX + 22, this.centerY - 15);
            }
            super.method_25394(ctx, mouseX, mouseY, delta);
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public void generateButtons(int startX, int startY) {
        for (ItemButton button : this.buttons) {
            this.method_37066((class_364)button);
        }
        this.buttons.clear();
        int currentX = startX;
        int currentY = startY;
        for (int row = 0; row < 8; ++row) {
            String[] currentBind = BindsConfig.getBind(presetNum, row + 8 * currentPage);
            ItemButton button = this.createBtn(GUIUtils.truncateString(currentBind[0], 12), ItemsMapper.getItemStack(currentBind[1]), currentX, currentY, currentBind[2]);
            this.buttons.add(button);
            this.method_37063((class_364)button);
            currentX += 31;
            if (row != 3) continue;
            currentX = startX;
            currentY = startY + 31;
        }
    }

    private ItemButton createBtn(final String text, class_1799 icon, int x, int y, String command) {
        return new ItemButton(x, y, icon, () -> {
            assert (class_310.method_1551().field_1724 != null);
            if (!command.isEmpty()) {
                class_310.method_1551().field_1724.field_3944.method_45731(command);
            }
        }, ITEMS_SELECTOR, ""){

            @Override
            public void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
                super.method_48579(ctx, mouseX, mouseY, delta);
                if (this.method_49606()) {
                    BindsGUI.this.displayText = text;
                    if (text.isEmpty()) {
                        BindsGUI.this.displayText = class_2561.method_43471((String)"nitsha.binds.empty").getString();
                    }
                }
            }
        };
    }

    public boolean method_25422() {
        return true;
    }

    public boolean method_25421() {
        return false;
    }

    private boolean checkForClose() {
        if (!class_3675.method_15987((long)this.field_22787.method_22683().method_4490(), (int)KeyBindingHelper.getBoundKeyOf((class_304)KeyBinds.BINDS).method_1444())) {
            this.field_22787.method_1507((class_437)null);
            return true;
        }
        return false;
    }

    private void updatePage(int dir) {
        if (dir == -1 && currentPage == 0) {
            currentPage = 5;
        }
        if ((currentPage += dir) == 5) {
            currentPage = 0;
        }
        this.generateButtons(this.centerX + 3, this.centerY + 27);
    }

    private void updatePreset(int dir) {
        if (dir == -1 && presetNum == 0) {
            presetNum = 8;
        }
        if ((presetNum += dir) == 8) {
            presetNum = 0;
        }
        currentPage = 0;
        this.generateButtons(this.centerX + 3, this.centerY + 27);
    }

    private void setPreset(int index) {
        presetNum = index;
        currentPage = 0;
        this.generateButtons(this.centerX + 3, this.centerY + 27);
    }

    public static boolean isInside(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    private boolean handleClick(double mouseX, double mouseY, int x, int y, int width, int height, Runnable action) {
        if (BindsGUI.isInside(mouseX, mouseY, x, y, width, height)) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            action.run();
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.handleClick(mouseX, mouseY, this.centerX + 3, this.centerY + 92, 51, 12, () -> this.updatePage(-1))) {
            return true;
        }
        if (this.handleClick(mouseX, mouseY, this.centerX + 70, this.centerY + 92, 51, 12, () -> this.updatePage(1))) {
            return true;
        }
        if (this.handleClick(mouseX, mouseY, this.centerX, this.centerY - 20, 22, 18, () -> this.updatePreset(-1))) {
            return true;
        }
        if (this.handleClick(mouseX, mouseY, this.centerX + 125 - 22, this.centerY - 20, 22, 18, () -> this.updatePreset(1))) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == KeyBindingHelper.getBoundKeyOf((class_304)KeyBinds.PREV_PAGE).method_1444()) {
            this.updatePage(-1);
            return true;
        }
        if (keyCode == KeyBindingHelper.getBoundKeyOf((class_304)KeyBinds.NEXT_PAGE).method_1444()) {
            this.updatePage(1);
            return true;
        }
        if (keyCode >= 49 && keyCode <= 57) {
            int index = keyCode - 49;
            this.setPreset(index);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Environment(value=EnvType.CLIENT)
    public class BindButton
    extends class_339 {
        private final class_1799 icon;
        private final Runnable onClick;
        private final boolean status;

        public BindButton(BindsGUI this$0, int x, int y, class_1799 icon, Runnable onClick, boolean status) {
            super(x, y, 26, 26, (class_2561)class_2561.method_43473());
            this.icon = icon;
            this.onClick = onClick;
            this.status = status;
        }

        public boolean method_25367() {
            return super.method_25367();
        }

        public void method_25348(double mouseX, double mouseY) {
            if (this.status) {
                this.onClick.run();
            }
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            this.drawBackground(context);
            context.method_51427(this.icon, this.method_46426() + 5, this.method_46427() + 5);
            if (this.method_49606() && this.status) {
                this.drawSelectionBox(context);
            }
        }

        public void method_47399(class_6382 builder) {
            this.method_37021(builder);
        }

        private void drawBackground(class_332 context) {
            GUIUtils.adaptiveDrawTexture(context, BUTTONS_TEXTURE, this.method_46426(), this.method_46427(), 0, 0, 26, 26, 320);
        }

        private void drawSelectionBox(class_332 context) {
            GUIUtils.adaptiveDrawTexture(context, BUTTONS_TEXTURE, this.method_46426(), this.method_46427(), 26, 0, 26, 26, 320);
        }
    }
}

