/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.gui.panels;

import com.nitsha.binds.ItemsMapper;
import com.nitsha.binds.MainClass;
import com.nitsha.binds.configs.BindsConfig;
import com.nitsha.binds.configs.KeyBinds;
import com.nitsha.binds.gui.BindsGUI;
import com.nitsha.binds.gui.GUIUtils;
import com.nitsha.binds.gui.extend.AnimatedSprite;
import com.nitsha.binds.gui.panels.IconSelector;
import com.nitsha.binds.gui.widget.AnimatedWindow;
import com.nitsha.binds.gui.widget.BedrockButton;
import com.nitsha.binds.gui.widget.BedrockIconButton;
import com.nitsha.binds.gui.widget.ItemButton;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class BindsEditor
extends class_437 {
    private static final class_2960 BACKGROUND = MainClass.id("textures/gui/test/editor_bg.png");
    private static final class_2960 BACKGROUND_FLAT = MainClass.id("textures/gui/test/editor_bg_flat.png");
    private static final class_2960 BACKGROUND_DARK = MainClass.id("textures/gui/test/editor_bg_dark.png");
    private static final class_2960 BACKGROUND_DARK_FLAT = MainClass.id("textures/gui/test/editor_bg_dark_flat.png");
    private static final class_2960 FRAME = MainClass.id("textures/gui/test/frame.png");
    private static final class_2960 ARROW_SPRITE = MainClass.id("textures/gui/test/arrow_animation.png");
    private static final class_2960 ARROW_SPRITE_LEFT = MainClass.id("textures/gui/test/arrow_animation_left.png");
    private static final class_2960 ITEMS_SELECTOR = MainClass.id("textures/gui/test/items_2.png");
    private static final class_2960 ITEMS_EDIT = MainClass.id("textures/gui/test/items_1.png");
    private static final class_2960 ARROW_L = MainClass.id("arrow_left");
    private static final class_2960 ARROW_L_HOVER = MainClass.id("arrow_left_hover");
    private static final class_2960 ARROW_R = MainClass.id("arrow_right");
    private static final class_2960 ARROW_R_HOVER = MainClass.id("arrow_right_hover");
    private static final class_2960 RANDOM = MainClass.id("random");
    private static final class_2960 RANDOM_HOVER = MainClass.id("random_hover");
    private static final class_2960 CLOSE = MainClass.id("close");
    private static final class_2960 CLOSE_HOVER = MainClass.id("close_hover");
    private final int TEXTURE_WIDTH = 141;
    private final int TEXTURE_HEIGHT = 190;
    private class_342 bindNameField;
    private class_342 commandField;
    private class_342 presetName;
    private class_344 closeBtn;
    private BedrockButton saveBtn;
    private BedrockIconButton copyBtn;
    private BedrockIconButton pasteBtn;
    private BedrockIconButton deleteBtn;
    private BedrockButton savePrsBtn;
    private int centerX;
    private int centerY;
    private boolean selectorOpening = false;
    public static boolean isSelectorOpened = false;
    private static int currentPage = 0;
    private static int activeBind = 0;
    public static ItemButton editIconBtn;
    public static String editIconBtnString;
    private static String[] copied;
    private List<ItemButton> buttons;
    private AnimatedSprite rightBtn;
    private AnimatedSprite leftBtn;
    private class_344 leftA;
    private class_344 rightA;
    private class_344 random;
    private AnimatedWindow mainW;
    private AnimatedWindow presetW;
    private AnimatedWindow bindsW;
    private AnimatedWindow iconsH;
    private IconSelector selector;
    private final List<AnimatedWindow> animWindows = new ArrayList<AnimatedWindow>();
    private final List<BedrockButton> prsBtns = new ArrayList<BedrockButton>();
    private final List<String> presetNames = (List)BindsConfig.configs.get("presets");
    private final int coeff = 200;
    private int currentPreset = BindsGUI.presetNum;

    public BindsEditor() {
        super(class_333.field_18967);
        this.buttons = new ArrayList<ItemButton>();
        currentPage = 0;
        activeBind = 0;
    }

    protected void method_25426() {
        super.method_25426();
        this.animWindows.clear();
        this.prsBtns.clear();
        this.centerX = this.field_22789 / 2 - 70;
        this.centerY = (this.field_22790 - 190) / 2;
        this.selectorOpening = false;
        isSelectorOpened = false;
        this.createMainW();
        this.createPresetW();
        this.createBindsW();
        this.createIconSelector();
        this.selectBind();
    }

    public void createMainW() {
        this.mainW = new AnimatedWindow(141.0f, 190, this.centerX, this.centerY, BACKGROUND, BACKGROUND_FLAT, 0);
        this.mainW.addDrawElement(drawContext -> {
            class_5250 comText = class_2561.method_43471((String)"nitsha.binds.command");
            int comWidth = this.field_22793.method_27525((class_5348)comText);
            drawContext.method_51439(this.field_22793, (class_2561)comText, 5, 133, -14606047, false);
            drawContext.method_25292(6 + comWidth, 136, 137, -14606047);
        });
        this.bindNameField = new TextField(this.field_22793, 4, 106, 105, 20, 20, "", class_2561.method_43471((String)"nitsha.binds.name").getString());
        this.commandField = new TextField(this.field_22793, 4, 142, 133, 20, Integer.MAX_VALUE, "", class_2561.method_43471((String)"nitsha.binds.command_example").getString());
        editIconBtn = new ItemButton(111, 103, ItemsMapper.getItemStack(BindsConfig.getBind(this.currentPreset, activeBind)[1]), this::openIconsSelector, ITEMS_EDIT, "");
        this.saveBtn = new BedrockButton(class_2561.method_43471((String)"nitsha.binds.save_bind").getString(), 4, 164, 67, 20, this::saveBind);
        this.copyBtn = new BedrockIconButton(73, 164, 20, 20, "copy", true, this::copyBind);
        this.pasteBtn = new BedrockIconButton(95, 164, 20, 20, "paste", false, this::pasteBind, -16422450, -16288026, -1, -1);
        this.deleteBtn = new BedrockIconButton(117, 164, 20, 20, "delete", true, this::deleteBind, -1095865, -36238, -1, -1);
        if (copied[0].isEmpty()) {
            this.pasteBtn.setEnabled(false);
        }
        this.mainW.addElement((class_364)this.bindNameField);
        this.mainW.addElement((class_364)this.commandField);
        this.mainW.addElement((class_364)editIconBtn);
        this.mainW.addElement((class_364)this.saveBtn);
        this.mainW.addElement((class_364)this.copyBtn);
        this.mainW.addElement((class_364)this.pasteBtn);
        this.mainW.addElement((class_364)this.deleteBtn);
        this.animWindows.add(this.mainW);
        this.mainW.open(() -> {});
        this.method_37063(this.mainW);
    }

    public void createPresetW() {
        this.presetW = new AnimatedWindow(96.0f, 140, this.centerX - 118, this.centerY + 25, BACKGROUND, BACKGROUND_FLAT, 4);
        this.presetW.addDrawElement(drawContext -> {
            drawContext.method_51433(this.field_22793, class_2561.method_43471((String)"nitsha.binds.selectPreset").getString(), 5, 5, -14606047, false);
            drawContext.method_51433(this.field_22793, class_2561.method_43471((String)"nitsha.binds.renamePreset").getString(), 5, 83, -14606047, false);
        });
        this.presetName = new TextField(this.field_22793, 4, 92, 88, 20, 20, "", class_2561.method_43471((String)"nitsha.binds.name").getString());
        this.presetName.method_1852(this.presetNames.get(this.currentPreset));
        this.savePrsBtn = new BedrockButton(class_2561.method_43471((String)"nitsha.binds.save_bind").getString(), 4, 114, 88, 20, () -> {
            String getName = this.presetName.method_1882();
            String newName = getName.isEmpty() ? "Default" : getName;
            BindsConfig.setNewPresetName(this.currentPreset, newName);
            this.presetName.method_1852(newName);
        });
        this.presetW.addElement((class_364)this.presetName);
        this.presetW.addElement((class_364)this.savePrsBtn);
        int startX = 4;
        int startY = 15;
        for (int i = 0; i < 9; ++i) {
            int row = i / 3;
            int col = i % 3;
            int bx = startX + col * 30;
            int by = startY + row * 22;
            int finalI = i;
            BedrockButton prs = new BedrockButton(String.valueOf(i + 1), bx, by, 28, 20, true, () -> {
                this.selectPreset(finalI);
                for (BedrockButton btn : this.prsBtns) {
                    btn.setPressed(false);
                }
                this.prsBtns.get(finalI).setPressed(true);
            });
            if (i == this.currentPreset) {
                prs.setPressed(true);
            }
            this.prsBtns.add(prs);
            this.presetW.addElement((class_364)prs);
        }
        this.animWindows.add(this.presetW);
        this.presetW.open(() -> {});
        this.method_37063(this.presetW);
    }

    private void selectPreset(int i) {
        this.currentPreset = i;
        currentPage = 0;
        activeBind = 0;
        this.presetName.method_1852(this.presetNames.get(this.currentPreset));
        this.generateButtons(7, 31);
        this.selectBind();
    }

    public void createBindsW() {
        this.bindsW = new AnimatedWindow(133.0f, 100, this.centerX + 4, this.centerY - 1, BACKGROUND_DARK, BACKGROUND_DARK_FLAT, 40);
        this.leftA = GUIUtils.createTexturedBtn(-19, 43, 11, 11, new class_2960[]{ARROW_L, ARROW_L_HOVER}, button -> this.updatePage(-1));
        this.rightA = GUIUtils.createTexturedBtn(141, 43, 11, 11, new class_2960[]{ARROW_R, ARROW_R_HOVER}, button -> this.updatePage(1));
        this.closeBtn = GUIUtils.createTexturedBtn(110, 7, 16, 16, new class_2960[]{CLOSE, CLOSE_HOVER}, button -> this.field_22787.method_1507(null));
        this.rightBtn = new AnimatedSprite(22, 15, ARROW_SPRITE, 0, false, 0, 0, 220, 22, 2, 242, 15);
        this.leftBtn = new AnimatedSprite(22, 15, ARROW_SPRITE_LEFT, 0, false, 0, 0, 220, 22, 2, 242, 15);
        this.bindsW.addDrawElement(drawContext -> {
            GUIUtils.adaptiveDrawTexture(drawContext, FRAME, 4, 4, 0, 0, 125, 90, 125, 90);
            GUIUtils.addText(drawContext, (class_2561)class_2561.method_43471((String)"nitsha.binds.configure"), 141, 8, 11);
            GUIUtils.addText(drawContext, (class_2561)class_2561.method_43470((String)(currentPage + 1 + "/5")).method_27694(style -> style.method_10977(class_124.field_1080)), 133, 108, 11, "right", "top");
            this.leftBtn.setPosition(-20, 42);
            this.rightBtn.setPosition(131, 42);
            this.rightBtn.tick();
            this.leftBtn.tick();
            this.rightBtn.render((class_332)drawContext);
            this.leftBtn.render((class_332)drawContext);
        });
        this.bindsW.open(() -> {
            this.rightBtn.startAnimation(true);
            this.leftBtn.startAnimation(true);
            this.bindsW.addElement((class_364)this.leftA);
            this.bindsW.addElement((class_364)this.rightA);
        });
        this.bindsW.addElement((class_364)this.closeBtn);
        this.generateButtons(7, 31);
        this.method_37063(this.bindsW);
        this.animWindows.add(this.bindsW);
    }

    private void createIconSelector() {
        this.iconsH = new AnimatedWindow(176.0f, 30, this.centerX + 61, this.centerY - 1, BACKGROUND_DARK, BACKGROUND_DARK_FLAT, 20);
        this.random = GUIUtils.createTexturedBtn(152, 6, 16, 16, new class_2960[]{RANDOM, RANDOM_HOVER}, button -> IconSelector.pickRandom());
        this.iconsH.addElement((class_364)this.random);
        this.iconsH.addDrawElement(drawCtx -> GUIUtils.addText(drawCtx, (class_2561)class_2561.method_43471((String)"nitsha.binds.iconSelector"), 140, 8, 10));
        this.selector = new IconSelector(162, 126, this.centerX + 63, this.centerY + 36);
        this.animWindows.add(this.iconsH);
        this.method_37063(this.iconsH);
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.mainW.method_25394(ctx, mouseX, mouseY, delta);
        this.presetW.method_25394(ctx, mouseX, mouseY, delta);
        this.bindsW.method_25394(ctx, mouseX, mouseY, delta);
        this.iconsH.method_25394(ctx, mouseX, mouseY, delta);
        this.selector.method_25394(ctx, mouseX, mouseY, delta);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public boolean method_25422() {
        return true;
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (AnimatedWindow window : this.animWindows) {
            if (!window.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        if (this.selector.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        for (AnimatedWindow window : this.animWindows) {
            if (!window.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) continue;
            return true;
        }
        if (this.selector.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.selector != null && this.selector.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        boolean handled = false;
        if (this.selector.method_25406(mouseX, mouseY, button)) {
            handled = true;
        }
        for (AnimatedWindow window : this.animWindows) {
            if (!window.method_25406(mouseX, mouseY, button)) continue;
            handled = true;
        }
        super.method_25406(mouseX, mouseY, button);
        return handled;
    }

    public boolean method_25400(char codePoint, int modifiers) {
        for (AnimatedWindow window : this.animWindows) {
            if (!window.method_25400(codePoint, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == KeyBindingHelper.getBoundKeyOf((class_304)KeyBinds.PREV_PAGE).method_1444()) {
            this.updatePage(-1);
            return true;
        }
        if (keyCode == KeyBindingHelper.getBoundKeyOf((class_304)KeyBinds.NEXT_PAGE).method_1444()) {
            this.updatePage(1);
            return true;
        }
        for (AnimatedWindow window : this.animWindows) {
            if (!window.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void openIconsSelector() {
        if (this.selectorOpening) {
            return;
        }
        this.selectorOpening = true;
        if (!isSelectorOpened) {
            this.mainW.updateWidth(200.0f);
            this.bindsW.updateX(100.0f);
            this.presetW.close(() -> {});
            this.selector.open(true);
            this.iconsH.open(() -> {
                isSelectorOpened = true;
                this.selectorOpening = false;
            });
        } else {
            this.selector.open(false);
            this.iconsH.close(() -> {
                this.mainW.updateWidth(-200.0f);
                this.bindsW.updateX(-100.0f);
                this.presetW.open(() -> {});
                isSelectorOpened = false;
                this.selectorOpening = false;
            });
        }
        this.updateSelected(ItemsMapper.getItemStack(BindsConfig.getBind(this.currentPreset, activeBind)[1]));
    }

    private void saveBind() {
        String cmd = this.commandField.method_1882();
        if (!cmd.isEmpty()) {
            String bindName;
            String string = bindName = this.bindNameField.method_1882().isEmpty() ? class_2561.method_43471((String)"nitsha.binds.untitled").getString() : this.bindNameField.method_1882();
            if (editIconBtnString.equals("STRUCTURE_VOID")) {
                editIconBtnString = "GRASS";
            }
            BindsConfig.setBind(this.currentPreset, activeBind, new String[]{bindName, editIconBtnString, cmd});
            this.selectBind();
            this.updateSelected(ItemsMapper.getItemStack(BindsConfig.getBind(this.currentPreset, activeBind)[1]));
        }
    }

    private void deleteBind() {
        BindsConfig.setBind(this.currentPreset, activeBind, new String[]{"", "STRUCTURE_VOID", ""});
        this.selectBind();
        this.updateSelected(new class_1799((class_1935)class_1802.field_8615));
    }

    private void copyBind() {
        String[] currentBind = BindsConfig.getBind(this.currentPreset, activeBind);
        if (!currentBind[0].isEmpty()) {
            copied = currentBind;
            this.pasteBtn.setEnabled(true);
        }
    }

    private void pasteBind() {
        BindsConfig.setBind(this.currentPreset, activeBind, copied);
        this.selectBind();
        this.updateSelected(ItemsMapper.getItemStack(BindsConfig.getBind(this.currentPreset, activeBind)[1]));
    }

    private void selectBind() {
        String[] currentBind = BindsConfig.getBind(this.currentPreset, activeBind);
        this.bindNameField.method_1852(currentBind[0]);
        this.commandField.method_1852(currentBind[2]);
        editIconBtn.setIcon(ItemsMapper.getItemStack(BindsConfig.getBind(this.currentPreset, activeBind)[1]));
        editIconBtnString = currentBind[1];
        IconSelector.updateButtons(currentBind[1]);
    }

    private void updatePage(int dir) {
        currentPage = (currentPage + dir + 5) % 5;
        this.generateButtons(7, 31);
    }

    private void updateSelected(class_1799 icon) {
        int aB = (int)Math.floor((double)activeBind / 8.0);
        if (aB == currentPage) {
            this.buttons.get(activeBind - 8 * aB).setIcon(icon);
        }
    }

    public void generateButtons(int startX, int startY) {
        this.bindsW.removeElementsOfType(ItemButton.class);
        this.buttons.clear();
        int currentX = startX;
        int currentY = startY;
        for (int row = 0; row < 8; ++row) {
            ItemButton[] buttonHolder;
            int bindIndex = row + 8 * currentPage;
            String[] currentBind = BindsConfig.getBind(this.currentPreset, bindIndex);
            buttonHolder = new ItemButton[]{new ItemButton(currentX, currentY, ItemsMapper.getItemStack(currentBind[1]), () -> {
                if (!this.commandField.method_1882().isEmpty()) {
                    this.saveBind();
                }
                for (ItemButton btn : this.buttons) {
                    btn.setSelected(false);
                }
                activeBind = bindIndex;
                buttonHolder[0].setSelected(true);
                this.selectBind();
            }, ITEMS_SELECTOR, "")};
            ItemButton button = buttonHolder[0];
            this.bindsW.addElement((class_364)button);
            this.buttons.add(button);
            currentX += 31;
            if (row != 3) continue;
            currentX = startX;
            currentY = startY + 31;
        }
        int aB = (int)Math.floor((double)activeBind / 8.0);
        if (aB == currentPage) {
            this.buttons.get(activeBind - 8 * aB).setSelected(true);
        }
    }

    static {
        editIconBtnString = "STRUCTURE_VOID";
        copied = new String[]{"", "STRUCTURE_VOID", ""};
    }

    @Environment(value=EnvType.CLIENT)
    public static class TextField
    extends class_342 {
        public TextField(class_327 textRenderer, int x, int y, int width, int height, int length, String text, String placeholder) {
            super(textRenderer, x, y, width, height, class_2561.method_30163((String)text));
            this.method_1880(length);
            this.method_47404(class_2561.method_30163((String)placeholder));
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_48579(context, mouseX, mouseY, delta);
            if (this.method_1882().isEmpty() && !this.method_25370()) {
                this.method_1868(-5592406);
            } else {
                this.method_1868(-1);
            }
        }
    }
}

