/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.gui.panels;

import com.nitsha.binds.ItemsMapper;
import com.nitsha.binds.MainClass;
import com.nitsha.binds.configs.BindEntry;
import com.nitsha.binds.configs.BindsConfig;
import com.nitsha.binds.gui.screen.BindsEditor;
import com.nitsha.binds.gui.utils.AnimatedSprite;
import com.nitsha.binds.gui.utils.GUIUtils;
import com.nitsha.binds.gui.utils.TextUtils;
import com.nitsha.binds.gui.widget.AnimatedWindow;
import com.nitsha.binds.gui.widget.ItemButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class BindsList
extends AnimatedWindow {
    private AnimatedSprite rightBtn;
    private AnimatedSprite leftBtn;
    private class_4264 leftA;
    private class_4264 rightA;
    private class_4264 closeBtn;
    private static final class_2960 FRAME = MainClass.id("textures/gui/test/frame.png");
    private static final class_2960 ARROW_SPRITE = MainClass.id("textures/gui/test/arrow_animation.png");
    private static final class_2960 ARROW_SPRITE_LEFT = MainClass.id("textures/gui/test/arrow_animation_left.png");
    private static final class_2960 ARROW_L = MainClass.idSprite("arrow_left");
    private static final class_2960 ARROW_L_HOVER = MainClass.idSprite("arrow_left_hover");
    private static final class_2960 ARROW_R = MainClass.idSprite("arrow_right");
    private static final class_2960 ARROW_R_HOVER = MainClass.idSprite("arrow_right_hover");
    private static final class_2960 CLOSE = MainClass.idSprite("close");
    private static final class_2960 CLOSE_HOVER = MainClass.idSprite("close_hover");
    private static final class_2960 ITEMS_SELECTOR = MainClass.id("textures/gui/test/items_2.png");
    private final List<ItemButton> buttons = new ArrayList<ItemButton>();
    private final BindsEditor screen;

    public BindsList(BindsEditor screen, float x, int y, float width, int height, class_2960 t1, class_2960 t2, int delay) {
        super(x, y, width, height, t1, t2, delay);
        this.screen = screen;
        this.initUI(screen);
    }

    private void initUI(BindsEditor screen) {
        this.leftA = GUIUtils.createTexturedBtn(-19, 43, 11, 11, new class_2960[]{ARROW_L, ARROW_L_HOVER}, button -> screen.setNewPage(-1));
        this.rightA = GUIUtils.createTexturedBtn(141, 43, 11, 11, new class_2960[]{ARROW_R, ARROW_R_HOVER}, button -> screen.setNewPage(1));
        this.closeBtn = GUIUtils.createTexturedBtn(110, 7, 16, 16, new class_2960[]{CLOSE, CLOSE_HOVER}, button -> {
            screen.closeEditor();
            class_310.method_1551().method_1507((class_437)null);
        });
        this.rightBtn = new AnimatedSprite(22, 15, ARROW_SPRITE, 0, false, 0, 0, 220, 22, 20, 242, 15);
        this.leftBtn = new AnimatedSprite(22, 15, ARROW_SPRITE_LEFT, 0, false, 0, 0, 220, 22, 20, 242, 15);
        this.leftBtn.setPosition(-20, 42);
        this.rightBtn.setPosition(131, 42);
        this.addDrawElement((ctx, mouseX, mouseY) -> {
            class_4587 c = (class_4587)ctx;
            GUIUtils.adaptiveDrawTexture(ctx, FRAME, 4, 4, 0, 0, 125, 90, 125, 90);
            GUIUtils.addText(ctx, (class_2561)TextUtils.translatable("nitsha.binds.configure", new Object[0]), 141, 8, 11);
            GUIUtils.addText(ctx, (class_2561)TextUtils.literal(BindsEditor.getCurrentPage() + 1 + "/5").method_27694(style -> style.method_10977(class_124.field_1080)), 133, 108, 11, "right", "top");
            this.rightBtn.render(c);
            this.leftBtn.render(c);
        });
        this.open(() -> {
            this.rightBtn.startAnimation(true);
            this.leftBtn.startAnimation(true);
            this.addElement(this.leftA);
            this.addElement(this.rightA);
        });
        this.addElement(this.closeBtn);
        this.generateButtons(7, 31);
    }

    public void updateSelected(class_1799 icon) {
        int aB = (int)Math.floor((double)BindsEditor.getActiveBind() / 8.0);
        if (aB == BindsEditor.getCurrentPage()) {
            this.buttons.get(BindsEditor.getActiveBind() - 8 * aB).setIcon(icon);
        }
    }

    public void generateButtons(int startX, int startY) {
        this.buttons.clear();
        this.removeElementsOfType(ItemButton.class);
        int currentX = startX;
        int currentY = startY;
        int currentPage = BindsEditor.getCurrentPage();
        int activeBind = BindsEditor.getActiveBind();
        for (int row = 0; row < 8; ++row) {
            ItemButton[] buttonHolder;
            int bindIndex = row + 8 * currentPage;
            BindEntry currentBind = BindsConfig.getBind(BindsEditor.getCurrentPreset(), bindIndex);
            buttonHolder = new ItemButton[]{new ItemButton(currentX, currentY, ItemsMapper.getItemStack(currentBind.icon), () -> {
                this.screen.saveBind();
                for (ItemButton btn : this.buttons) {
                    btn.setSelected(false);
                }
                BindsEditor.setActiveBind(bindIndex);
                buttonHolder[0].setSelected(true);
                this.screen.selectBind();
            }, ITEMS_SELECTOR, "")};
            ItemButton button = buttonHolder[0];
            this.addElement(button);
            this.buttons.add(button);
            currentX += 31;
            if (row != 3) continue;
            currentX = startX;
            currentY = startY + 31;
        }
        int aB = (int)Math.floor((double)activeBind / 8.0);
        if (aB == currentPage) {
            this.buttons.get(activeBind - 8 * aB).setSelected(true);
        }
    }

    @Override
    public void method_25394(class_4587 ctx, int mouseX, int mouseY, float delta) {
        GUIUtils.matricesUtil(ctx, 0.0f, 0.0f, 2, () -> super.method_25394(ctx, mouseX, mouseY, delta));
    }
}

