/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.gui.widget;

import com.nitsha.binds.MainClass;
import com.nitsha.binds.gui.panels.AdvancedOptions;
import com.nitsha.binds.gui.screen.BindsEditor;
import com.nitsha.binds.gui.utils.GUIUtils;
import com.nitsha.binds.gui.utils.TextUtils;
import com.nitsha.binds.gui.widget.KeybindSelector;
import com.nitsha.binds.utils.FastbindParser;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4264;
import net.minecraft.class_4587;
import net.minecraft.class_6382;

public class ActionItem
extends class_339 {
    private final class_4264 topBtn;
    private final class_4264 bottomBtn;
    private final class_4264 resetBtn;
    private final class_4264 deleteBtn;
    private static final class_2960 TOP = MainClass.idSprite("action_top_normal");
    private static final class_2960 TOP_HOVER = MainClass.idSprite("action_top_hover");
    private static final class_2960 BOTTOM = MainClass.idSprite("action_bottom_normal");
    private static final class_2960 BOTTOM_HOVER = MainClass.idSprite("action_bottom_hover");
    private static final class_2960 RESET = MainClass.idSprite("action_reset_normal");
    private static final class_2960 RESET_HOVER = MainClass.idSprite("action_reset_hover");
    private static final class_2960 DELETE = MainClass.idSprite("action_delete_normal");
    private static final class_2960 DELETE_HOVER = MainClass.idSprite("action_delete_hover");
    private static final class_2960 ARROW_DISABLED = MainClass.id("textures/gui/test/arrow_disabled.png");
    private int type;
    private int index;
    private final BindsEditor.TextField command;
    private final BindsEditor.TextField delay;
    private final KeybindSelector keybind;
    private int x;
    private int y;

    public ActionItem(AdvancedOptions parent, int type, int x, int y, int width, String value, int index) {
        super(x, y, width, 26, class_2561.method_30163((String)""));
        this.index = index;
        this.type = type;
        this.x = x;
        this.y = y;
        this.command = new BindsEditor.TextField(class_310.method_1551().field_1772, x, y + 3, width - 26, 19, Integer.MAX_VALUE, value, TextUtils.translatable("nitsha.binds.advances.actions.commandLine", new Object[0]).getString());
        this.delay = new BindsEditor.TextField(class_310.method_1551().field_1772, x + 90, y + 3, width - 116, 19, 6, value, TextUtils.translatable("nitsha.binds.advances.actions.delayLine", new Object[0]).getString(), true);
        this.keybind = new KeybindSelector(x + width - 26 - 68, y + 3, 68, 19);
        if (this.type == 3) {
            this.keybind.setKeyCode(Integer.parseInt(value));
        }
        this.topBtn = GUIUtils.createTexturedBtn(x + width - 9, y + 3, 9, 9, new class_2960[]{TOP, TOP_HOVER}, button -> {
            if (index > 0) {
                parent.moveAction(index, -1);
            }
        });
        this.bottomBtn = GUIUtils.createTexturedBtn(x + width - 9, y + 13, 9, 9, new class_2960[]{BOTTOM, BOTTOM_HOVER}, button -> {
            if (BindsEditor.getCBind().actions.size() != index + 1) {
                parent.moveAction(index, 1);
            }
        });
        this.resetBtn = GUIUtils.createTexturedBtn(x + width - 25, y + 3, 15, 9, new class_2960[]{RESET, RESET_HOVER}, button -> {
            switch (this.type) {
                case 1: {
                    this.command.method_1852("");
                    break;
                }
                case 2: {
                    this.delay.method_1852("100");
                    break;
                }
                case 3: {
                    this.keybind.setKeyCode(0);
                    this.keybind.setPressed(false);
                }
            }
        });
        this.deleteBtn = GUIUtils.createTexturedBtn(x + width - 25, y + 13, 15, 9, new class_2960[]{DELETE, DELETE_HOVER}, button -> parent.removeAction(index));
    }

    public int method_46426() {
        return this.x;
    }

    public int method_46427() {
        return this.y;
    }

    public String getValue() {
        String val = switch (this.type) {
            case 1 -> this.command.method_1882();
            case 2 -> this.delay.method_1882();
            case 3 -> String.valueOf(this.keybind.getKeyCode());
            default -> "";
        };
        return FastbindParser.toAction(this.type, val);
    }

    public void method_25359(class_4587 context, int mouseX, int mouseY, float delta) {
        this.rndr(context, mouseX, mouseY, delta);
    }

    private void rndr(Object ctx, int mouseX, int mouseY, float delta) {
        class_4587 c = (class_4587)ctx;
        int lineColor = -1;
        GUIUtils.drawFill(c, this.method_46426(), this.method_46427() + this.method_25364() - 1, this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), 0x33FFFFFF);
        this.resetBtn.method_25394(c, mouseX, mouseY, delta);
        this.deleteBtn.method_25394(c, mouseX, mouseY, delta);
        GUIUtils.adaptiveDrawTexture(ctx, ARROW_DISABLED, this.method_46426() + this.method_25368() - 9, this.method_46427() + 3, 0, 0, 9, 19, 9, 19);
        int aS = BindsEditor.getCBind().actions.size();
        if (aS > 0) {
            if (this.index > 0) {
                this.topBtn.method_25394(c, mouseX, mouseY, delta);
            }
            if (this.index != aS - 1) {
                this.bottomBtn.method_25394(c, mouseX, mouseY, delta);
            }
        }
        switch (this.type) {
            case 1: {
                lineColor = -3567086;
                this.command.method_25394(c, mouseX, mouseY, delta);
                break;
            }
            case 2: {
                lineColor = -11631099;
                this.delay.method_25394(c, mouseX, mouseY, delta);
                GUIUtils.addText(c, (class_2561)TextUtils.translatable("nitsha.binds.advances.actions.delayDes\u0441", new Object[0]), 0, this.method_46426() + 2, this.method_46427() + 8, "top", "left", -14606047, false);
                break;
            }
            case 3: {
                lineColor = -8843770;
                this.keybind.method_25394(c, mouseX, mouseY, delta);
                GUIUtils.addText(c, (class_2561)TextUtils.translatable("nitsha.binds.advances.actions.pressKey", new Object[0]), 0, this.method_46426() + 2, this.method_46427() + 8, "top", "left", -14606047, false);
            }
        }
        GUIUtils.drawFill(ctx, this.method_46426() - 3, this.method_46427() + 8, this.method_46426() - 1, this.method_46427() + this.method_25364() - 8, lineColor);
    }

    public void method_25354(class_1144 soundManager) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean clicked = false;
        switch (this.type) {
            case 1: {
                if (!this.command.method_25402(mouseX, mouseY, button)) break;
                clicked = true;
                break;
            }
            case 2: {
                if (!this.delay.method_25402(mouseX, mouseY, button)) break;
                clicked = true;
                break;
            }
            case 3: {
                if (!this.keybind.method_25402(mouseX, mouseY, button)) break;
                clicked = true;
            }
        }
        if (this.deleteBtn.method_25402(mouseX, mouseY, button) || this.bottomBtn.method_25402(mouseX, mouseY, button) || this.resetBtn.method_25402(mouseX, mouseY, button) || this.topBtn.method_25402(mouseX, mouseY, button)) {
            clicked = true;
        }
        return clicked;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        switch (this.type) {
            case 1: {
                if (!this.command.method_25404(keyCode, scanCode, modifiers)) break;
                return true;
            }
            case 2: {
                if (!this.delay.method_25404(keyCode, scanCode, modifiers)) break;
                return true;
            }
            case 3: {
                if (!this.keybind.method_25404(keyCode, scanCode, modifiers)) break;
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        switch (this.type) {
            case 1: {
                if (!this.command.method_25400(codePoint, modifiers)) break;
                return true;
            }
            case 2: {
                if (!this.delay.method_25400(codePoint, modifiers)) break;
                return true;
            }
            case 3: {
                if (!this.keybind.method_25400(codePoint, modifiers)) break;
                return true;
            }
        }
        return super.method_25400(codePoint, modifiers);
    }

    protected void method_47399(class_6382 builder) {
    }
}

