/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.gui.widget;

import com.nitsha.binds.MainClass;
import com.nitsha.binds.configs.BindsConfig;
import com.nitsha.binds.gui.panels.PresetSelector;
import com.nitsha.binds.gui.screen.BindsEditor;
import com.nitsha.binds.gui.utils.GUIUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4264;
import net.minecraft.class_6382;

public class PresetListItem
extends class_339 {
    private final PresetSelector parent;
    private final BindsEditor.TextField newNameField;
    private final class_4264 editBtn;
    private final class_4264 saveBtn;
    private static final class_2960 EDIT = MainClass.idSprite("editpreset_normal");
    private static final class_2960 EDIT_HOVER = MainClass.idSprite("editpreset_hover");
    private static final class_2960 SAVE = MainClass.idSprite("savepreset_normal");
    private static final class_2960 SAVE_HOVER = MainClass.idSprite("savepreset_hover");
    private boolean isEditing = false;
    private String name;
    private int index;
    private int x;
    private int y;

    public PresetListItem(PresetSelector parent, String name, int x, int y, int width, int height, int index) {
        super(x, y, width, height, class_2561.method_30163((String)""));
        this.parent = parent;
        this.name = name;
        this.index = index;
        this.x = x;
        this.y = y;
        this.newNameField = new BindsEditor.TextField(class_310.method_1551().field_1772, x + 3, y + 3, width - 20, height - 5, 40, name, "Preset name");
        this.newNameField.setEnterEvent(this::savePreset);
        this.newNameField.setEscapeEvent(this::stopEditing);
        this.editBtn = GUIUtils.createTexturedBtn(x + 111, y + 6, 9, 9, new class_2960[]{EDIT, EDIT_HOVER}, button -> {
            for (PresetListItem item : parent.getItems()) {
                if (!item.isEditing()) continue;
                item.stopEditing();
            }
            this.isEditing = true;
            this.newNameField.method_25365(true);
            BindsEditor.TextField.setFocusedField(this.newNameField);
        });
        this.saveBtn = GUIUtils.createTexturedBtn(x + 111, y + 6, 9, 9, new class_2960[]{SAVE, SAVE_HOVER}, button -> this.savePreset());
    }

    public int method_46426() {
        return this.x;
    }

    public int method_46427() {
        return this.y;
    }

    public void stopEditing() {
        this.isEditing = false;
        this.newNameField.method_1852(this.name);
    }

    public void method_25348(double mouseX, double mouseY) {
        if (!this.isEditing) {
            this.parent.screen.selectPreset(this.index);
            this.parent.openSelector(false);
        }
    }

    public boolean isEditing() {
        return this.isEditing;
    }

    public void savePreset() {
        this.isEditing = false;
        String getName = this.newNameField.method_1882();
        String newName = getName.isEmpty() ? "Preset " + (this.index + 1) : getName;
        BindsConfig.setNewPresetName(this.index, newName);
        this.newNameField.method_1852(newName);
        this.name = newName;
    }

    private void rndr(Object ctx, int mouseX, int mouseY, float delta) {
        class_332 c = (class_332)ctx;
        GUIUtils.drawFill(ctx, this.method_46426() + 3, this.method_46427(), this.method_46426() + this.method_25368() - 6, this.method_46427() + 1, -11184811);
        if (this.isEditing) {
            this.newNameField.method_25394(c, mouseX, mouseY, delta);
            this.saveBtn.method_25394(c, mouseX, mouseY, delta);
        } else {
            if (this.field_22762 && this.parent.isOpen()) {
                GUIUtils.drawFill(c, this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), 0xDFFFFFF);
            }
            GUIUtils.addText(c, class_2561.method_30163((String)GUIUtils.truncateString(this.name, 15)), 0, this.method_46426() + 3, this.method_46427() + 7, "left", "top", -1, false);
            this.editBtn.method_25394(c, mouseX, mouseY, delta);
        }
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        this.rndr(context, mouseX, mouseY, delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.parent.isOpen()) {
            return false;
        }
        if (this.isEditing) {
            if (this.newNameField.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            if (this.saveBtn.method_25402(mouseX, mouseY, button)) {
                return true;
            }
        } else if (this.editBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.parent.isOpen() || !this.isEditing) {
            return false;
        }
        return this.newNameField.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (!this.parent.isOpen() || !this.isEditing) {
            return false;
        }
        return this.newNameField.method_25400(codePoint, modifiers);
    }

    protected void method_47399(class_6382 builder) {
    }
}

