/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.gui.widget;

import com.nitsha.binds.gui.GUIUtils;
import com.nitsha.binds.gui.extend.PositionedDrawElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

public class AnimatedWindow
extends class_362
implements class_4068,
class_364,
class_6379 {
    private class_2960 T_1;
    private class_2960 T_2;
    private final List<class_364> children = new ArrayList<class_364>();
    private final List<PositionedDrawElement> drawElements = new ArrayList<PositionedDrawElement>();
    private int height;
    private int y;
    private int delay = 0;
    private float x;
    private float width;
    private float targetX = 0.0f;
    private float targetWidth = 0.0f;
    private boolean visible = false;
    private AnimationState animState;
    private final float speed = 0.6f;
    private float baseYOffset;
    private float topYOffset;
    private float alpha = 0.0f;
    private Runnable onFinish = null;

    public AnimatedWindow(float width, int height, float x, int y, class_2960 t1, class_2960 t2, int delay) {
        this.x = this.targetX = x;
        this.width = this.targetWidth = width;
        this.y = y;
        this.height = height;
        this.T_1 = t1;
        this.T_2 = t2;
        this.delay = delay;
        this.animState = AnimationState.HIDDEN;
        this.baseYOffset = y - 100;
        this.topYOffset = 0.0f;
        this.alpha = 0.0f;
    }

    public void addElement(class_364 element) {
        this.children.add(element);
    }

    public void addDrawElement(Consumer<class_332> drawElement) {
        this.drawElements.add(new PositionedDrawElement(0, 0, ctx -> drawElement.accept((class_332)ctx)));
    }

    public int getX() {
        return Math.round(this.x);
    }

    public int getY() {
        return this.y;
    }

    public void updateWidth(float delta) {
        this.targetWidth = this.width + delta;
        this.updateX(delta / 2.0f);
    }

    public void updateX(float delta) {
        this.targetX = this.x - delta;
    }

    public void open(Runnable onFinish) {
        if (this.visible) {
            return;
        }
        this.visible = true;
        this.onFinish = onFinish;
        this.animState = AnimationState.DROPPING_ALL;
    }

    public void close(Runnable onFinish) {
        if (!this.visible) {
            return;
        }
        this.animState = AnimationState.HIDING_TOP;
        this.onFinish = onFinish;
    }

    private void drawAnimatedBox(class_332 ctx, float delta) {
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        switch (this.animState.ordinal()) {
            case 0: {
                this.alpha = class_3532.method_16439((float)this.clampSpeed(0.6f * delta), (float)this.alpha, (float)1.0f);
                if (Math.abs(this.alpha - 1.0f) < 0.001f) {
                    this.alpha = 1.0f;
                }
                this.baseYOffset = class_3532.method_16439((float)this.clampSpeed(0.6f * delta), (float)this.baseYOffset, (float)(this.y + 2));
                if (!(Math.abs(this.baseYOffset - (float)(this.y + 2)) < 0.001f)) break;
                this.baseYOffset = this.y + 2;
                this.animState = AnimationState.LIFTING_TOP;
                if (this.onFinish == null) break;
                this.onFinish.run();
                this.onFinish = null;
                break;
            }
            case 1: {
                this.topYOffset = class_3532.method_16439((float)this.clampSpeed(0.6f * delta), (float)this.topYOffset, (float)2.0f);
                if (!(Math.abs(this.topYOffset - 2.0f) < 0.001f)) break;
                this.topYOffset = 2.0f;
                this.animState = AnimationState.FINISHED;
                break;
            }
            case 3: {
                this.alpha = class_3532.method_16439((float)this.clampSpeed(0.6f * delta), (float)this.alpha, (float)0.0f);
                this.baseYOffset = class_3532.method_16439((float)this.clampSpeed(0.6f * delta), (float)this.baseYOffset, (float)(this.y - 100));
                if (this.onFinish != null && this.baseYOffset < (float)(this.y - 49)) {
                    this.visible = false;
                    this.onFinish.run();
                    this.onFinish = null;
                }
                if (!(Math.abs(this.baseYOffset - (float)(this.y - 100)) < 0.001f)) break;
                this.baseYOffset = this.y - 100;
                this.alpha = 0.0f;
                this.animState = AnimationState.LIFTING_ALL;
                break;
            }
            case 4: {
                this.topYOffset = class_3532.method_16439((float)this.clampSpeed(0.6f * delta), (float)this.topYOffset, (float)0.0f);
                if (!(Math.abs(this.topYOffset) < 0.001f)) break;
                this.topYOffset = 0.0f;
                this.animState = AnimationState.HIDDEN;
                break;
            }
        }
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        int alphaByte = (int)(this.alpha * 255.0f) & 0xFF;
        int color = alphaByte << 24 | 0xFFFFFF;
        int boxY = Math.round(this.baseYOffset);
        int topY = boxY - Math.round(this.topYOffset);
        GUIUtils.drawResizableBox(ctx, this.T_1, Math.round(this.x), boxY, Math.round(this.width), this.height - 2, 7, 15, color);
        GUIUtils.drawResizableBox(ctx, this.T_2, Math.round(this.x), topY, Math.round(this.width), this.height - 2, 7, 15, color);
        int yO = Math.round(this.baseYOffset) - Math.round(this.topYOffset);
        Matrix3x2fStack matrices = ctx.method_51448();
        Matrix3x2f saved = new Matrix3x2f((Matrix3x2fc)matrices);
        matrices.translate(this.x, (float)yO);
        if (this.delay == 0 && this.visible) {
            for (PositionedDrawElement element : this.drawElements) {
                element.render(ctx);
            }
            for (class_364 child : this.children) {
                if (!(child instanceof class_4068)) continue;
                class_4068 drawable = (class_4068)child;
                drawable.method_25394(ctx, mouseX - Math.round(this.x), mouseY - yO, delta);
            }
        }
        matrices.set((Matrix3x2fc)saved);
        this.drawAnimatedBox(ctx, delta);
        this.width = class_3532.method_16439((float)this.clampSpeed(0.6f * delta), (float)this.width, (float)this.targetWidth);
        if (Math.abs(this.width - this.targetWidth) < 0.1f) {
            this.width = this.targetWidth;
        }
        this.x = class_3532.method_16439((float)this.clampSpeed(0.6f * delta), (float)this.x, (float)this.targetX);
        if (Math.abs(this.x - this.targetX) < 0.1f) {
            this.x = this.targetX;
        }
    }

    public void method_37020(class_6382 builder) {
    }

    public List<? extends class_364> method_25396() {
        return this.children;
    }

    public void removeElementsOfType(Class<?> type) {
        this.children.removeIf(type::isInstance);
    }

    public List<PositionedDrawElement> drawChildren() {
        return this.drawElements;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    private float clampSpeed(float value) {
        return class_3532.method_15363((float)value, (float)0.001f, (float)1.0f);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        float offsetX = this.x;
        float offsetY = Math.round(this.baseYOffset) - Math.round(this.topYOffset);
        double adjustedX = mouseX - (double)offsetX;
        double adjustedY = mouseY - (double)offsetY;
        boolean clickedAny = false;
        for (class_364 class_3642 : this.method_25396()) {
            if (!class_3642.method_25402(adjustedX, adjustedY, button)) continue;
            clickedAny = true;
            if (class_3642 instanceof class_342) {
                class_342 field = (class_342)class_3642;
                this.method_25395((class_364)field);
            } else {
                this.method_25395(null);
            }
            return true;
        }
        if (!clickedAny) {
            this.method_25395(null);
        }
        return super.method_25402(adjustedX, adjustedY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        double adjustedX = mouseX - (double)this.x;
        double adjustedY = mouseY - (double)(Math.round(this.baseYOffset) - Math.round(this.topYOffset));
        boolean released = false;
        for (class_364 child : this.children) {
            if (!child.method_25406(adjustedX, adjustedY, button)) continue;
            released = true;
        }
        return released;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.visible) {
            return false;
        }
        double adjustedX = mouseX - (double)this.x;
        double adjustedY = mouseY - (double)(Math.round(this.baseYOffset) - Math.round(this.topYOffset));
        for (class_364 child : this.children) {
            if (!child.method_25403(adjustedX, adjustedY, button, deltaX, deltaY)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (class_364 child : this.children) {
            if (!child.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25400(char codePoint, int modifiers) {
        for (class_364 child : this.children) {
            if (!child.method_25400(codePoint, modifiers)) continue;
            return true;
        }
        return false;
    }

    private static enum AnimationState {
        DROPPING_ALL,
        LIFTING_TOP,
        FINISHED,
        HIDING_TOP,
        LIFTING_ALL,
        HIDDEN;

    }
}

