/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.gui.screen;

import com.nitsha.binds.ItemsMapper;
import com.nitsha.binds.MainClass;
import com.nitsha.binds.configs.BindEntry;
import com.nitsha.binds.configs.BindsConfig;
import com.nitsha.binds.configs.KeyBinds;
import com.nitsha.binds.gui.panels.AdvancedOptions;
import com.nitsha.binds.gui.panels.BasicOptionsWindow;
import com.nitsha.binds.gui.panels.BindsList;
import com.nitsha.binds.gui.panels.PresetSelector;
import com.nitsha.binds.gui.screen.BindsGUI;
import com.nitsha.binds.gui.utils.TextUtils;
import com.nitsha.binds.gui.widget.KeybindSelector;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;

public class BindsEditor
extends class_437 {
    private static final class_2960 BACKGROUND = MainClass.id("textures/gui/test/editor_bg.png");
    private static final class_2960 BACKGROUND_FLAT = MainClass.id("textures/gui/test/editor_bg_flat.png");
    private static final class_2960 BACKGROUND_DARK = MainClass.id("textures/gui/test/editor_bg_dark.png");
    private static final class_2960 BACKGROUND_DARK_FLAT = MainClass.id("textures/gui/test/editor_bg_dark_flat.png");
    private final int TEXTURE_WIDTH = 141;
    private final int TEXTURE_HEIGHT = 190;
    private int centerX;
    private int centerY;
    private boolean selectorOpening = false;
    public static boolean isSelectorOpened = false;
    private static int currentPage = 0;
    private static int activeBind = 0;
    public static String editIconBtnString = "STRUCTURE_VOID";
    public BindEntry copied = new BindEntry("", "STRUCTURE_VOID", 0, new ArrayList<String>());
    private BasicOptionsWindow window_BasicOptions;
    private BindsList window_BindsList;
    private AdvancedOptions window_AdvancedOptions;
    private PresetSelector window_PresetSelector;
    private final int coeff = 200;
    public static int currentPreset = BindsGUI.getCurrentPreset();
    private final class_437 parent;

    public BindsEditor(class_437 parent) {
        super(class_333.field_18967);
        this.parent = parent;
        currentPage = 0;
        activeBind = 0;
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        this.centerX = this.field_22789 / 2 - 70;
        this.centerY = (this.field_22790 - 190) / 2;
        this.selectorOpening = false;
        isSelectorOpened = false;
        this.window_BasicOptions = new BasicOptionsWindow(this, this.centerX, this.centerY, 141.0f, 190, BACKGROUND, BACKGROUND_FLAT, 0);
        this.method_37063(this.window_BasicOptions);
        this.window_BindsList = new BindsList(this, this.centerX + 4, this.centerY - 1, 133.0f, 100, BACKGROUND_DARK, BACKGROUND_DARK_FLAT, 140);
        this.method_37063(this.window_BindsList);
        this.window_PresetSelector = new PresetSelector(this, this.centerX + 7, this.centerY - 24, 127.0f, 19, BACKGROUND_DARK, BACKGROUND_DARK_FLAT, 250);
        this.method_37063(this.window_PresetSelector);
        this.window_AdvancedOptions = new AdvancedOptions(this, this.centerX + 61, this.centerY, 180, 190, BACKGROUND, BACKGROUND_FLAT, 0);
        this.method_37063(this.window_AdvancedOptions);
        this.selectBind();
    }

    public BasicOptionsWindow getBasicOptionsWindow() {
        return this.window_BasicOptions;
    }

    public BindsList getBindsListWindow() {
        return this.window_BindsList;
    }

    public AdvancedOptions getAdvancedOptionsWindow() {
        return this.window_AdvancedOptions;
    }

    public PresetSelector getPresetSelectorWindow() {
        return this.window_PresetSelector;
    }

    public static String getPresetName() {
        List presets = (List)BindsConfig.configs.get("presets");
        return (String)presets.get(currentPreset);
    }

    public static int getCurrentPage() {
        return currentPage;
    }

    public static int getActiveBind() {
        return activeBind;
    }

    public static void setActiveBind(int aB) {
        activeBind = aB;
    }

    public void setNewPage(int dir) {
        currentPage = (currentPage + dir + 5) % 5;
        this.window_BindsList.generateButtons(7, 31);
    }

    public void setNewPreset(int dir) {
        this.selectPreset((currentPreset + dir + 9) % 9);
    }

    public void selectPreset(int i) {
        currentPreset = i;
        currentPage = 0;
        BindsEditor.setActiveBind(0);
        this.window_BindsList.generateButtons(7, 31);
        this.selectBind();
    }

    public static BindEntry getCBind() {
        return BindsConfig.getBind(BindsEditor.getCurrentPreset(), BindsEditor.getActiveBind());
    }

    public void openAdvancedOptions() {
        if (this.selectorOpening) {
            return;
        }
        this.selectorOpening = true;
        int xDelta = 100;
        int xDeltaN = -100;
        if (!isSelectorOpened) {
            this.window_BasicOptions.updateX(xDelta);
            this.window_BindsList.updateX(xDelta);
            this.window_PresetSelector.updateX(xDelta);
            this.window_AdvancedOptions.open(() -> {
                isSelectorOpened = true;
                this.selectorOpening = false;
            });
        } else {
            this.window_AdvancedOptions.close(() -> {
                this.window_BasicOptions.updateX(xDeltaN);
                this.window_BindsList.updateX(xDeltaN);
                this.window_PresetSelector.updateX(xDeltaN);
                isSelectorOpened = false;
                this.selectorOpening = false;
            });
        }
        this.window_BindsList.updateSelected(ItemsMapper.getItemStack(BindsEditor.getCBind().icon));
    }

    public static int getCurrentPreset() {
        return currentPreset;
    }

    public void saveBind() {
        if (!BindsEditor.getCBind().actions.isEmpty()) {
            String bindName;
            String string = bindName = this.window_BasicOptions.getBindName().method_1882().isEmpty() ? TextUtils.translatable("nitsha.binds.untitled", new Object[0]).getString() : this.window_BasicOptions.getBindName().method_1882();
            if (editIconBtnString.equals("STRUCTURE_VOID")) {
                editIconBtnString = "GRASS";
            }
            int keyCode = this.window_AdvancedOptions.keybind.getKeyCode();
            BindsConfig.setBind(BindsEditor.getCurrentPreset(), BindsEditor.getActiveBind(), new BindEntry(bindName, editIconBtnString, keyCode, this.window_AdvancedOptions.getAllActions()));
            BindsConfig.setBindKeyBind(BindsEditor.getCurrentPreset(), BindsEditor.getActiveBind(), keyCode);
            this.selectBind();
            this.window_BindsList.updateSelected(ItemsMapper.getItemStack(BindsEditor.getCBind().icon));
        } else {
            this.deleteBind();
        }
    }

    public void deleteBind() {
        BindsConfig.setBind(BindsEditor.getCurrentPreset(), BindsEditor.getActiveBind(), new BindEntry("", "STRUCTURE_VOID", 0, new ArrayList<String>()));
        this.selectBind();
        this.window_BindsList.updateSelected(new class_1799((class_1935)class_1802.field_8615));
    }

    public void copyBind() {
        BindEntry currentBind = BindsEditor.getCBind();
        if (!currentBind.name.isEmpty()) {
            this.copied = currentBind;
            this.copied.name = currentBind.name;
            this.copied.icon = currentBind.icon;
            this.copied.keyCode = currentBind.keyCode;
            this.copied.actions = currentBind.actions;
            this.window_BasicOptions.getPasteIcon().setEnabled(true);
        }
    }

    public void pasteBind() {
        BindsConfig.setBind(currentPreset, activeBind, this.copied);
        this.selectBind();
        this.window_BindsList.updateSelected(ItemsMapper.getItemStack(BindsEditor.getCBind().icon));
    }

    public void selectBind() {
        BindEntry currentBind = BindsEditor.getCBind();
        this.window_BasicOptions.getBindName().method_1852(currentBind.name);
        this.window_BasicOptions.getEditIcon().setIcon(ItemsMapper.getItemStack(currentBind.icon));
        editIconBtnString = currentBind.icon;
        this.window_AdvancedOptions.keybind.setKeyCode(currentBind.keyCode);
        this.window_AdvancedOptions.generateActionList(currentBind.actions);
        this.window_AdvancedOptions.getFirstTab().updateButtons(currentBind.icon);
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.method_25420(ctx, mouseX, mouseY, delta);
        for (class_364 element : this.method_25396()) {
            if (!(element instanceof class_4068)) continue;
            class_4068 dr = (class_4068)element;
            if (element instanceof PresetSelector) {
                PresetSelector pS = (PresetSelector)element;
                pS.method_25394(ctx, mouseX, mouseY, delta);
                continue;
            }
            if (this.window_PresetSelector.isMouseInside(mouseX, mouseY) && this.window_PresetSelector.isOpen()) {
                dr.method_25394(ctx, -10000, -10000, delta);
                continue;
            }
            dr.method_25394(ctx, mouseX, mouseY, delta);
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.field_22787.field_1687 == null) {
            this.method_57728(context, delta);
            this.method_57734(delta);
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25422() {
        return true;
    }

    public boolean method_25421() {
        return false;
    }

    public void closeEditor() {
        TextField.setFocusedField(null);
        KeybindSelector.setFocusedField(null);
        this.saveBind();
        this.window_PresetSelector.saveAll();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.window_PresetSelector.isMouseInside(mouseX, mouseY)) {
            this.window_PresetSelector.method_25402(mouseX, mouseY, button);
            return true;
        }
        boolean clicked = false;
        if (KeybindSelector.getFocusedField() != null) {
            KeybindSelector.getFocusedField().controlFocus(mouseX, mouseY);
        }
        if (TextField.getFocusedField() != null) {
            TextField.getFocusedField().controlFocus(mouseX, mouseY);
        }
        for (class_364 element : this.method_25396()) {
            if (element == this.window_PresetSelector || !element.method_25402(mouseX, mouseY, button)) continue;
            clicked = true;
        }
        return clicked;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        boolean released = false;
        for (class_364 child : this.method_25396()) {
            if (!child.method_25406(mouseX, mouseY, button)) continue;
            released = true;
        }
        return released;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        boolean dragged = false;
        for (class_364 child : this.method_25396()) {
            if (!child.method_25403(mouseX, mouseY, button, deltaX, deltaY)) continue;
            dragged = true;
        }
        return dragged;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        for (class_364 element : this.method_25396()) {
            if (!element.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) continue;
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        for (class_364 element : this.method_25396()) {
            if (!element.method_25400(codePoint, modifiers)) continue;
            return true;
        }
        return super.method_25400(codePoint, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        TextField focusedField = TextField.getFocusedField();
        KeybindSelector focusedKeybind = KeybindSelector.getFocusedField();
        if (focusedField != null) {
            if (focusedField.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (keyCode == 256) {
                if (focusedField.escapeEvent != null) {
                    focusedField.escapeEvent.run();
                }
                TextField.setFocusedField(null);
                return true;
            }
            if (keyCode == 257) {
                if (focusedField.enterEvent != null) {
                    focusedField.enterEvent.run();
                }
                TextField.setFocusedField(null);
                return true;
            }
            return true;
        }
        if (focusedKeybind != null) {
            if (focusedKeybind.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (keyCode == 256) {
                KeybindSelector.setFocusedField(null);
                return true;
            }
        }
        if (keyCode == 256) {
            this.closeEditor();
        }
        if (keyCode == KeyBindingHelper.getBoundKeyOf((class_304)KeyBinds.PREV_PAGE).method_1444()) {
            this.setNewPage(-1);
            return true;
        }
        if (keyCode == KeyBindingHelper.getBoundKeyOf((class_304)KeyBinds.NEXT_PAGE).method_1444()) {
            this.setNewPage(1);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Environment(value=EnvType.CLIENT)
    public static class TextField
    extends class_342 {
        private static TextField focusedField = null;
        private final boolean isNumerical;
        private Runnable escapeEvent;
        private Runnable enterEvent;
        private String placeholderText;
        private int x;
        private int y;

        public TextField(class_327 textRenderer, int x, int y, int width, int height, int length, String text, String placeholder, boolean isNumerical) {
            super(textRenderer, x, y, width, height, class_2561.method_30163((String)text));
            this.method_1880(length);
            this.method_1852(text);
            this.method_47404(class_2561.method_30163((String)placeholder));
            this.method_1868(this.method_1882().isEmpty() ? -5592406 : -1);
            this.isNumerical = isNumerical;
            this.placeholderText = placeholder;
            this.x = x;
            this.y = y;
        }

        public TextField(class_327 textRenderer, int x, int y, int width, int height, int length, String text, String placeholder) {
            this(textRenderer, x, y, width, height, length, text, placeholder, false);
        }

        public void setEscapeEvent(Runnable event) {
            this.escapeEvent = event;
        }

        public void setEnterEvent(Runnable event) {
            this.enterEvent = event;
        }

        public static TextField getFocusedField() {
            return focusedField;
        }

        public static void setFocusedField(TextField ff) {
            if (focusedField != null) {
                focusedField.method_25365(false);
            }
            focusedField = ff;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            this.controlFocus(mouseX, mouseY);
            return super.method_25402(mouseX, mouseY, button);
        }

        public void controlFocus(double mouseX, double mouseY) {
            if (this.method_25405(mouseX, mouseY)) {
                TextField.setFocusedField(this);
                this.method_25365(true);
            } else {
                TextField.setFocusedField(null);
            }
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_25400(char chr, int modifiers) {
            if (this.isNumerical) {
                if (chr >= '0' && chr <= '9') {
                    return super.method_25400(chr, modifiers);
                }
                return false;
            }
            return super.method_25400(chr, modifiers);
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_48579(context, mouseX, mouseY, delta);
            if (this.method_1882().isEmpty() && !this.method_25370()) {
                this.method_1868(-5592406);
            } else {
                this.method_1868(-1);
            }
        }
    }
}

