/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.gui.panels;

import com.nitsha.binds.MainClass;
import com.nitsha.binds.configs.BindsConfig;
import com.nitsha.binds.configs.KeyBinds;
import com.nitsha.binds.gui.panels.IconSelector;
import com.nitsha.binds.gui.screen.BindsEditor;
import com.nitsha.binds.gui.utils.GUIUtils;
import com.nitsha.binds.gui.utils.TextUtils;
import com.nitsha.binds.gui.widget.ActionItem;
import com.nitsha.binds.gui.widget.AnimatedWindow;
import com.nitsha.binds.gui.widget.KeybindSelector;
import com.nitsha.binds.gui.widget.ScrollableWindow;
import com.nitsha.binds.gui.widget.SmallTextButton;
import com.nitsha.binds.gui.widget.TabButton;
import com.nitsha.binds.gui.widget.ToggleButton;
import com.nitsha.binds.utils.FastbindParser;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;

public class AdvancedOptions
extends AnimatedWindow {
    private static final class_2960 RANDOM = MainClass.idSprite("random");
    private static final class_2960 RANDOM_HOVER = MainClass.idSprite("random_hover");
    private static final class_2960 RESET = MainClass.idSprite("keybind_reset_normal");
    private static final class_2960 RESET_HOVER = MainClass.idSprite("keybind_reset_hover");
    private static final class_2960 TAB2_BG = MainClass.id("textures/gui/test/scroller.png");
    private final List<TabButton> tabsBtn = new ArrayList<TabButton>();
    private int currentTab = 0;
    private IconSelector firstTab;
    private ScrollableWindow secondTab;
    public KeybindSelector keybind;
    private ScrollableWindow thirdTab;
    private final BindsEditor screen;
    private int actionIndex = 0;
    private int actionY = 0;

    public AdvancedOptions(BindsEditor screen, int x, int y, int width, int height, class_2960 t1, class_2960 t2, int delay) {
        super(x, y + 16, width, height - 16, t1, t2, delay);
        this.tabsBtn.clear();
        this.screen = screen;
        TabButton tab1 = new TabButton(4, -16, true, (class_2561)TextUtils.translatable("nitsha.binds.advances.tab1", new Object[0]), b -> this.selectTab(0));
        TabButton tab2 = new TabButton(tab1.method_46426() + tab1.method_25368() + 2, -16, false, (class_2561)TextUtils.translatable("nitsha.binds.advances.tab2", new Object[0]), b -> this.selectTab(1));
        TabButton tab3 = new TabButton(tab2.method_46426() + tab2.method_25368() + 2, -16, false, (class_2561)TextUtils.translatable("nitsha.binds.advances.tab3", new Object[0]), b -> this.selectTab(2));
        this.tabsBtn.add(tab1);
        this.tabsBtn.add(tab2);
        this.tabsBtn.add(tab3);
        this.firstTab = new IconSelector(screen, 4, 20, 162, 126);
        this.secondTab = new ScrollableWindow(5, 21, this.getX(), this.getY(), this.getWidth() - 10, this.getHeight() - 50, false);
        this.keybind = new KeybindSelector(this.getWidth() - 84, this.getHeight() - 26, 80, 20);
        this.thirdTab = new ScrollableWindow(2, 4, this.getX(), this.getY(), this.getWidth() - 4, this.getHeight() - 11, false);
    }

    public void selectTab(int i) {
        this.tabsBtn.forEach(tab -> tab.setSelected(false));
        this.tabsBtn.get(i).setSelected(true);
        this.currentTab = i;
        this.clearChildren();
        switch (this.currentTab) {
            case 0: {
                this.fillFirstTab();
                break;
            }
            case 1: {
                this.fillSecondTab();
                break;
            }
            case 2: {
                this.fillThirdTab();
            }
        }
    }

    private void fillFirstTab() {
        this.addDrawElement((ctx, mouseX, mouseY) -> GUIUtils.addText(ctx, (class_2561)TextUtils.translatable("nitsha.binds.advances.choose_icon", new Object[0]), 0, 5, 6, "top", "left", -14606047, false));
        this.addElement(GUIUtils.createTexturedBtn(this.getWidth() - 53, 6, 49, 9, new class_2960[]{RANDOM, RANDOM_HOVER}, button -> this.firstTab.pickRandom()));
        this.addElement(this.firstTab);
    }

    private void fillSecondTab() {
        this.secondTab.clearChildren();
        this.addDrawElement((ctx, mouseX, mouseY) -> {
            GUIUtils.addText(ctx, (class_2561)TextUtils.translatable("nitsha.binds.advances.actions", new Object[0]), 0, 5, 6, "top", "left", -14606047, false);
            GUIUtils.addText(ctx, (class_2561)TextUtils.translatable("nitsha.binds.advances.actions.keybind", new Object[0]), 0, 5, this.getHeight() - 20, "top", "left", -14606047, false);
            GUIUtils.drawResizableBox(ctx, TAB2_BG, 4, 20, this.getWidth() - 8, this.getHeight() - 48, 1, 3);
        });
        this.addElement(GUIUtils.createTexturedBtn(this.getWidth() - 106, this.getHeight() - 26, 20, 20, new class_2960[]{RESET, RESET_HOVER}, button -> {
            this.keybind.setKeyCode(0);
            this.keybind.setPressed(false);
        }));
        this.addElement(this.keybind);
        this.addElement(this.secondTab);
        this.generateActionList(BindsEditor.getCBind().actions);
    }

    private void fillThirdTab() {
        this.thirdTab.clearChildren();
        boolean[] options = new boolean[]{BindsConfig.getBooleanConfig("holdToOpen", true), BindsConfig.getBooleanConfig("openLastPage", true), BindsConfig.getBooleanConfig("openLastPreset", true), BindsConfig.getBooleanConfig("keepMovement", false), BindsConfig.getBooleanConfig("closeOnAction", false), BindsConfig.getBooleanConfig("bindMsg", true)};
        this.thirdTab.addElement(new ToggleButton((class_2561)TextUtils.translatable("nitsha.binds.advances.options.hold", GUIUtils.truncateString(TextUtils.translatable(KeyBinds.BINDS.method_1428(), new Object[0]).getString(), 6)), 0, 0, this.getWidth() - 4, 20, false, options[0], () -> {
            BindsConfig.setConfig("holdToOpen", !options[0]);
            options[0] = BindsConfig.getBooleanConfig("holdToOpen", true);
        }));
        this.thirdTab.addElement(new ToggleButton((class_2561)TextUtils.translatable("nitsha.binds.advances.options.openLastPage", new Object[0]), 0, 20, this.getWidth() - 4, 20, false, options[1], () -> {
            BindsConfig.setConfig("openLastPage", !options[1]);
            options[1] = BindsConfig.getBooleanConfig("openLastPage", true);
        }));
        this.thirdTab.addElement(new ToggleButton((class_2561)TextUtils.translatable("nitsha.binds.advances.options.openLastPreset", new Object[0]), 0, 40, this.getWidth() - 4, 20, false, options[2], () -> {
            BindsConfig.setConfig("openLastPreset", !options[2]);
            options[2] = BindsConfig.getBooleanConfig("openLastPreset", true);
        }));
        this.thirdTab.addElement(new ToggleButton((class_2561)TextUtils.translatable("nitsha.binds.advances.options.keepMovement", new Object[0]), 0, 60, this.getWidth() - 4, 20, false, options[3], () -> {
            BindsConfig.setConfig("keepMovement", !options[3]);
            options[3] = BindsConfig.getBooleanConfig("keepMovement", false);
        }));
        this.thirdTab.addElement(new ToggleButton((class_2561)TextUtils.translatable("nitsha.binds.advances.options.closeOnAction", new Object[0]), 0, 80, this.getWidth() - 4, 20, false, options[4], () -> {
            BindsConfig.setConfig("closeOnAction", !options[4]);
            options[4] = BindsConfig.getBooleanConfig("closeOnAction", false);
        }));
        this.thirdTab.addElement(new ToggleButton((class_2561)TextUtils.translatable("nitsha.binds.advances.options.bindMsg", new Object[0]), 0, 100, this.getWidth() - 4, 20, false, options[5], () -> {
            BindsConfig.setConfig("bindMsg", !options[5]);
            options[5] = BindsConfig.getBooleanConfig("bindMsg", true);
        }));
        this.thirdTab.setScrollableArea(120);
        this.addElement(this.thirdTab);
    }

    public IconSelector getFirstTab() {
        return this.firstTab;
    }

    public void generateActionList(List<String> actions) {
        this.actionIndex = 0;
        this.actionY = 0;
        this.secondTab.clearChildren();
        for (String action : actions) {
            int h = 26;
            FastbindParser.ParsedEntry parsedAction = FastbindParser.parse(action);
            this.secondTab.addElement(new ActionItem(this, parsedAction.type, 4, this.actionY, this.getWidth() - 18, parsedAction.value, this.actionIndex));
            this.secondTab.addScrollableArea(h);
            ++this.actionIndex;
            this.actionY += h;
        }
        this.secondTab.addElement(new SmallTextButton(TextUtils.translatable("nitsha.binds.advances.actions.command", new Object[0]).getString(), 50, this.actionY + 2, 52, -11631099, () -> this.addAction(1, this.actionIndex, "")));
        this.secondTab.addElement(new SmallTextButton(TextUtils.translatable("nitsha.binds.advances.actions.delay", new Object[0]).getString(), 4, this.actionY + 2, 44, -3567086, () -> this.addAction(2, this.actionIndex, "100")));
        this.secondTab.addElement(new SmallTextButton(TextUtils.translatable("nitsha.binds.advances.actions.pressKey", new Object[0]).getString(), 104, this.actionY + 2, 62, -8843770, () -> this.addAction(3, this.actionIndex, "0")));
        this.secondTab.setScrollableArea(this.actionY + 13);
    }

    private void addAction(int type, int index, String value) {
        if (!BindsEditor.getCBind().actions.isEmpty()) {
            this.screen.saveBind();
        }
        BindsConfig.addBindAction(BindsEditor.getCurrentPreset(), BindsEditor.getActiveBind(), index, FastbindParser.toAction(type, value));
        this.generateActionList(BindsEditor.getCBind().actions);
        this.screen.saveBind();
        this.secondTab.scrollToBottom();
    }

    public void removeAction(int index) {
        if (!BindsEditor.getCBind().actions.isEmpty()) {
            this.screen.saveBind();
        }
        BindsConfig.removeBindAction(BindsEditor.getCurrentPreset(), BindsEditor.getActiveBind(), index);
        this.generateActionList(BindsEditor.getCBind().actions);
        this.screen.saveBind();
    }

    public void moveAction(int index, int dir) {
        if (!BindsEditor.getCBind().actions.isEmpty()) {
            this.screen.saveBind();
        }
        BindsConfig.moveBindAction(BindsEditor.getCurrentPreset(), BindsEditor.getActiveBind(), index, dir);
        this.generateActionList(BindsEditor.getCBind().actions);
        this.screen.saveBind();
    }

    public List<String> getAllActions() {
        ArrayList<String> actionsList = new ArrayList<String>();
        for (class_364 class_3642 : this.secondTab.method_25396()) {
            if (!(class_3642 instanceof ActionItem)) continue;
            ActionItem actionItem = (ActionItem)class_3642;
            actionsList.add(actionItem.getValue());
        }
        return actionsList;
    }

    @Override
    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        int adjX = mouseX - this.getX();
        int adjY = mouseY - this.getYOffset();
        GUIUtils.matricesUtil(ctx, this.getX(), this.getYOffset(), 0, () -> {
            if (this.getDelay() == 0L && this.isVisible()) {
                for (TabButton btn : this.tabsBtn) {
                    btn.method_25394(ctx, adjX, adjY, delta);
                }
            }
        });
        GUIUtils.matricesUtil(ctx, 0.0f, 0.0f, 2, () -> super.method_25394(ctx, mouseX, mouseY, delta));
    }

    @Override
    public boolean isMouseInside(double mouseX, double mouseY) {
        return mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.getWidth()) && mouseY >= (double)(this.getY() - 16) && mouseY < (double)(this.getY() + this.getHeight());
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.isVisible()) {
            return false;
        }
        double adjX = mouseX - (double)this.getX();
        double adjY = mouseY - (double)this.getYOffset();
        for (TabButton btn : this.tabsBtn) {
            if (!btn.method_25402(adjX, adjY, button)) continue;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }
}

