/*
 * Decompiled with CFR 0.152.
 */
package com.nitsha.binds.configs;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nitsha.binds.MainClass;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class BindsConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getGameDir().resolve("nitsha");
    public static List<List<String[]>> presets = new ArrayList<List<String[]>>();
    public static Map<String, Object> configs = new HashMap<String, Object>();
    private static final String[] DEFAULT_LINE = new String[]{"", "STRUCTURE_VOID", ""};

    private static void createConfigDirectory() {
        if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
            try {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0430\u043f\u043a\u0443 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a: " + String.valueOf(CONFIG_DIR), e);
            }
        }
    }

    public static void loadPresets() {
        for (int i = 0; i < 9; ++i) {
            File CONFIG_FILE = CONFIG_DIR.resolve("fastbind_preset_" + i + ".json5").toFile();
            List presetList = new ArrayList();
            if (CONFIG_FILE.exists()) {
                if (CONFIG_FILE.length() == 0L) {
                    BindsConfig.generateEmptyList(i);
                }
                try (FileReader reader = new FileReader(CONFIG_FILE);){
                    Type listType = new TypeToken<List<String[]>>(){}.getType();
                    presetList = (List)GSON.fromJson((Reader)reader, listType);
                    if (presetList == null) {
                        BindsConfig.generateEmptyList(i);
                    }
                }
                catch (IOException e) {
                    BindsConfig.generateEmptyList(i);
                    e.printStackTrace();
                }
                presets.add(presetList);
                continue;
            }
            BindsConfig.generateEmptyList(i);
        }
    }

    public static void generateEmptyList(int fileIndex) {
        ArrayList<String[]> presetList = new ArrayList<String[]>();
        presetList.add(new String[]{"Thank you!", "TRIAL_KEY", "nitsha::welcome"});
        for (int i = 0; i < 39; ++i) {
            presetList.add(DEFAULT_LINE);
        }
        presets.add(presetList);
        BindsConfig.savePresetFile(fileIndex);
    }

    public static String[] getBind(int fileIndex, int index) {
        return presets.get(fileIndex).get(index);
    }

    public static void setBind(int fileIndex, int index, String[] newLine) {
        presets.get(fileIndex).set(index, newLine);
        BindsConfig.savePresetFile(fileIndex);
    }

    public static void savePresetFile(int fileIndex) {
        File CONFIG_FILE = CONFIG_DIR.resolve("fastbind_preset_" + fileIndex + ".json5").toFile();
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson(presets.get(fileIndex), (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadConfigs() {
        File CONFIG_FILE = CONFIG_DIR.resolve("fastbind_configs.json5").toFile();
        if (CONFIG_FILE.exists()) {
            if (CONFIG_FILE.length() == 0L) {
                BindsConfig.generateNewConfig();
            }
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
                configs = (Map)GSON.fromJson((Reader)reader, mapType);
                if (configs == null) {
                    BindsConfig.generateNewConfig();
                }
            }
            catch (IOException e) {
                BindsConfig.generateNewConfig();
                e.printStackTrace();
            }
        } else {
            BindsConfig.generateNewConfig();
        }
    }

    public static void generateNewConfig() {
        ArrayList<String> presetsName = new ArrayList<String>(Collections.nCopies(9, "Default"));
        configs.put("presets", presetsName);
        BindsConfig.saveConfigFile();
    }

    public static void setNewPresetName(int presetIndex, String newName) {
        List presetsName = (List)configs.get("presets");
        presetsName.set(presetIndex, newName);
        BindsConfig.saveConfigFile();
    }

    public static void saveConfigFile() {
        File CONFIG_FILE = CONFIG_DIR.resolve("fastbind_configs.json5").toFile();
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson(configs, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void migrateOldPresetFileIfExists() {
        File oldFile;
        boolean moved;
        block21: {
            moved = false;
            oldFile = CONFIG_DIR.resolve("fastbind.json5").toFile();
            File newFile = CONFIG_DIR.resolve("fastbind_preset_0.json5").toFile();
            if (!oldFile.exists() || newFile.exists()) {
                return;
            }
            try (FileReader reader = new FileReader(oldFile);){
                Type listType = new TypeToken<List<String[]>>(){}.getType();
                List oldPreset = (List)GSON.fromJson((Reader)reader, listType);
                if (oldPreset != null && !oldPreset.isEmpty()) {
                    try (FileWriter writer = new FileWriter(newFile);){
                        GSON.toJson((Object)oldPreset, (Appendable)writer);
                        moved = true;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (!oldFile.delete()) {
                        // empty if block
                    }
                    MainClass.LOGGER.info("Old config fastbind.json5 was successfully migrate to fastbind_preset_0.json5");
                    break block21;
                }
                MainClass.LOGGER.error("Old config is empty or corrupted");
            }
            catch (IOException e) {
                MainClass.LOGGER.error("Old config migration error:");
                e.printStackTrace();
            }
        }
        if (moved) {
            try {
                Files.delete(oldFile.toPath());
                MainClass.LOGGER.info("Old config file " + oldFile.getName() + " was successfully deleted.");
            }
            catch (IOException e) {
                MainClass.LOGGER.error("Couldn't delete old config file " + oldFile.getName() + ":");
                e.printStackTrace();
            }
        }
    }

    static {
        BindsConfig.createConfigDirectory();
    }
}

