/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IMillstone;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.NinePart;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.MillstoneBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MillstoneBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final EnumProperty<NinePart> PART = EnumProperty.m_61587_((String)"part", NinePart.class);
    private static final VoxelShape CENTER = Block.m_49796_((double)-2.0, (double)0.0, (double)-2.0, (double)18.0, (double)15.0, (double)18.0);
    private static final VoxelShape LEFT_UP = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape)Block.m_49796_((double)8.0, (double)6.0, (double)8.0, (double)16.0, (double)14.0, (double)16.0));
    private static final VoxelShape UP = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)8.0, (double)16.0, (double)14.0, (double)16.0));
    private static final VoxelShape RIGHT_UP = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)5.0, (double)6.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)8.0, (double)8.0, (double)14.0, (double)16.0));
    private static final VoxelShape LEFT_CENTER = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape)Block.m_49796_((double)8.0, (double)6.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0));
    private static final VoxelShape RIGHT_CENTER = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)6.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)8.0, (double)14.0, (double)16.0));
    private static final VoxelShape LEFT_DOWN = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)5.0), (VoxelShape)Block.m_49796_((double)8.0, (double)6.0, (double)0.0, (double)16.0, (double)14.0, (double)8.0));
    private static final VoxelShape DOWN = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)5.0), (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)14.0, (double)8.0));
    private static final VoxelShape RIGHT_DOWN = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)6.0, (double)5.0), (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)8.0, (double)14.0, (double)8.0));

    public MillstoneBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56742_).m_280606_().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)((Object)NinePart.CENTER))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    private static void handleRemove(Level world, BlockPos pos, BlockState state, @Nullable Player player) {
        if (world.f_46443_) {
            return;
        }
        NinePart part = (NinePart)((Object)state.m_61143_(PART));
        BlockPos centerPos = pos.m_121996_(new Vec3i(part.getPosX(), 0, part.getPosY()));
        BlockEntity te = world.m_7702_(centerPos);
        if (!(te instanceof MillstoneBlockEntity)) {
            return;
        }
        MillstoneBlockEntity millstone = (MillstoneBlockEntity)te;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos offsetPos = centerPos.m_7918_(i, 0, j);
                world.m_7731_(offsetPos, Blocks.f_50016_.m_49966_(), 35);
            }
        }
        if (player != null && !player.m_7500_()) {
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)((Item)ModItems.MILLSTONE.get()).m_7968_());
        }
        if (!millstone.getOutput().m_41619_() && millstone.getCarrier().m_43947_()) {
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)millstone.getOutput());
        }
        if (!millstone.getInput().m_41619_()) {
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)millstone.getInput());
        }
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.f_46443_) {
            return null;
        }
        return MillstoneBlock.createTickerHelper(blockEntityType, (BlockEntityType)ModBlocks.MILLSTONE_BE.get(), (levelIn, pos, stateIn, millstone) -> millstone.tick(levelIn));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        NinePart part = (NinePart)((Object)state.m_61143_(PART));
        BlockPos centerPos = pos.m_121996_(new Vec3i(part.getPosX(), 0, part.getPosY()));
        BlockEntity te = level.m_7702_(centerPos);
        if (!(te instanceof IMillstone)) {
            return InteractionResult.PASS;
        }
        IMillstone millstone = (IMillstone)te;
        ItemStack mainHandItem = player.m_21205_();
        if (millstone.onTakeItem((LivingEntity)player, mainHandItem)) {
            return InteractionResult.SUCCESS;
        }
        if (millstone.onPutItem(level, mainHandItem)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        if (pEntity instanceof Mob) {
            MillstoneBlockEntity millstone;
            NinePart part;
            BlockPos centerPos;
            BlockEntity blockEntity;
            Mob mob = (Mob)pEntity;
            if (!pLevel.f_46443_ && pLevel.m_46467_() % 5L == 4L && (blockEntity = pLevel.m_7702_(centerPos = pPos.m_121996_(new Vec3i((part = (NinePart)((Object)pState.m_61143_(PART))).getPosX(), 0, part.getPosY())))) instanceof MillstoneBlockEntity && !(millstone = (MillstoneBlockEntity)blockEntity).hasEntity() && millstone.canBindEntity(mob)) {
                millstone.bindEntity(mob);
                Entity entity = mob.m_146895_();
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    ModTrigger.EVENT.trigger((LivingEntity)player, "drive_the_millstone");
                }
            }
        }
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        MillstoneBlock.handleRemove(world, pos, state, player);
        super.m_5707_(world, pos, state, player);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        MillstoneBlock.handleRemove(world, pos, state, null);
        super.onBlockExploded(state, world, pos, explosion);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos centerPos = context.m_8083_();
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos searchPos = centerPos.m_7918_(i, 0, j);
                if (context.m_43725_().m_8055_(searchPos).m_60629_(context)) continue;
                return null;
            }
        }
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (worldIn.f_46443_) {
            return;
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos searchPos = pos.m_7918_(i, 0, j);
                NinePart part = NinePart.getPartByPos(i, j);
                if (part == null || part.isCenter()) continue;
                worldIn.m_7731_(searchPos, (BlockState)state.m_61124_(PART, (Comparable)((Object)part)), 3);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{PART, f_54117_});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (((NinePart)((Object)state.m_61143_(PART))).isCenter()) {
            return new MillstoneBlockEntity(pos, state);
        }
        return null;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        NinePart value = (NinePart)((Object)pState.m_61143_(PART));
        return switch (value) {
            default -> throw new IncompatibleClassChangeError();
            case NinePart.LEFT_UP -> LEFT_UP;
            case NinePart.UP -> UP;
            case NinePart.RIGHT_UP -> RIGHT_UP;
            case NinePart.LEFT_CENTER -> LEFT_CENTER;
            case NinePart.CENTER -> CENTER;
            case NinePart.RIGHT_CENTER -> RIGHT_CENTER;
            case NinePart.LEFT_DOWN -> LEFT_DOWN;
            case NinePart.DOWN -> DOWN;
            case NinePart.RIGHT_DOWN -> RIGHT_DOWN;
        };
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.kaleidoscope_cookery.millstone").m_130940_(ChatFormatting.GRAY));
    }
}

