/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.ISteamer;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.SteamerBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.BaseBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.SteamerRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModParticles;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class SteamerBlockEntity
extends BaseBlockEntity
implements ISteamer {
    public static final int MAX_LIT_LEVEL = 4;
    public static final String COOKING_PROGRESS_TAG = "CookingProgress";
    public static final String COOKING_TIME_TAG = "CookingTime";
    public static final String ITEMS_TAG = "Items";
    private final RecipeManager.CachedCheck<Container, SteamerRecipe> quickCheck = RecipeManager.m_220267_(ModRecipes.STEAMER_RECIPE);
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    private final int[] cookingProgress = new int[8];
    private final int[] cookingTime = new int[8];
    private int litLevel = 0;

    public SteamerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.STEAMER_BE.get(), pos, state);
    }

    public void tick(Level level) {
        if (level.m_46467_() % 5L == 0L) {
            this.updateLitLevel(level);
            for (int i = 0; i < this.items.size(); ++i) {
                if (this.cookingTime[i] != -1) continue;
                this.makeRipeParticles(level, this.f_58858_);
                break;
            }
        }
        if (this.litLevel > 0) {
            this.cookingTick(level, this.f_58858_, this.m_58900_(), this);
        } else {
            this.cooldownTick(level, this.f_58858_, this.m_58900_(), this);
        }
    }

    public void mergeItem(ItemStack stack) {
        int length;
        int[] times;
        CompoundTag data = stack.m_41698_("BlockEntityTag");
        NonNullList merge = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
        int[] mergeCookingProgress = new int[8];
        int[] mergeCookingTime = new int[8];
        if (data.m_128425_(ITEMS_TAG, 9)) {
            NonNullList itemsInStack = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)data, (NonNullList)itemsInStack);
            for (int i = 0; i < 4; ++i) {
                merge.set(i + 4, (Object)((ItemStack)itemsInStack.get(i)));
            }
        }
        if (data.m_128425_(COOKING_PROGRESS_TAG, 11)) {
            times = data.m_128465_(COOKING_PROGRESS_TAG);
            length = Math.min(mergeCookingProgress.length - 4, times.length);
            System.arraycopy(times, 0, mergeCookingProgress, 4, length);
        }
        if (data.m_128425_(COOKING_TIME_TAG, 11)) {
            times = data.m_128465_(COOKING_TIME_TAG);
            length = Math.min(mergeCookingTime.length - 4, times.length);
            System.arraycopy(times, 0, mergeCookingTime, 4, length);
        }
        for (int i = 0; i < 4; ++i) {
            merge.set(i, (Object)((ItemStack)this.items.get(i)));
            mergeCookingProgress[i] = this.cookingProgress[i];
            mergeCookingTime[i] = this.cookingTime[i];
        }
        ContainerHelper.m_18976_((CompoundTag)data, (NonNullList)merge, (boolean)false);
        data.m_128385_(COOKING_PROGRESS_TAG, mergeCookingProgress);
        data.m_128385_(COOKING_TIME_TAG, mergeCookingTime);
        BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)this.m_58903_(), (CompoundTag)data);
    }

    public List<ItemStack> dropAsItem() {
        ArrayList drops = Lists.newArrayList();
        boolean half = (Boolean)this.m_58900_().m_61143_((Property)SteamerBlock.HALF);
        ItemStack first = ((Item)ModItems.STEAMER.get()).m_7968_();
        if (this.items.stream().allMatch(ItemStack::m_41619_)) {
            drops.add(first);
            if (!half) {
                drops.add(((Item)ModItems.STEAMER.get()).m_7968_());
            }
            return drops;
        }
        CompoundTag tag1 = new CompoundTag();
        CompoundTag tag2 = new CompoundTag();
        SteamerBlockEntity.saveSplit(tag1, tag2, this.items, this.cookingProgress, this.cookingTime);
        BlockItem.m_186338_((ItemStack)first, (BlockEntityType)this.m_58903_(), (CompoundTag)tag1);
        drops.add(first);
        if (!half) {
            ItemStack second = ((Item)ModItems.STEAMER.get()).m_7968_();
            BlockItem.m_186338_((ItemStack)second, (BlockEntityType)this.m_58903_(), (CompoundTag)tag2);
            drops.add(second);
        }
        return drops;
    }

    @Override
    public void updateLitLevel(Level level) {
        BlockPos pos = this.m_58899_();
        if (this.hasHeatSource(level)) {
            this.litLevel = 4;
        } else {
            BlockEntity blockEntity = level.m_7702_(pos.m_7495_());
            if (blockEntity instanceof SteamerBlockEntity) {
                SteamerBlockEntity steamer = (SteamerBlockEntity)blockEntity;
                this.litLevel = (Boolean)steamer.m_58900_().m_61143_((Property)SteamerBlock.HALF) != false ? 0 : Math.max(steamer.litLevel - 1, 0);
            }
        }
    }

    @Override
    public boolean hasHeatSource(Level level) {
        BlockState belowState = level.m_8055_(this.f_58858_.m_7495_());
        if (belowState.m_61138_((Property)BlockStateProperties.f_61443_) && ((Boolean)belowState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            return true;
        }
        return belowState.m_204336_(TagMod.HEAT_SOURCE_BLOCKS_WITHOUT_LIT);
    }

    private void cookingTick(Level level, BlockPos pos, BlockState state, SteamerBlockEntity steamer) {
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        boolean aboveIsSteamer = aboveState.m_60713_((Block)ModBlocks.STEAMER.get());
        if (!aboveIsSteamer) {
            this.makeCookingParticles(level, pos);
            if (!((Boolean)state.m_61143_((Property)SteamerBlock.HAS_LID)).booleanValue()) {
                return;
            }
        }
        boolean hasCooking = false;
        for (int i = 0; i < steamer.items.size(); ++i) {
            int progress;
            ItemStack stack = (ItemStack)steamer.items.get(i);
            if (stack.m_41619_()) continue;
            hasCooking = true;
            int n = i;
            steamer.cookingProgress[n] = steamer.cookingProgress[n] + 1;
            if (progress < steamer.cookingTime[i]) continue;
            SimpleContainer container = new SimpleContainer(new ItemStack[]{stack});
            ItemStack resultStack = steamer.quickCheck.m_213657_((Container)container, level).map(arg_0 -> SteamerBlockEntity.lambda$cookingTick$0((Container)container, level, arg_0)).orElse(stack);
            if (resultStack.m_41619_()) continue;
            steamer.items.set(i, (Object)resultStack);
            steamer.cookingTime[i] = -1;
            level.m_7260_(pos, state, state, 3);
        }
        if (hasCooking) {
            SteamerBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private void cooldownTick(Level level, BlockPos pos, BlockState state, SteamerBlockEntity steamer) {
        boolean hasCooking = false;
        for (int i = 0; i < steamer.items.size(); ++i) {
            if (steamer.cookingProgress[i] <= 0) continue;
            hasCooking = true;
            steamer.cookingProgress[i] = Mth.m_14045_((int)(steamer.cookingProgress[i] - 2), (int)0, (int)steamer.cookingTime[i]);
        }
        if (hasCooking) {
            SteamerBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void makeCookingParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.f_46441_.m_188501_() < 0.1f) {
                RandomSource random = serverLevel.f_46441_;
                boolean half = (Boolean)this.m_58900_().m_61143_((Property)SteamerBlock.HALF);
                double yOffset = half ? 0.5 : 1.0;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)pos.m_123341_() + 0.5 + random.m_188500_() / 2.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + yOffset + random.m_188500_() / 2.0, (double)pos.m_123343_() + 0.5 + random.m_188500_() / 2.0 * (double)(random.m_188499_() ? 1 : -1), 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
    }

    public void makeRipeParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.f_46441_.m_188501_() < 0.5f) {
                RandomSource random = serverLevel.f_46441_;
                boolean half = (Boolean)this.m_58900_().m_61143_((Property)SteamerBlock.HALF);
                double yOffset = half ? 0.25 : 0.75;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)pos.m_123341_() + 0.5 + random.m_188500_() / 1.25 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + yOffset + random.m_188500_() / 2.0, (double)pos.m_123343_() + 0.5 + random.m_188500_() / 1.25 * (double)(random.m_188499_() ? 1 : -1), 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
    }

    public Optional<SteamerRecipe> getSteamerRecipe(Level level, ItemStack stack) {
        if (this.items.stream().noneMatch(ItemStack::m_41619_)) {
            return Optional.empty();
        }
        return this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), level);
    }

    @Override
    public boolean placeFood(Level level, LivingEntity user, ItemStack food) {
        int startIndex;
        if (!level.m_46859_(this.m_58899_().m_7494_())) {
            return false;
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)SteamerBlock.HAS_LID)).booleanValue()) {
            return false;
        }
        Optional<SteamerRecipe> steamerRecipe = this.getSteamerRecipe(level, food);
        if (steamerRecipe.isEmpty()) {
            return false;
        }
        int cookTime = steamerRecipe.get().getCookTick();
        if (cookTime <= 0) {
            return false;
        }
        for (int i = startIndex = (half = ((Boolean)this.m_58900_().m_61143_((Property)SteamerBlock.HALF)).booleanValue()) ? 0 : 4; i < startIndex + 4; ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            if (!itemstack.m_41619_()) continue;
            this.cookingTime[i] = cookTime;
            this.cookingProgress[i] = 0;
            this.items.set(i, (Object)food.m_41620_(1));
        }
        this.refresh();
        return true;
    }

    @Override
    public boolean takeFood(Level level, LivingEntity user) {
        if (!level.m_46859_(this.m_58899_().m_7494_())) {
            return false;
        }
        BlockState blockState = this.m_58900_();
        if (((Boolean)blockState.m_61143_((Property)SteamerBlock.HAS_LID)).booleanValue()) {
            return false;
        }
        boolean isAllEmpty = true;
        boolean half = (Boolean)blockState.m_61143_((Property)SteamerBlock.HALF);
        int startIndex = half ? 4 : 8;
        for (int i = startIndex - 1; i >= startIndex - 4; --i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.m_41619_()) continue;
            isAllEmpty = false;
            ItemUtils.getItemToLivingEntity(user, stack);
            this.items.set(i, (Object)ItemStack.f_41583_);
            this.cookingTime[i] = 0;
            this.cookingProgress[i] = 0;
        }
        if (isAllEmpty) {
            int n;
            if (user instanceof Player) {
                Player player = (Player)user;
                n = player.m_150109_().f_35977_;
            } else {
                n = -1;
            }
            int preferredSlot = n;
            ItemUtils.getItemToLivingEntity(user, ((Item)ModItems.STEAMER.get()).m_7968_(), preferredSlot);
            for (int i = 4; i < 8; ++i) {
                this.items.set(i, (Object)ItemStack.f_41583_);
                this.cookingTime[i] = 0;
                this.cookingProgress[i] = 0;
            }
            level.m_247517_(null, this.m_58899_(), blockState.m_60827_().m_56775_(), SoundSource.BLOCKS);
            if (half) {
                level.m_46597_(this.m_58899_(), Blocks.f_50016_.m_49966_());
            } else {
                this.m_6596_();
                level.m_46597_(this.m_58899_(), (BlockState)blockState.m_61124_((Property)SteamerBlock.HALF, (Comparable)Boolean.valueOf(true)));
            }
        } else {
            this.refresh();
        }
        return true;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void m_142466_(CompoundTag tag) {
        int length;
        int[] times;
        super.m_142466_(tag);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        if (tag.m_128425_(COOKING_PROGRESS_TAG, 11)) {
            times = tag.m_128465_(COOKING_PROGRESS_TAG);
            length = Math.min(this.cookingTime.length, times.length);
            System.arraycopy(times, 0, this.cookingProgress, 0, length);
        }
        if (tag.m_128425_(COOKING_TIME_TAG, 11)) {
            times = tag.m_128465_(COOKING_TIME_TAG);
            length = Math.min(this.cookingTime.length, times.length);
            System.arraycopy(times, 0, this.cookingTime, 0, length);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18976_((CompoundTag)tag, this.items, (boolean)true);
        tag.m_128385_(COOKING_PROGRESS_TAG, this.cookingProgress);
        tag.m_128385_(COOKING_TIME_TAG, this.cookingTime);
    }

    public static void saveSplit(CompoundTag tag1, CompoundTag tag2, NonNullList<ItemStack> items, int[] cookingProgress, int[] cookingTime) {
        NonNullList first = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        NonNullList second = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        for (int i = 0; i < 4; ++i) {
            first.set(i, (Object)((ItemStack)items.get(i)));
            second.set(i, (Object)((ItemStack)items.get(i + 4)));
        }
        int[] firstCookingProgress = new int[4];
        int[] secondCookingProgress = new int[4];
        int[] firstCookingTime = new int[4];
        int[] secondCookingTime = new int[4];
        System.arraycopy(cookingProgress, 0, firstCookingProgress, 0, 4);
        System.arraycopy(cookingProgress, 4, secondCookingProgress, 0, 4);
        System.arraycopy(cookingTime, 0, firstCookingTime, 0, 4);
        System.arraycopy(cookingTime, 4, secondCookingTime, 0, 4);
        ContainerHelper.m_18976_((CompoundTag)tag1, (NonNullList)first, (boolean)false);
        if (!tag1.m_128456_()) {
            tag1.m_128385_(COOKING_PROGRESS_TAG, firstCookingProgress);
            tag1.m_128385_(COOKING_TIME_TAG, firstCookingTime);
        }
        ContainerHelper.m_18976_((CompoundTag)tag2, (NonNullList)second, (boolean)false);
        if (!tag2.m_128456_()) {
            tag2.m_128385_(COOKING_PROGRESS_TAG, secondCookingProgress);
            tag2.m_128385_(COOKING_TIME_TAG, secondCookingTime);
        }
    }

    public int[] getCookingProgress() {
        return this.cookingProgress;
    }

    public int[] getCookingTime() {
        return this.cookingTime;
    }

    private static /* synthetic */ ItemStack lambda$cookingTick$0(Container container, Level level, SteamerRecipe r) {
        return r.m_5874_(container, level.m_9598_());
    }
}

