/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.render.block;

import com.github.ysbbbbbb.kaleidoscopecookery.api.client.render.ISoupBaseRender;
import com.github.ysbbbbbb.kaleidoscopecookery.api.recipe.soupbase.ISoupBase;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.StockpotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.StockpotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.client.resources.ItemRenderReplacer;
import com.github.ysbbbbbb.kaleidoscopecookery.client.resources.ItemRenderReplacerReloadListener;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.soupbase.SoupBaseManager;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;

public class StockpotBlockEntityRender
implements BlockEntityRenderer<StockpotBlockEntity> {
    private final BlockEntityRendererProvider.Context context;
    private final Function<ResourceLocation, ISoupBaseRender> soupBaseRender;

    public StockpotBlockEntityRender(BlockEntityRendererProvider.Context context) {
        this.context = context;
        this.soupBaseRender = Util.m_143827_(id -> {
            ISoupBase soupBase = SoupBaseManager.getSoupBase(id);
            if (soupBase != null) {
                return soupBase.getRender();
            }
            return null;
        });
    }

    public void render(StockpotBlockEntity stockpot, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        if (((Boolean)stockpot.m_58900_().m_61143_((Property)StockpotBlock.HAS_LID)).booleanValue()) {
            return;
        }
        int status = stockpot.getStatus();
        ISoupBaseRender soupBase = this.soupBaseRender.apply(stockpot.getSoupBaseId());
        if (status == 1) {
            soupBase.renderWhenPutIngredient(stockpot, partialTick, poseStack, buffer, packedLight, packedOverlay, 0.38f);
            this.renderItems(stockpot, poseStack, buffer, packedLight, packedOverlay, false);
        } else if (status == 2) {
            soupBase.renderWhenCooking(stockpot, partialTick, poseStack, buffer, packedLight, packedOverlay, stockpot.recipe.cookingTexture(), 0.38f);
            this.renderItems(stockpot, poseStack, buffer, packedLight, packedOverlay, true);
        } else if (status == 3) {
            int takeoutCount = stockpot.getTakeoutCount();
            int maxCount = Math.min(stockpot.getResult().m_41613_(), 9);
            float soupHeight = 0.065f + 0.315f / (float)maxCount * (float)takeoutCount;
            soupBase.renderWhenFinished(stockpot, partialTick, poseStack, buffer, packedLight, packedOverlay, stockpot.recipe.finishedTexture(), soupHeight);
        }
    }

    private void renderItems(StockpotBlockEntity stockpot, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, boolean isFinished) {
        NonNullList<ItemStack> items = stockpot.getInputs();
        items.forEach(stack -> {
            if (!stack.m_41619_()) {
                int random = stack.hashCode();
                long time = (long)random + System.currentTimeMillis();
                float offsetX = (float)(random % 100) * 0.002f;
                float offsetZ = (float)(Math.sin((double)time * 5.0E-4) * 0.2);
                float offsetY = (float)(random % 50) * 0.004f;
                float yRot = (random % 2 == 0 ? -1 : 1) * 20 + random % 10;
                BakedModel model = isFinished ? ItemRenderReplacer.getModel(stockpot.m_58904_(), stack, ItemRenderReplacerReloadListener.INSTANCE.stockpotFinished()) : ItemRenderReplacer.getModel(stockpot.m_58904_(), stack, ItemRenderReplacerReloadListener.INSTANCE.stockpotCooking());
                poseStack.m_85836_();
                poseStack.m_252781_(Axis.f_252529_.m_252977_((float)(85 + random % 10)));
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                poseStack.m_85837_(0.9 + (double)offsetX, 0.9 + (double)offsetY, -0.5 + (double)offsetZ);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(yRot));
                poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(random % 360)));
                this.context.m_234447_().m_115143_(stack, ItemDisplayContext.FIXED, false, poseStack, buffer, packedLight, packedOverlay, model);
                poseStack.m_85849_();
            }
        });
    }
}

