/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.crafting.ingredinet;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;

public class AnyIngredient
extends AbstractIngredient {
    public static final ResourceLocation ID = new ResourceLocation("kaleidoscopecookery", "any_ingredient");
    private final List<Ingredient> ingredients;
    @javax.annotation.Nullable
    private ItemStack[] itemStacks;
    @javax.annotation.Nullable
    private IntList stackingIds;

    protected AnyIngredient(List<Ingredient> ingredients) {
        for (Ingredient ingredient : ingredients) {
            if (CraftingHelper.getID((IIngredientSerializer)ingredient.getSerializer()) != null) continue;
            throw new RuntimeException("AnyIngredient only support ingredient that has id, the ingredient not support: " + String.valueOf(ingredient));
        }
        this.ingredients = Collections.unmodifiableList(ingredients);
    }

    public static AnyIngredient of(List<Ingredient> ingredients) {
        for (Ingredient ingredient : ingredients) {
            if (CraftingHelper.getID((IIngredientSerializer)ingredient.getSerializer()) != null) continue;
            throw new RuntimeException("AnyIngredient only support ingredient that has id, the ingredient not support: " + String.valueOf(ingredient));
        }
        return new AnyIngredient(ingredients);
    }

    public static AnyIngredient of(Ingredient ... ingredients) {
        for (Ingredient ingredient : ingredients) {
            if (CraftingHelper.getID((IIngredientSerializer)ingredient.getSerializer()) != null) continue;
            throw new RuntimeException("AnyIngredient only support ingredient that has id, the ingredient not support: " + String.valueOf(ingredient));
        }
        return new AnyIngredient(List.of(ingredients));
    }

    public boolean isSimple() {
        return this.ingredients.stream().allMatch(Ingredient::isSimple);
    }

    public boolean m_43947_() {
        return this.ingredients.stream().allMatch(Ingredient::m_43947_);
    }

    public boolean test(@Nullable ItemStack pStack) {
        if (pStack == null || pStack.m_41619_()) {
            return false;
        }
        for (Ingredient ingredient : this.ingredients) {
            if (!ingredient.test(pStack)) continue;
            return true;
        }
        return false;
    }

    public ItemStack[] m_43908_() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])this.ingredients.stream().flatMap(ingredient -> Arrays.stream(ingredient.m_43908_())).distinct().toArray(ItemStack[]::new);
        }
        return this.itemStacks;
    }

    public IntList m_43931_() {
        if (this.stackingIds == null || this.checkInvalidation()) {
            this.markValid();
            ItemStack[] aitemstack = this.m_43908_();
            this.stackingIds = new IntArrayList(aitemstack.length);
            for (ItemStack itemstack : aitemstack) {
                this.stackingIds.add(StackedContents.m_36496_((ItemStack)itemstack));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    protected void invalidate() {
        super.invalidate();
        this.itemStacks = null;
        this.stackingIds = null;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject jsonObj = new JsonObject();
        jsonObj.addProperty("type", ID.toString());
        JsonArray json = new JsonArray();
        for (Ingredient ingredient : this.ingredients) {
            ResourceLocation id = CraftingHelper.getID((IIngredientSerializer)ingredient.getSerializer());
            assert (id != null);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", id.toString());
            jsonObject.add("value", ingredient.m_43942_());
            json.add((JsonElement)jsonObject);
        }
        jsonObj.add("ingredients", (JsonElement)json);
        return jsonObj;
    }

    public static class Serializer
    implements IIngredientSerializer<AnyIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public AnyIngredient parse(FriendlyByteBuf buffer) {
            ArrayList ingredients = Lists.newArrayList();
            int size = buffer.m_130242_();
            for (int i = 0; i < size; ++i) {
                ResourceLocation ingredientSe = buffer.m_130281_();
                Ingredient ingredient = CraftingHelper.getIngredient((ResourceLocation)ingredientSe, (FriendlyByteBuf)buffer);
                ingredients.add(ingredient);
            }
            return new AnyIngredient(ingredients);
        }

        public AnyIngredient parse(JsonObject json) {
            ArrayList ingredients = Lists.newArrayList();
            JsonArray jsonArray = json.getAsJsonArray("ingredients");
            for (JsonElement jsonElement : jsonArray) {
                JsonObject jsonObject = jsonElement.getAsJsonObject().getAsJsonObject("value");
                Ingredient ingredient = Ingredient.m_288218_((JsonElement)jsonObject, (boolean)true);
                ingredients.add(ingredient);
            }
            return new AnyIngredient(ingredients);
        }

        public void write(FriendlyByteBuf buffer, AnyIngredient nbtIngredient) {
            buffer.m_130130_(nbtIngredient.ingredients.size());
            for (Ingredient ingredient : nbtIngredient.ingredients) {
                IIngredientSerializer serializer = ingredient.getSerializer();
                ResourceLocation id = CraftingHelper.getID((IIngredientSerializer)serializer);
                assert (id != null);
                buffer.m_130085_(id);
                this.writeIngredient(buffer, ingredient, serializer);
            }
        }

        private <T extends Ingredient> void writeIngredient(FriendlyByteBuf buffer, Ingredient ingredient, IIngredientSerializer<T> serializer) {
            serializer.write(buffer, ingredient);
        }
    }
}

