/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen.builder;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class MillstoneRecipeBuilder
implements RecipeBuilder {
    private static final String NAME = "millstone";
    private Ingredient ingredient = Ingredient.f_43901_;
    private ItemStack result = ItemStack.f_41583_;
    private Ingredient carrier = Ingredient.f_43901_;

    public static MillstoneRecipeBuilder builder() {
        return new MillstoneRecipeBuilder();
    }

    public MillstoneRecipeBuilder setIngredient(ItemLike itemLike) {
        this.ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike});
        return this;
    }

    public MillstoneRecipeBuilder setIngredient(TagKey<Item> itemLike) {
        this.ingredient = Ingredient.m_204132_(itemLike);
        return this;
    }

    public MillstoneRecipeBuilder setResult(ItemStack stack) {
        this.result = stack;
        return this;
    }

    public MillstoneRecipeBuilder setResult(ItemLike itemLike) {
        this.result = new ItemStack(itemLike);
        return this;
    }

    public MillstoneRecipeBuilder setResult(ItemLike itemLike, int count) {
        this.result = new ItemStack(itemLike, count);
        return this;
    }

    public MillstoneRecipeBuilder setCarrier(ItemLike itemLike) {
        this.carrier = Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike});
        return this;
    }

    public MillstoneRecipeBuilder setCarrier(TagKey<Item> itemLike) {
        this.carrier = Ingredient.m_204132_(itemLike);
        return this;
    }

    public MillstoneRecipeBuilder setCarrier(Ingredient ingredient) {
        this.carrier = ingredient;
        return this;
    }

    public RecipeBuilder m_126132_(String criterionName, CriterionTriggerInstance criterionTrigger) {
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String groupName) {
        return this;
    }

    public Item m_142372_() {
        return this.result.m_41720_();
    }

    public void m_176498_(Consumer<FinishedRecipe> output) {
        String path = RecipeBuilder.m_176493_((ItemLike)this.m_142372_()).m_135815_();
        ResourceLocation filePath = new ResourceLocation("kaleidoscope_cookery", "millstone/" + path);
        this.m_126140_(output, filePath);
    }

    public void m_176500_(Consumer<FinishedRecipe> output, String recipeId) {
        ResourceLocation filePath = new ResourceLocation("kaleidoscope_cookery", "millstone/" + recipeId);
        this.m_126140_(output, filePath);
    }

    public void m_126140_(Consumer<FinishedRecipe> recipeOutput, ResourceLocation id) {
        recipeOutput.accept(new MillstoneRecipe(id, this.ingredient, this.result, this.carrier));
    }

    public static class MillstoneRecipe
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final ItemStack result;
        private final Ingredient carrier;

        public MillstoneRecipe(ResourceLocation id, Ingredient ingredient, ItemStack result, Ingredient carrier) {
            this.id = id;
            this.ingredient = ingredient;
            this.result = result;
            this.carrier = carrier;
        }

        public void m_7917_(JsonObject json) {
            json.add("ingredient", this.ingredient.m_43942_());
            JsonObject itemJson = new JsonObject();
            itemJson.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_())).toString());
            if (this.result.m_41613_() > 1) {
                itemJson.addProperty("count", (Number)this.result.m_41613_());
            }
            json.add("result", (JsonElement)itemJson);
            if (!this.carrier.m_43947_()) {
                json.add("carrier", this.carrier.m_43942_());
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.MILLSTONE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

