/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.event;

import com.github.ysbbbbbb.kaleidoscopecookery.api.event.RecipeItemEvent;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.item.FruitBasketItem;
import com.github.ysbbbbbb.kaleidoscopecookery.item.TransmutationLunchBagItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

@Mod.EventBusSubscriber(modid="kaleidoscope_cookery")
public class SpecialRecipeItemEvent {
    @SubscribeEvent
    public static void onCheckItemEvent(RecipeItemEvent.CheckItem event) {
        ItemStack stack = event.getStack();
        if (stack.m_150930_((Item)ModItems.FRUIT_BASKET.get())) {
            ItemStackHandler items = FruitBasketItem.getItems(stack);
            SpecialRecipeItemEvent.addItems(event, (IItemHandler)items);
            FruitBasketItem.saveItems(stack, items);
            return;
        }
        if (stack.m_150930_((Item)ModItems.TRANSMUTATION_LUNCH_BAG.get())) {
            ItemStackHandler items = TransmutationLunchBagItem.getItems(stack);
            SpecialRecipeItemEvent.addItems(event, (IItemHandler)items);
            TransmutationLunchBagItem.setItems(stack, items);
            return;
        }
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> SpecialRecipeItemEvent.addItems(event, handler));
    }

    @SubscribeEvent
    public static void onDeductItemEvent(RecipeItemEvent.DeductItem event) {
        ItemStack stack = event.getStack();
        if (stack.m_150930_((Item)ModItems.FRUIT_BASKET.get())) {
            ItemStackHandler items = FruitBasketItem.getItems(stack);
            SpecialRecipeItemEvent.deductItems(event, (IItemHandler)items);
            FruitBasketItem.saveItems(stack, items);
            return;
        }
        if (stack.m_150930_((Item)ModItems.TRANSMUTATION_LUNCH_BAG.get())) {
            ItemStackHandler items = TransmutationLunchBagItem.getItems(stack);
            SpecialRecipeItemEvent.deductItems(event, (IItemHandler)items);
            TransmutationLunchBagItem.setItems(stack, items);
            return;
        }
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> SpecialRecipeItemEvent.deductItems(event, handler));
    }

    private static void addItems(RecipeItemEvent.CheckItem event, IItemHandler items) {
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack slotStack = items.getStackInSlot(i);
            if (slotStack.m_41619_()) continue;
            event.addItem(slotStack.m_41720_(), slotStack.m_41613_());
        }
    }

    private static void deductItems(RecipeItemEvent.DeductItem event, IItemHandler items) {
        Item needItem = event.getNeedItem();
        for (int i = 0; i < items.getSlots(); ++i) {
            int needCount = event.getNeedCount();
            if (needCount <= 0) {
                return;
            }
            ItemStack slotStack = items.getStackInSlot(i);
            if (!slotStack.m_150930_(needItem)) continue;
            ItemStack extractItem = items.extractItem(i, needCount, false);
            event.deduct(extractItem.m_41613_());
        }
    }
}

