/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.event.recipe;

import com.github.ysbbbbbb.kaleidoscopecookery.api.event.MillstoneTakeItemEvent;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.MillstoneBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.ingredinet.AnyIngredient;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.item.OilPotItem;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.PartialNBTIngredient;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MillstoneSpecialRecipeEvent {
    @SubscribeEvent
    public static void onMillstoneTakeItem(MillstoneTakeItemEvent event) {
        MillstoneBlockEntity millstone = event.getMillstone();
        ItemStack output = millstone.getOutput();
        if (output.m_150930_((Item)ModItems.OIL_POT.get())) {
            MillstoneSpecialRecipeEvent.onGetOilPot(event, millstone, output);
            return;
        }
        if (output.m_150930_((Item)ModItems.RAW_DOUGH.get())) {
            MillstoneSpecialRecipeEvent.onGetRawDough(event, millstone, output);
        }
    }

    private static void onGetRawDough(MillstoneTakeItemEvent event, MillstoneBlockEntity millstone, ItemStack output) {
        LivingEntity user = event.getUser();
        ItemStack heldItem = event.getHeldItem();
        AnyIngredient ingredient = AnyIngredient.of(new Ingredient[]{Ingredient.m_204132_(TagMod.MILLSTONE_DOUGH_CONTAINER), PartialNBTIngredient.of((CompoundTag)PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)Potions.f_43599_).m_41784_(), (ItemLike[])new ItemLike[]{Items.f_42589_})});
        if (heldItem.m_41619_() || !ingredient.test(heldItem)) {
            Component carrierName = Items.f_42447_.m_7968_().m_41786_();
            millstone.sendActionBarMessage(user, "tip.kaleidoscope_cookery.pot.need_carrier", carrierName);
            event.setResult(false);
            event.setCanceled(true);
            return;
        }
        ItemUtils.getItemToLivingEntity(user, output.m_41777_());
        Item containerItem = ItemUtils.getContainerItem(heldItem.m_41620_(1));
        if (containerItem != Items.f_41852_) {
            ItemUtils.getItemToLivingEntity(user, containerItem.m_7968_());
        }
        millstone.resetWhenTakeout();
        event.setResult(true);
        event.setCanceled(true);
    }

    private static void onGetOilPot(MillstoneTakeItemEvent event, MillstoneBlockEntity millstone, ItemStack output) {
        LivingEntity user = event.getUser();
        ItemStack heldItem = event.getHeldItem();
        if (heldItem.m_41619_() || !heldItem.m_150930_((Item)ModItems.OIL_POT.get())) {
            Component carrierName = ((Item)ModItems.OIL_POT.get()).m_7968_().m_41786_();
            millstone.sendActionBarMessage(user, "tip.kaleidoscope_cookery.pot.need_carrier", carrierName);
            event.setResult(false);
            event.setCanceled(true);
            return;
        }
        int oilCount = OilPotItem.getOilCount(heldItem);
        if (oilCount >= 8) {
            millstone.sendActionBarMessage(user, "tip.kaleidoscope_cookery.millstone.oil_pot_is_full", new Object[0]);
            event.setResult(false);
            event.setCanceled(true);
            return;
        }
        RandomSource random = user.m_9236_().m_213780_();
        if (random.m_188503_(8) < output.m_41613_()) {
            ItemStack takeItem = heldItem.m_41620_(1);
            OilPotItem.setOilCount(takeItem, oilCount + 1);
            ItemUtils.getItemToLivingEntity(user, takeItem);
        }
        millstone.resetWhenTakeout();
        event.setResult(true);
        event.setCanceled(true);
    }
}

