/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.item;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OilPotItem
extends BlockItem {
    public static final ResourceLocation HAS_OIL_PROPERTY = new ResourceLocation("kaleidoscope_cookery", "has_oil");
    public static final int MAX_COUNT = 8;
    private static final String BLOCK_STATE_TAG = "BlockStateTag";
    private static final String OIL_COUNT = "oil_count";
    private static final int NO_OIL = 0;
    private static final int HAS_OIL = 1;

    public OilPotItem() {
        super((Block)ModBlocks.OIL_POT.get(), new Item.Properties().m_41487_(16));
    }

    public static void setOilCount(ItemStack stack, int count) {
        count = Mth.m_14045_((int)count, (int)0, (int)8);
        stack.m_41698_(BLOCK_STATE_TAG).m_128405_(OIL_COUNT, count);
    }

    public static int getOilCount(ItemStack stack) {
        CompoundTag element = stack.m_41737_(BLOCK_STATE_TAG);
        if (element == null || !element.m_128441_(OIL_COUNT)) {
            return 0;
        }
        return element.m_128451_(OIL_COUNT);
    }

    public static boolean hasOil(ItemStack stack) {
        return OilPotItem.getOilCount(stack) > 0;
    }

    public static void shrinkOilCount(ItemStack stack) {
        int currentCount = OilPotItem.getOilCount(stack);
        if (currentCount > 0) {
            OilPotItem.setOilCount(stack, currentCount - 1);
        }
    }

    public static ItemStack getFullOilPot() {
        ItemStack stack = new ItemStack((ItemLike)ModBlocks.OIL_POT.get());
        OilPotItem.setOilCount(stack, 8);
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getTexture(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        if (OilPotItem.hasOil(stack)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        int oilCount = OilPotItem.getOilCount(pStack);
        if (oilCount > 0) {
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.kaleidoscope_cookery.oil_pot.count", (Object[])new Object[]{oilCount}).m_130940_(ChatFormatting.GRAY));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.kaleidoscope_cookery.oil_pot.empty").m_130940_(ChatFormatting.GRAY));
        }
    }
}

