/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.loot;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModLootModifier;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class AdvanceBlockMatchTool
implements LootItemCondition {
    private final EquipmentSlot slot;
    private final ItemPredicate predicate;

    public AdvanceBlockMatchTool(EquipmentSlot slot, ItemPredicate predicate) {
        this.slot = slot;
        this.predicate = predicate;
    }

    public LootItemConditionType m_7940_() {
        return ModLootModifier.ADVANCE_BLOCK_MATCH_TOOL;
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81455_);
    }

    public boolean test(LootContext context) {
        Entity entity;
        if (context.m_78936_(LootContextParams.f_81455_) && (entity = (Entity)context.m_165124_(LootContextParams.f_81455_)) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack stack = livingEntity.m_6844_(this.slot);
            return this.predicate.m_45049_(stack);
        }
        return false;
    }

    public static LootItemCondition.Builder toolMatches(EquipmentSlot slot, ItemPredicate builder) {
        return () -> new AdvanceBlockMatchTool(slot, builder);
    }

    public static class AdvanceBlockMatchToolSerializer
    implements Serializer<AdvanceBlockMatchTool> {
        public void serialize(JsonObject object, AdvanceBlockMatchTool matchTool, JsonSerializationContext context) {
            object.addProperty("slot", matchTool.slot.m_20751_());
            object.add("predicate", matchTool.predicate.m_45048_());
        }

        public AdvanceBlockMatchTool deserialize(JsonObject object, JsonDeserializationContext context) {
            EquipmentSlot slot = EquipmentSlot.m_20747_((String)object.get("slot").getAsString());
            ItemPredicate itemPredicate = ItemPredicate.m_45051_((JsonElement)object.get("predicate"));
            return new AdvanceBlockMatchTool(slot, itemPredicate);
        }
    }
}

