/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen;

import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.Nullable;

public enum NinePart implements StringRepresentable
{
    LEFT_UP("left_up", -1, -1),
    UP("up", 0, -1),
    RIGHT_UP("right_up", 1, -1),
    LEFT_CENTER("left_center", -1, 0),
    CENTER("center", 0, 0),
    RIGHT_CENTER("right_center", 1, 0),
    LEFT_DOWN("left_down", -1, 1),
    DOWN("down", 0, 1),
    RIGHT_DOWN("right_down", 1, 1);

    private final String name;
    private final int posX;
    private final int posY;

    private NinePart(String name, int posX, int posY) {
        this.name = name;
        this.posX = posX;
        this.posY = posY;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public String toString() {
        return String.format("%s[%d, %d]", this.m_7912_(), this.posX, this.posY);
    }

    public String m_7912_() {
        return this.name;
    }

    public boolean isCenter() {
        return this == CENTER;
    }

    @Nullable
    public static NinePart getPartByPos(int x, int y) {
        for (NinePart part : NinePart.values()) {
            if (part.getPosX() != x || part.getPosY() != y) continue;
            return part;
        }
        return null;
    }
}

