/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IPot;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.PotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSoundType;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PotBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty HAS_OIL = BooleanProperty.m_61465_((String)"has_oil");
    public static final BooleanProperty SHOW_OIL = BooleanProperty.m_61465_((String)"show_oil");
    public static final BooleanProperty HAS_BASE = BooleanProperty.m_61465_((String)"has_base");
    private static final VoxelShape AABB = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final double DURABILITY_COST_PROBABILITY = 0.25;

    public PotBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(ModSoundType.POT).m_60955_().m_60913_(1.5f, 6.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.SOUTH)).m_61124_((Property)HAS_OIL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SHOW_OIL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_BASE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        if (direction == Direction.DOWN) {
            return (BlockState)state.m_61124_((Property)HAS_BASE, (Comparable)Boolean.valueOf(!neighborState.m_60783_((BlockGetter)levelAccessor, neighborPos, Direction.UP)));
        }
        return super.m_7417_(state, direction, neighborState, levelAccessor, pos, neighborPos);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            IPot pot;
            Player player = (Player)placer;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof IPot && (pot = (IPot)blockEntity).hasHeatSource(level)) {
                ModTrigger.EVENT.trigger((LivingEntity)player, "place_pot_on_heat_source");
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof IPot)) {
            return InteractionResult.PASS;
        }
        IPot pot = (IPot)blockEntity;
        ItemStack itemInHand = player.m_21120_(hand);
        RandomSource random = level.f_46441_;
        if ((itemInHand.m_41619_() || itemInHand.m_204117_(TagMod.INGREDIENT_CONTAINER)) && pot.removeIngredient(level, (LivingEntity)player)) {
            return InteractionResult.SUCCESS;
        }
        if (pot.takeOutProduct(level, (LivingEntity)player, player.m_21205_())) {
            return InteractionResult.SUCCESS;
        }
        if (!pot.hasHeatSource(level)) {
            this.sendBarMessage(player, "tip.kaleidoscope_cookery.pot.need_lit_stove");
            return InteractionResult.FAIL;
        }
        if (!((Boolean)state.m_61143_((Property)HAS_OIL)).booleanValue()) {
            if (pot.onPlaceOil(level, (LivingEntity)player, itemInHand)) {
                return InteractionResult.SUCCESS;
            }
            this.sendBarMessage(player, "tip.kaleidoscope_cookery.pot.need_oil");
            return InteractionResult.FAIL;
        }
        if (itemInHand.m_204117_(TagMod.KITCHEN_SHOVEL)) {
            if (level.f_46441_.m_188500_() < 0.25) {
                itemInHand.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
            }
            pot.onShovelHit(level, (LivingEntity)player, itemInHand);
            level.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 1.0f + (random.m_188501_() - random.m_188501_()) * 0.8f);
            return InteractionResult.SUCCESS;
        }
        if (pot.addIngredient(level, (LivingEntity)player, itemInHand)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void sendBarMessage(Player player, String key) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MutableComponent message = Component.m_237115_((String)key);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PotBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.f_46443_) {
            return null;
        }
        if (!((Boolean)state.m_61143_((Property)HAS_OIL)).booleanValue()) {
            return null;
        }
        return PotBlock.createTickerHelper(blockEntityType, (BlockEntityType)ModBlocks.POT_BE.get(), (levelIn, pos, stateIn, pot) -> pot.tick(levelIn));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        BlockState belowState = context.m_43725_().m_8055_(context.m_8083_().m_7495_());
        if (!belowState.m_60783_((BlockGetter)context.m_43725_(), context.m_8083_().m_7495_(), Direction.UP)) {
            return (BlockState)blockState.m_61124_((Property)HAS_BASE, (Comparable)Boolean.valueOf(true));
        }
        return blockState;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HAS_OIL, SHOW_OIL, HAS_BASE, f_54117_, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return AABB;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.kaleidoscope_cookery.pot").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.kaleidoscope_cookery.pot.fail").m_130940_(ChatFormatting.GRAY));
    }
}

