/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.ISteamer;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.SteamerBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.item.SteamerItem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SteamerBlock
extends FallingBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty HALF = BooleanProperty.m_61465_((String)"half");
    public static final BooleanProperty HAS_LID = BooleanProperty.m_61465_((String)"has_lid");
    public static final BooleanProperty HAS_BASE = BooleanProperty.m_61465_((String)"has_base");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape HALF_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape FULL_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public SteamerBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60966_().m_60955_().m_278166_(PushReaction.DESTROY).m_60918_(SoundType.f_56754_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HALF, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HAS_LID, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_BASE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return SteamerBlock.createTickerHelper(blockEntityType, (BlockEntityType)ModBlocks.STEAMER_BE.get(), (levelIn, blockPos, blockState, steamer) -> steamer.tick(levelIn));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer instanceof ServerPlayer) {
            ISteamer steamer;
            ServerPlayer player = (ServerPlayer)placer;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ISteamer && (steamer = (ISteamer)blockEntity).hasHeatSource(level)) {
                ModTrigger.EVENT.trigger((LivingEntity)player, "use_steamer");
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState below = level.m_8055_(pos.m_7495_());
        if (SteamerBlock.m_53241_((BlockState)below) && pos.m_123342_() >= level.m_141937_()) {
            CompoundTag blockEntityTag = null;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SteamerBlockEntity) {
                SteamerBlockEntity steamer = (SteamerBlockEntity)blockEntity;
                blockEntityTag = steamer.m_187482_();
            }
            FallingBlockEntity fall = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_((Property)HAS_BASE, (Comparable)Boolean.valueOf(false))));
            fall.f_31944_ = blockEntityTag;
            this.m_6788_(fall);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        levelAccessor.m_186460_(pos, (Block)this, this.m_7198_());
        if (direction == Direction.DOWN) {
            state = SteamerBlock.m_53241_((BlockState)neighborState) ? (BlockState)state.m_61124_((Property)HAS_BASE, (Comparable)Boolean.valueOf(false)) : (BlockState)state.m_61124_((Property)HAS_BASE, (Comparable)Boolean.valueOf(this.shouldHasBase(levelAccessor, pos)));
        }
        if (direction == Direction.UP && neighborState.m_60713_((Block)this)) {
            state = (BlockState)state.m_61124_((Property)HAS_LID, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemInHand = player.m_21120_(hand);
        Boolean hasLid = (Boolean)state.m_61143_((Property)HAS_LID);
        if (itemInHand.m_41619_() && player.m_36341_() && (hasLid.booleanValue() || !level.m_8055_(pos.m_7494_()).m_60713_((Block)this))) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_LID, (Comparable)Boolean.valueOf(hasLid == false)), 3);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (itemInHand.m_150930_(this.m_5456_())) {
            Item item;
            if (((Boolean)state.m_61143_((Property)HALF)).booleanValue() && (item = itemInHand.m_41720_()) instanceof SteamerItem) {
                SteamerItem steamerItem = (SteamerItem)item;
                return steamerItem.m_40576_(new BlockPlaceContext(player, hand, itemInHand, hit));
            }
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ISteamer) {
            ISteamer steamer = (ISteamer)blockEntity;
            if (steamer.placeFood(level, (LivingEntity)player, itemInHand)) {
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (steamer.takeFood(level, (LivingEntity)player)) {
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos clickedPos = context.m_8083_();
        BlockState blockState = context.m_43725_().m_8055_(clickedPos);
        FluidState fluidState = context.m_43725_().m_6425_(clickedPos);
        BlockState resultState = blockState.m_60713_((Block)this) ? (BlockState)blockState.m_61124_((Property)HALF, (Comparable)Boolean.valueOf(false)) : (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        if (SteamerBlock.m_53241_((BlockState)context.m_43725_().m_8055_(clickedPos.m_7495_()))) {
            return (BlockState)resultState.m_61124_((Property)HAS_BASE, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)resultState.m_61124_((Property)HAS_BASE, (Comparable)Boolean.valueOf(this.shouldHasBase((LevelAccessor)context.m_43725_(), clickedPos)));
    }

    private boolean shouldHasBase(LevelAccessor level, BlockPos pos) {
        BlockState belowState = level.m_8055_(pos.m_7495_());
        if (belowState.m_60713_((Block)this)) {
            return false;
        }
        if (belowState.m_61138_((Property)BlockStateProperties.f_61443_)) {
            return true;
        }
        if (belowState.m_204336_(TagMod.HEAT_SOURCE_BLOCKS_WITHOUT_LIT)) {
            return true;
        }
        return !belowState.m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP);
    }

    public void m_48792_(Level level, BlockPos pos, BlockState state, BlockState replaceableState, FallingBlockEntity fallingBlock) {
        if (this.shouldHasBase((LevelAccessor)level, pos)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_BASE, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        ItemStack itemInHand = context.m_43722_();
        return (Boolean)state.m_61143_((Property)HALF) != false && itemInHand.m_150930_(this.m_5456_());
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF, HAS_LID, HAS_BASE, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return (Boolean)state.m_61143_((Property)HALF) != false ? HALF_AABB : FULL_AABB;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SteamerBlockEntity(pos, state);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder lootParamsBuilder) {
        BlockEntity parameter = (BlockEntity)lootParamsBuilder.m_287261_(LootContextParams.f_81462_);
        if (parameter instanceof SteamerBlockEntity) {
            SteamerBlockEntity steamer = (SteamerBlockEntity)parameter;
            return steamer.dropAsItem();
        }
        return super.m_49635_(state, lootParamsBuilder);
    }
}

