/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.blockentity.decoration;

import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.OilPotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.BaseBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.inventory.itemhandler.OilPotHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OilPotBlockEntity
extends BaseBlockEntity {
    public static final int MAX_OIL_COUNT = 256;
    private static final String OIL_COUNT = "OilCount";
    private LazyOptional<IItemHandler> invHandler;
    private int oilCount = 0;

    public OilPotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.OIL_POT_BE.get(), pos, state);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(OIL_COUNT, this.oilCount);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(OIL_COUNT)) {
            this.oilCount = tag.m_128451_(OIL_COUNT);
        }
    }

    public int getOilCount() {
        return this.oilCount;
    }

    public void setOilCount(int oilCount) {
        this.oilCount = oilCount;
        this.refresh();
        if (this.f_58857_ == null) {
            return;
        }
        BlockState state = this.m_58900_();
        boolean hasOil = (Boolean)state.m_61143_((Property)OilPotBlock.HAS_OIL);
        if (!hasOil && oilCount > 0) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)OilPotBlock.HAS_OIL, (Comparable)Boolean.valueOf(true)), 3);
            return;
        }
        if (hasOil && oilCount <= 0) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)OilPotBlock.HAS_OIL, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && !this.f_58859_) {
            if (this.invHandler == null) {
                this.invHandler = LazyOptional.of(() -> new OilPotHandler(this));
            }
            return this.invHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_155250_(BlockState blockState) {
        super.m_155250_(blockState);
        if (this.invHandler != null) {
            LazyOptional<IItemHandler> oldHandler = this.invHandler;
            this.invHandler = null;
            oldHandler.invalidate();
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.invHandler != null) {
            this.invHandler.invalidate();
            this.invHandler = null;
        }
    }
}

