/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IPot;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.PotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.BaseBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModParticles;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteRegistry;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagCommon;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.item.KitchenShovelItem;
import com.github.ysbbbbbb.kaleidoscopecookery.item.OilPotItem;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PotBlockEntity
extends BaseBlockEntity
implements IPot {
    private static final int PUT_INGREDIENT_TIME = 1200;
    private static final int TAKEOUT_TIME = 800;
    private static final int BURNT_TIME = 400;
    private static final String INPUTS = "Inputs";
    private static final String CARRIER = "Carrier";
    private static final String RESULT = "Result";
    private static final String STATUS = "Status";
    private static final String CURRENT_TICK = "CurrentTick";
    private static final String STIR_FRY_COUNT = "StirFryCount";
    private static final String SEED = "Seed";
    private NonNullList<ItemStack> inputs = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private Ingredient carrier = Ingredient.f_43901_;
    private ItemStack result = ItemStack.f_41583_;
    private int status = 0;
    private int currentTick = 0;
    private int stirFryCount = 0;
    public long seed;
    public StirFryAnimationData animationData = new StirFryAnimationData();

    public PotBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlocks.POT_BE.get(), pPos, pBlockState);
        this.seed = System.currentTimeMillis();
    }

    @Override
    public boolean hasHeatSource(Level level) {
        BlockState belowState = level.m_8055_(this.f_58858_.m_7495_());
        if (belowState.m_61138_((Property)BlockStateProperties.f_61443_) && ((Boolean)belowState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            return true;
        }
        return belowState.m_204336_(TagMod.HEAT_SOURCE_BLOCKS_WITHOUT_LIT);
    }

    public void tick(Level level) {
        if (!this.hasHeatSource(level)) {
            return;
        }
        RandomSource random = level.f_46441_;
        if (this.currentTick > 0) {
            --this.currentTick;
            if (this.currentTick % 5 == 0) {
                this.refresh();
            }
            if (this.currentTick % 20 == 0) {
                level.m_5594_(null, this.f_58858_, SoundEvents.f_11936_, SoundSource.BLOCKS, 0.5f + random.m_188501_() / 0.5f, 0.8f + random.m_188501_() / 0.5f);
            }
        }
        if (this.status == 0) {
            this.tickPutIngredient(level, random);
            return;
        }
        if (this.status == 1) {
            this.tickCooking(level, random);
            return;
        }
        if (this.status == 2) {
            this.tickFinished(random);
            return;
        }
        if (this.status == 3) {
            this.tickBurnt(level, random);
        }
    }

    private void tickBurnt(Level level, RandomSource random) {
        ServerLevel serverLevel;
        Level level2;
        int particleCount = 10 - this.currentTick / 5;
        if (this.currentTick % 2 == 0 && (level2 = this.f_58857_) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level2;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)this.f_58858_.m_123342_() + 0.25 + random.m_188500_() / 3.0, (double)this.f_58858_.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), particleCount, 0.0, 0.0, 0.0, 0.05);
        }
        if (this.currentTick == 0) {
            this.reset();
            level.m_5594_(null, this.f_58858_, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, (random.m_188501_() - random.m_188501_()) * 0.8f);
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)this.f_58858_.m_123342_() + 0.25 + random.m_188500_() / 3.0, (double)this.f_58858_.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 8, 0.0, 0.0, 0.0, 0.05);
                int count = 1 + random.m_188503_(3);
                Block.m_49840_((Level)level, (BlockPos)this.f_58858_, (ItemStack)new ItemStack((ItemLike)Items.f_42414_, count));
            }
        }
    }

    private void tickFinished(RandomSource random) {
        Level level;
        if (this.currentTick % 10 == 0 && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.1 + random.m_188500_() / 2.0, (double)this.f_58858_.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.currentTick == 0) {
            this.status = 3;
            this.currentTick = 400;
            this.m_6596_();
        }
    }

    private void tickCooking(Level level, RandomSource random) {
        if (this.currentTick == 0) {
            level.m_5594_(null, this.f_58858_, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, (random.m_188501_() - random.m_188501_()) * 0.8f);
            this.status = 2;
            if (this.stirFryCount > 0) {
                this.result = FoodBiteRegistry.getItem(FoodBiteRegistry.SUSPICIOUS_STIR_FRY).m_7968_();
                this.carrier = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42399_});
            }
            this.currentTick = 800;
            this.m_6596_();
            BlockState state = level.m_8055_(this.f_58858_);
            level.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)PotBlock.SHOW_OIL, (Comparable)Boolean.valueOf(false)));
        }
    }

    private void tickPutIngredient(Level level, RandomSource random) {
        ServerLevel serverLevel;
        if (this.currentTick % 10 == 0 && level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)this.f_58858_.m_123341_() + 0.5 + random.m_188500_() / 5.0 * (double)(random.m_188499_() ? 1 : -1), (double)this.f_58858_.m_123342_() + 0.1 + random.m_188500_() / 3.0, (double)this.f_58858_.m_123343_() + 0.5 + random.m_188500_() / 5.0 * (double)(random.m_188499_() ? 1 : -1), 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.currentTick == 0) {
            if (this.isEmpty()) {
                this.reset();
                level.m_5594_(null, this.f_58858_, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, (random.m_188501_() - random.m_188501_()) * 0.8f);
                Level level2 = this.f_58857_;
                if (level2 instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level2;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)this.f_58858_.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)this.f_58858_.m_123342_() + 0.1 + random.m_188500_() / 3.0, (double)this.f_58858_.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 8, 0.0, 0.0, 0.0, 0.05);
                }
            } else {
                this.startCooking(level);
            }
        }
    }

    @Override
    public boolean onPlaceOil(Level level, LivingEntity user, ItemStack stack) {
        if (stack.m_204117_(TagMod.OIL)) {
            this.placeOil(level, user, level.f_46441_);
            stack.m_41774_(1);
            ModTrigger.EVENT.trigger(user, "put_oil_in_pot");
            return true;
        }
        if (stack.m_150930_((Item)ModItems.KITCHEN_SHOVEL.get()) && KitchenShovelItem.hasOil(stack)) {
            this.placeOil(level, user, level.f_46441_);
            KitchenShovelItem.setHasOil(stack, false);
            ModTrigger.EVENT.trigger(user, "put_oil_in_pot");
            return true;
        }
        if (stack.m_150930_((Item)ModItems.OIL_POT.get()) && OilPotItem.hasOil(stack)) {
            this.placeOil(level, user, level.f_46441_);
            OilPotItem.shrinkOilCount(stack);
            ModTrigger.EVENT.trigger(user, "put_oil_in_pot");
            return true;
        }
        return false;
    }

    private void placeOil(Level level, LivingEntity user, RandomSource random) {
        this.currentTick = 1200;
        BlockState state = level.m_8055_(this.f_58858_);
        level.m_46597_(this.f_58858_, (BlockState)((BlockState)state.m_61124_((Property)PotBlock.HAS_OIL, (Comparable)Boolean.valueOf(true))).m_61124_((Property)PotBlock.SHOW_OIL, (Comparable)Boolean.valueOf(true)));
        level.m_245803_((Entity)user, this.f_58858_, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, (random.m_188501_() - random.m_188501_()) * 0.8f);
        for (int i = 0; i < 10; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)this.f_58858_.m_123342_() + 0.25 + random.m_188500_() / 3.0, (double)this.f_58858_.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.05, 0.0);
        }
    }

    @Override
    public void onShovelHit(Level level, LivingEntity user, ItemStack shovel) {
        Level level2;
        if (!level.f_46443_) {
            this.seed = System.currentTimeMillis();
            this.refresh();
        }
        if ((level2 = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            RandomSource random = serverLevel.f_46441_;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)this.f_58858_.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)this.f_58858_.m_123342_() + 0.1 + random.m_188500_() / 3.0, (double)this.f_58858_.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 1, 0.0, 0.0, 0.0, 0.05);
        }
        if (this.status == 0 && !this.isEmpty()) {
            this.startCooking(level);
            ModTrigger.EVENT.trigger(user, "stir_fry_in_pot");
        }
        if (this.status == 1 && this.stirFryCount > 0) {
            --this.stirFryCount;
            ModTrigger.EVENT.trigger(user, "stir_fry_in_pot");
        }
    }

    private void startCooking(Level level) {
        SimpleContainer container = this.getContainer();
        level.m_7465_().m_44015_(ModRecipes.POT_RECIPE, (Container)container, level).ifPresentOrElse(recipe -> {
            this.carrier = recipe.carrier();
            this.result = recipe.m_5874_(container, level.m_9598_());
            this.currentTick = recipe.time();
            this.stirFryCount = recipe.stirFryCount();
        }, () -> {
            this.carrier = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42399_});
            this.result = FoodBiteRegistry.getItem(FoodBiteRegistry.SUSPICIOUS_STIR_FRY).m_7968_();
            this.currentTick = 200;
            this.stirFryCount = 0;
        });
        this.status = 1;
        this.refresh();
    }

    @Override
    public boolean takeOutProduct(Level level, LivingEntity user, ItemStack stack) {
        ItemStack finallyResult;
        if (this.status != 2 && this.status != 3) {
            return false;
        }
        ItemStack itemStack = finallyResult = this.status == 2 ? this.result : FoodBiteRegistry.getItem(FoodBiteRegistry.DARK_CUISINE).m_7968_();
        if (finallyResult.m_150930_(FoodBiteRegistry.getItem(FoodBiteRegistry.SUSPICIOUS_STIR_FRY)) && stack.m_204117_(TagCommon.COOKED_RICE)) {
            stack.m_41774_(1);
            ItemUtils.getItemToLivingEntity(user, ((Item)ModItems.SUSPICIOUS_STIR_FRY_RICE_BOWL.get()).m_7968_());
            this.reset();
            return true;
        }
        if (!this.carrier.m_43947_()) {
            return this.takeOutWithCarrier(level, user, stack, finallyResult);
        }
        return this.takeOutWithoutCarrier(level, user, stack, finallyResult);
    }

    private boolean takeOutWithoutCarrier(Level level, LivingEntity user, ItemStack stack, ItemStack finallyResult) {
        if (stack.m_204117_(TagMod.KITCHEN_SHOVEL)) {
            Player player;
            if (user instanceof Player && !(player = (Player)user).m_36341_()) {
                return false;
            }
            ItemUtils.getItemToLivingEntity(user, finallyResult);
            this.reset();
            return true;
        }
        if (this.hasHeatSource(level)) {
            user.m_6469_(level.m_269111_().m_269387_(), 1.0f);
            ModTrigger.EVENT.trigger(user, "hurt_when_takeout_from_pot");
        }
        this.sendActionBarMessage(user, "need_kitchen_shovel", new Object[0]);
        return false;
    }

    private boolean takeOutWithCarrier(Level level, LivingEntity user, ItemStack mainHandItem, ItemStack finallyResult) {
        Component carrierName = this.carrier.m_43908_()[0].m_41786_();
        if (this.carrier.test(mainHandItem)) {
            if (mainHandItem.m_41613_() < finallyResult.m_41613_()) {
                this.sendActionBarMessage(user, "carrier_count_not_enough", finallyResult.m_41613_(), carrierName);
                return false;
            }
            mainHandItem.m_41774_(finallyResult.m_41613_());
            ItemUtils.getItemToLivingEntity(user, finallyResult);
            this.reset();
            return true;
        }
        if (!mainHandItem.m_204117_(TagMod.KITCHEN_SHOVEL)) {
            if (this.hasHeatSource(level)) {
                user.m_6469_(level.m_269111_().m_269387_(), 1.0f);
                ModTrigger.EVENT.trigger(user, "hurt_when_takeout_from_pot");
            }
            this.sendActionBarMessage(user, "need_carrier", carrierName);
        }
        return false;
    }

    private void sendActionBarMessage(LivingEntity user, String type, Object ... args) {
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            String key = "tip.kaleidoscope_cookery.pot." + type;
            MutableComponent message = Component.m_237110_((String)key, (Object[])args);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        }
    }

    public void addAllIngredients(List<ItemStack> ingredients, LivingEntity user) {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.status != 0) {
            return;
        }
        for (int i = 0; i < Math.min(ingredients.size(), this.inputs.size()); ++i) {
            ItemStack stack = ingredients.get(i);
            if (stack.m_41619_()) continue;
            Item containerItem = ItemUtils.getContainerItem(stack);
            if (containerItem != Items.f_41852_) {
                ItemUtils.getItemToLivingEntity(user, containerItem.m_7968_());
            }
            this.inputs.set(i, (Object)stack.m_255036_(1));
        }
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12028_, SoundSource.BLOCKS, 1.0f, 0.5f);
        this.refresh();
    }

    @Override
    public boolean addIngredient(Level level, LivingEntity user, ItemStack itemStack) {
        if (this.status != 0) {
            return false;
        }
        if (!itemStack.m_41614_() && !itemStack.m_204117_(TagMod.POT_INGREDIENT)) {
            return false;
        }
        for (int i = 0; i < this.inputs.size(); ++i) {
            ItemStack item = (ItemStack)this.inputs.get(i);
            if (!item.m_41619_()) continue;
            Item containerItem = ItemUtils.getContainerItem(itemStack);
            if (containerItem != Items.f_41852_) {
                ItemUtils.getItemToLivingEntity(user, containerItem.m_7968_());
            }
            this.inputs.set(i, (Object)itemStack.m_41620_(1));
            level.m_5594_(null, this.f_58858_, SoundEvents.f_12028_, SoundSource.BLOCKS, 1.0f, 0.5f);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIngredient(Level level, LivingEntity user) {
        if (this.status != 0) {
            return false;
        }
        for (int i = this.inputs.size() - 1; i >= 0; --i) {
            ItemStack stack = (ItemStack)this.inputs.get(i);
            if (stack.m_41619_()) continue;
            if (!this.containerIsMatch(user, stack)) {
                return false;
            }
            this.inputs.set(i, (Object)ItemStack.f_41583_);
            ItemUtils.getItemToLivingEntity(user, stack);
            if (this.hasHeatSource(level)) {
                user.m_6469_(level.m_269111_().m_269387_(), 1.0f);
                ModTrigger.EVENT.trigger(user, "hurt_when_takeout_from_pot");
            }
            return true;
        }
        return false;
    }

    private boolean containerIsMatch(LivingEntity user, ItemStack stack) {
        Item containerItem = ItemUtils.getContainerItem(stack);
        if (containerItem == Items.f_41852_) {
            return true;
        }
        if (user.m_21205_().m_150930_(containerItem)) {
            user.m_21205_().m_41774_(1);
            return true;
        }
        if (user instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)user;
            player.m_213846_((Component)Component.m_237110_((String)"tip.kaleidoscope_cookery.kitchen.remove_ingredient.need_container", (Object[])new Object[]{containerItem.m_7968_().m_41786_()}));
        }
        return false;
    }

    public void reset() {
        this.inputs.clear();
        this.carrier = Ingredient.f_43901_;
        this.result = ItemStack.f_41583_;
        this.status = 0;
        this.currentTick = 0;
        this.stirFryCount = 0;
        this.m_6596_();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)((BlockState)state.m_61124_((Property)PotBlock.HAS_OIL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PotBlock.SHOW_OIL, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(INPUTS, (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), this.inputs));
        tag.m_128359_(CARRIER, this.carrier.m_43942_().toString());
        tag.m_128365_(RESULT, (Tag)this.result.serializeNBT());
        tag.m_128405_(STATUS, this.status);
        tag.m_128405_(CURRENT_TICK, this.currentTick);
        tag.m_128405_(STIR_FRY_COUNT, this.stirFryCount);
        tag.m_128356_(SEED, this.seed);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputs = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        if (tag.m_128425_(INPUTS, 10)) {
            ContainerHelper.m_18980_((CompoundTag)tag.m_128469_(INPUTS), this.inputs);
        }
        if (tag.m_128425_(CARRIER, 8)) {
            JsonElement element = JsonParser.parseString((String)tag.m_128461_(CARRIER));
            this.carrier = Ingredient.m_43917_((JsonElement)element);
        }
        if (tag.m_128425_(RESULT, 10)) {
            this.result = ItemStack.m_41712_((CompoundTag)tag.m_128469_(RESULT));
        }
        this.status = tag.m_128451_(STATUS);
        this.currentTick = tag.m_128451_(CURRENT_TICK);
        this.stirFryCount = tag.m_128451_(STIR_FRY_COUNT);
        this.seed = tag.m_128454_(SEED);
    }

    public List<ItemStack> getInputs() {
        return this.inputs;
    }

    public SimpleContainer getContainer() {
        SimpleContainer container = new SimpleContainer(9);
        for (int i = 0; i < this.inputs.size(); ++i) {
            ItemStack stack = (ItemStack)this.inputs.get(i);
            if (stack.m_41619_()) continue;
            container.m_6836_(i, stack);
        }
        return container;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.inputs) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public boolean hasCarrier() {
        return !this.carrier.m_43947_();
    }

    public ItemStack getResult() {
        return this.result;
    }

    public long getSeed() {
        return this.seed;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public static class StirFryAnimationData {
        public long preSeed = -1L;
        public long timestamp = -1L;
        public float[] randomHeights = new float[0];
    }
}

