/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.resources;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public record ItemRenderReplacer(Map<ResourceLocation, ResourceLocation> pot, Map<ResourceLocation, ResourceLocation> stockpotCooking, Map<ResourceLocation, ResourceLocation> stockpotFinished, Map<ResourceLocation, ResourceLocation> millstone, Map<ResourceLocation, ResourceLocation> steamer) {
    public static final Codec<ResourceLocation> RL_CODEC = Codec.STRING.comapFlatMap(ItemRenderReplacer::parseModelLocation, ResourceLocation::toString).stable();
    public static final Codec<ItemRenderReplacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, RL_CODEC).fieldOf("pot").forGetter(ItemRenderReplacer::pot), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, RL_CODEC).fieldOf("stockpot_cooking").forGetter(ItemRenderReplacer::stockpotCooking), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, RL_CODEC).fieldOf("stockpot_finished").forGetter(ItemRenderReplacer::stockpotFinished), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, RL_CODEC).fieldOf("millstone").forGetter(ItemRenderReplacer::millstone), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, RL_CODEC).fieldOf("steamer").forGetter(ItemRenderReplacer::steamer)).apply((Applicative)instance, ItemRenderReplacer::new));
    private static Function<ResourceLocation, BakedModel> CACHE = ItemRenderReplacer.createNewCache();

    public ItemRenderReplacer() {
        this(Maps.newHashMap(), Maps.newHashMap(), Maps.newHashMap(), Maps.newHashMap(), Maps.newHashMap());
    }

    private static Function<ResourceLocation, BakedModel> createNewCache() {
        return Util.m_143827_(id -> {
            ModelManager modelManager = Minecraft.m_91087_().m_91291_().m_115103_().m_109393_();
            if (id instanceof ModelResourceLocation) {
                ModelResourceLocation modelRl = (ModelResourceLocation)id;
                return modelManager.m_119422_(modelRl);
            }
            return modelManager.getModel(id);
        });
    }

    public static void resetCache() {
        CACHE = ItemRenderReplacer.createNewCache();
    }

    public static BakedModel getModel(@Nullable Level level, ItemStack stack, Map<ResourceLocation, ResourceLocation> models) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (key == null) {
            return itemRenderer.m_174264_(stack, level, null, 0);
        }
        ResourceLocation location = models.get(key);
        if (location == null) {
            return itemRenderer.m_174264_(stack, level, null, 0);
        }
        return CACHE.apply(location);
    }

    private static DataResult<ResourceLocation> parseModelLocation(String input) {
        String[] split = input.split("#");
        if (split.length > 1) {
            return DataResult.success((Object)new ModelResourceLocation(new ResourceLocation(split[0]), split[1]));
        }
        return DataResult.success((Object)new ResourceLocation(input));
    }

    public void addAll(ItemRenderReplacer other) {
        this.pot.putAll(other.pot);
        this.stockpotCooking.putAll(other.stockpotCooking);
        this.stockpotFinished.putAll(other.stockpotFinished);
        this.millstone.putAll(other.millstone);
        this.steamer.putAll(other.steamer);
    }
}

